/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.init;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;
import jp.terasoluna.fw.batch.core.JobStatus;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndFileChecker
extends TimerTask {
    private static Log log = LogFactory.getLog(EndFileChecker.class);
    private static final String EXTENSION_IMMEDIATE = "end";
    private static final String EXTENSION_GRACEFUL = "irp";
    private Map<String, JobStatus> jobStatusMap = new HashMap<String, JobStatus>();
    private String endFileDir = null;

    @Override
    public synchronized void run() {
        File dir = new File(this.endFileDir);
        if (!this.jobStatusMap.isEmpty()) {
            this.processEnd(dir);
        }
    }

    public void addParentJobStatus(JobStatus jobStatus, String jobID, String jobOptionID) {
        if (jobStatus == null || jobID == null || "".equals(jobID)) {
            return;
        }
        if (jobOptionID == null || "".equals(jobOptionID)) {
            this.addJobStatus(jobID, jobStatus);
        } else {
            this.addJobStatus(jobID + "_" + jobOptionID, jobStatus);
        }
    }

    public void removeParentJobStatus(JobStatus jobStatus, String jobID, String jobOptionID) {
        if (jobStatus == null || jobID == null || "".equals(jobID)) {
            return;
        }
        String key = null;
        key = jobOptionID == null || "".equals(jobOptionID) ? jobID : jobID + "_" + jobOptionID;
        JobStatus registedJobStatus = this.jobStatusMap.get(key);
        if (jobStatus.equals(registedJobStatus)) {
            this.removeJobStatus(key);
        }
    }

    private void processEnd(File endFileDir) {
        String[] fileNames = endFileDir.list();
        if (fileNames == null || fileNames.length == 0) {
            return;
        }
        for (String fileName : fileNames) {
            String[] splitFileName = fileName.split("[.]");
            if (splitFileName.length != 2) continue;
            String endFileName = splitFileName[0];
            String endType = splitFileName[1];
            if (EXTENSION_GRACEFUL.equals(endType) || EXTENSION_IMMEDIATE.equals(endType)) {
                List<String> processKey = this.getProcessKey(endFileName);
                this.endJob(endType, processKey);
                continue;
            }
            log.warn((Object)("\"" + fileName + "\" is invalid file extension."));
        }
    }

    private void endJob(String endType, List<String> processKey) {
        for (String key : processKey) {
            JobStatus jobStatus = this.jobStatusMap.get(key);
            if (EXTENSION_IMMEDIATE.equals(endType)) {
                jobStatus.shutdownImmediate();
                if (log.isInfoEnabled()) {
                    log.info((Object)(key + " shutdown_immediate"));
                }
                this.removeJobStatus(key);
                continue;
            }
            if (!EXTENSION_GRACEFUL.equals(endType)) continue;
            jobStatus.shutdownGraceful();
            if (log.isInfoEnabled()) {
                log.info((Object)(key + " shutdown_graceful"));
            }
            this.removeJobStatus(key);
        }
    }

    private void addJobStatus(String key, JobStatus jobStatus) {
        this.jobStatusMap.put(key, jobStatus);
        if (log.isDebugEnabled()) {
            log.debug((Object)(key + " jobstatus was added to the map."));
        }
    }

    private void removeJobStatus(String key) {
        this.jobStatusMap.remove(key);
        if (log.isDebugEnabled()) {
            log.debug((Object)(key + " jobstatus removed from the map."));
        }
    }

    private List<String> getProcessKey(String endFileName) {
        Set<String> keyset = this.jobStatusMap.keySet();
        ArrayList<String> processKey = new ArrayList<String>();
        String processKeyPrefix = endFileName + "_";
        for (String jobStatusKey : keyset) {
            if (!jobStatusKey.equals(endFileName) && !jobStatusKey.startsWith(processKeyPrefix)) continue;
            processKey.add(jobStatusKey);
        }
        return processKey;
    }

    public void setEndFileDir(String endFileDir) {
        this.endFileDir = endFileDir;
    }
}

