// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using System.Xml;
using TERASOLUNA.Fw.Common.Configuration;

namespace TERASOLUNA.Fw.Web.Configuration.Sql
{
    /// <summary>
    /// \t@C sqlConfiguration ZNV\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ConfigurationSection"/> NXgAsqlConfiguration JX^\nhłB
    /// ڍׂɂẮA<see cref="ConfigurationSection"/> QƂĂB
    /// </remarks>
    public class SqlConfigurationSection : ConfigurationSection
    {
        /// <summary>
        /// sqlConfiguration ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "sqlConfiguration" łB
        /// </remarks>
        private const string SECTION_NAME = "sqlConfiguration";

        /// <summary>
        /// <see cref="FilesCollection"/> ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "files" łB
        /// </remarks>
        private const string FILES_ELEMENT_NAME = "files";

        /// <summary>
        /// <see cref="SqlsCollection"/> ̗vfłB
        /// </summary>
        private const string SQLS_ELEMENT_NAME = "sqls";

        /// <summary>
        /// sql vf name łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "name" łB
        /// </remarks>
        private const string NAME_ATTRIBUTE_NAME = "name";

        /// <summary>
        /// Oݒt@C XML OԂłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "http://www.terasoluna.jp/schema/SqlSchema.xsd" łB
        /// </remarks>
        private const string XML_NAMESPACE = "http://www.terasoluna.jp/schema/SqlSchema.xsd";

        /// <summary>
        /// Oݒt@C XML OԃvtBbNXłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "sql" łB
        /// </remarks>
        private const string XML_NAMESPACE_PREFIX = "sql";

        /// <summary>
        /// Oݒt@C}[WŊƂvf XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "sql:sqlConfiguration" łB
        /// </remarks>
        private const string SECTION_XPATH = XML_NAMESPACE_PREFIX + ":sqlConfiguration";

        /// <summary>
        /// Oݒt@C}[WŃ}[Wvf XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "sql:sqlConfiguration/sql:sql" łB
        /// </remarks>
        private const string ELEMENT_XPATH = SECTION_XPATH + "/" + XML_NAMESPACE_PREFIX + ":sql";

        /// <summary>
        /// XML XL[}t@C̊SłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "TERASOLUNA.Fw.Web.Configuration.Sql.SqlConfiguration.xsd" łB
        /// </remarks>
        private const string XML_SCHEMA_FILE_NAME = "TERASOLUNA.Fw.Web.Configuration.Sql.SqlConfiguration.xsd";

        /// <summary>
        /// <see cref="SqlConfigurationSection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public SqlConfigurationSection()
        {
        }

        /// <summary>
        /// files vf擾܂B
        /// </summary>
        /// <remarks>
        /// sqlConfiguration ZNV <see cref="FilesCollection"/> 擾܂B
        /// </remarks>
        [ConfigurationProperty(FILES_ELEMENT_NAME, IsDefaultCollection = false, IsRequired = true)]
        public FilesCollection Files
        {
            get
            {
                FilesCollection filesCollection = (FilesCollection)base[FILES_ELEMENT_NAME];
                return filesCollection;
            }
        }

        /// <summary>
        /// sqls vf擾܂B
        /// </summary>
        /// <remarks>
        /// sqlConfiguration ZNV <see cref="SqlsCollection"/> 擾܂B
        /// </remarks>
        [ConfigurationProperty(SQLS_ELEMENT_NAME, IsDefaultCollection = false)]
        public SqlsCollection Sqls
        {
            get
            {
                SqlsCollection sqlsCollection = (SqlsCollection)base[SQLS_ELEMENT_NAME];
                return sqlsCollection;
            }
        }

        /// <summary>
        /// files vf̐ݒe sql vf𐶐 sqls vfɒǉ܂B
        /// </summary>
        /// <remarks>
        /// <para><see cref="MergeConfiguration"/> IuWFNg𐶐AOݒt@C̐ݒ}[W܂B</para>
        /// <para>}[WOݒt@C̓e <see cref="SqlElement"/> IuWFNg𐶐A <see cref="SqlsCollection"/> ɒǉ܂B</para>
        /// </remarks>
        /// <exception cref="ArgumentException">
        /// ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH słB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŃ}[Wvf XPATH słB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// \t@C̊Oݒt@C}[WŊƂvf XPATH ̐ݒ񂪕słB
        /// </item>
        /// <item>
        /// t@C̓ǂݍݎsłB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  XML XL[}؃G[łB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  Oݒt@C}[WŃ}[Wvf XPATH }[WɁAXML XL[}؃G[łB
        /// </item>
        /// </list>
        /// </exception>
        public virtual void CreateSqlElements()
        {
            // Oݒt@C̐ݒ}[W
            MergeConfiguration mgConfig = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            mgConfig.LoadConfig(SECTION_NAME, Files);
            XmlDocument xmlDoc = mgConfig.MergeXmlDocument(SECTION_XPATH, ELEMENT_XPATH);

            // Oݒt@C̐ݒsqlsvfɒǉ
            AddSqlElements(xmlDoc);
        }

        /// <summary>
        /// Oݒt@C̓e sql vf𐶐Asqls vfɒǉ܂B
        /// </summary>
        /// <param name="xmlDoc">Oݒt@C̓eێ <see cref="System.Xml.XmlDocument" /> B</param>s
        private void AddSqlElements(XmlDocument xmlDoc)
        {
            XmlNodeList xmlNL = xmlDoc.DocumentElement.ChildNodes;

            foreach (XmlNode xmlNode in xmlNL)
            {
                if (xmlNode is XmlElement)
                {
                    string name = xmlNode.Attributes[NAME_ATTRIBUTE_NAME].InnerText;
                    string statement = xmlNode.InnerText;
                    SqlElement sqlElement = new SqlElement(name, statement);
                    Sqls.Add(sqlElement);
                }
            }
        }

    }
}
