﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Data;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.CommonUT.BLogic
{
    /// <summary>
    /// NopBLogicのテストクラスです。
    ///</summary>
    [TestClass()]
    public class NopBLogicTest
    {

        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //ログの初期化
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// Execute (DataSet) のテスト
        /// </summary>
        /// <remarks>
        /// SUCCESSが返却されることを確認するテスト
        /// </remarks>
        [TestMethod()]
        public void ExecuteTest01()
        {
            //準備
            NopBLogic target = new NopBLogic();
            BLogicParam blogicParam = new BLogicParam();
            BLogicResult actual;

            //実行
            actual = target.Execute(blogicParam);

            //検証
            Assert.AreEqual(BLogicResult.SUCCESS, actual.ResultString);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NopBLogic), LogLevel.INFO));

        }

        /// <summary>
        /// Execute (DataSet) のテスト
        /// </summary>
        /// <remarks>
        /// blogicParamにnullを設定してもSUCCESSが返却されることを確認するテスト
        /// </remarks>
        [TestMethod()]
        public void ExecuteTest02()
        {
            //準備
            NopBLogic target = new NopBLogic();
            BLogicParam blogicParam = null;
            BLogicResult actual;

            //実行
            actual = target.Execute(blogicParam);

            //検証
            Assert.AreEqual(BLogicResult.SUCCESS, actual.ResultString);

            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(NopBLogic), LogLevel.INFO));
        }
    }
}
