// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;

namespace TERASOLUNA.Fw.Common.Logging
{
    /// <summary>
    /// O API 𒊏ۉVvȃÕC^[tFCXłB
    /// </summary>
    /// <remarks>
    /// ̃C^[tFCXNXɂ́A <see cref="LogFactory"/> ɂ
    /// CX^Xs悤ɂ邽߂ɁÃÓuOv\P
    ///  String ƂĎRXgN^Ȃ΂Ȃ܂B 
    /// </remarks> 
    public interface ILog
    {
        /// <summary>
        /// Trace x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// Ox trace ȏ̏ꍇ(String ̘Â悤) 
        /// dsȂ悤ɂ̃\bhĂ(`FbN)B
        /// </remarks>
        bool IsTraceEnabled { get; }

        /// <summary>
        /// Debug x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// Ox debug ȏ̏ꍇ(String ̘Â悤) 
        /// dsȂ悤ɂ̃\bhĂ(`FbN)B
        /// </remarks>
        bool IsDebugEnabled { get; }

        /// <summary>
        /// Info x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// Ox Info ȏ̏ꍇ(String ̘Â悤) 
        /// dsȂ悤ɂ̃\bhĂ(`FbN)B
        /// </remarks>
        bool IsInfoEnabled { get; }

        /// <summary>
        /// Warn x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// Ox Warn ȏ̏ꍇ(String ̘Â悤) 
        /// dsȂ悤ɂ̃\bhĂ(`FbN)B
        /// </remarks>
        bool IsWarnEnabled { get; }

        /// <summary>
        /// Error x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// Ox Error ȏ̏ꍇ(String ̘Â悤) 
        /// dsȂ悤ɂ̃\bhĂ(`FbN)B
        /// </remarks>
        bool IsErrorEnabled { get; }

        /// <summary>
        /// Fatal x̃OݗLǂ`FbN܂B
        /// </summary>
        /// <remarks>
        /// Ox Fatal ȏ̏ꍇ(String ̘Â悤) 
        /// dsȂ悤ɂ̃\bhĂ(`FbN)B
        /// </remarks>
        bool IsFatalEnabled { get; }

        /// <summary>
        /// Trace OxŃbZ[WOo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        void Trace(object message);

        /// <summary>
        /// Trace xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        void Trace(object message, Exception ex);

        /// <summary>
        /// Debug OxŃbZ[WOo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        void Debug(object message);

        /// <summary>
        /// Debug xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        void Debug(object message, Exception ex);

        /// <summary>
        /// Info OxŃbZ[WOo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        void Info(object message);

        /// <summary>
        /// Info xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        void Info(object message, Exception ex);

        /// <summary>
        /// Warn OxŃbZ[WOo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        void Warn(object message);

        /// <summary>
        /// Warn xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        void Warn(object message, Exception ex);

        /// <summary>
        /// Error OxŃbZ[WOo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        void Error(object message);

        /// <summary>
        /// Error xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        void Error(object message, Exception ex);

        /// <summary>
        /// Fatal OxŃbZ[WOo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        void Fatal(object message);

        /// <summary>
        /// Fatal xŃG[Oo͂܂B
        /// </summary>
        /// <param name="message">Oo͂郁bZ[WB</param>
        /// <param name="ex">Oo͂̌ƂȂOB</param>
        void Fatal(object message, Exception ex);
    }
}
