// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Controller;
using System.Web;
using System.IO;
using TERASOLUNA.Fw.WebUT;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Utlib.Logging;
using System.Reflection;
namespace TERASOLUNA.Fw.WebUT.Controller
{
    /// <summary>
    ///TERASOLUNA.Fw.Web.Controller.FileDownloadRequestController のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Web.Controller.FileDownloadRequestController 単体テストをここに含めます
    ///</summary>
   
    [TestClass()]
    public class FileDownloadRequestControllerTest
    {
        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        ///EncodeFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// 引数に全角文字を含む文字列を設定
        /// </TestCondition>
        /// <TestAssertion>エンコードされたファイル名が正しく取得できること。</TestAssertion>
        [TestMethod()]
        public void TestEncodeFileName01()
        {

            FileDownloadRequestController target = new FileDownloadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileDownloadRequestControllerAccessor accessor
                = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileDownloadRequestControllerAccessor(target);
            string fileName = "あいうえお.csv";

            string actual = accessor.EncodeFileName(fileName);

            Assert.AreEqual("?iso-2022-jp?B?GyRCJCIkJCQmJCgkKhsoQi5jc3Y=?=", actual);
            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadRequestController), LogLevel.INFO));

        }
        /// <summary>
        ///EncodeFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// 引数に半角文字を含む文字列を設定
        /// </TestCondition>
        /// <TestAssertion>エンコードされたファイル名が正しく取得できること。</TestAssertion>
        [TestMethod()]
        public void TestEncodeFileName02()
        {

            FileDownloadRequestController target = new FileDownloadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileDownloadRequestControllerAccessor accessor
                = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileDownloadRequestControllerAccessor(target);
            string fileName = "あいうえお.csv";

            string actual = accessor.EncodeFileName(fileName);

            Assert.AreEqual("?iso-2022-jp?B?GyRCJCIkJCQmJCgkKhsoQi5jc3Y=?=", actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadRequestController), LogLevel.INFO));

        }
        /// <summary>
        ///EncodeFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// 引数に空文字を設定
        /// </TestCondition>
        /// <TestAssertion>エンコードされたファイル名が正しく取得できること。</TestAssertion>
        [TestMethod()]
        public void TestEncodeFileName03()
        {

            FileDownloadRequestController target = new FileDownloadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileDownloadRequestControllerAccessor accessor
                = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileDownloadRequestControllerAccessor(target);
            string fileName = "";

            string actual = accessor.EncodeFileName(fileName);

            Assert.AreEqual("?iso-2022-jp?B??=", actual);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadRequestController), LogLevel.INFO));

        }
        /// <summary>
        ///EncodeFileName (string) のテスト
        ///</summary>
        /// <TestTarget>GetContentFileName</TestTarget>
        /// <TestCondition>
        /// 引数にnullを設定
        /// </TestCondition>
        /// <TestAssertion>エンコードされたファイル名が正しく取得できること。</TestAssertion>
        [TestMethod()]
        public void TestEncodeFileName04()
        {

            FileDownloadRequestController target = new FileDownloadRequestController();

            TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileDownloadRequestControllerAccessor accessor
                = new TERASOLUNA.Fw.WebUT.TERASOLUNA_Fw_Web_Controller_FileDownloadRequestControllerAccessor(target);
            string fileName = null;

            try
            {
                string actual = accessor.EncodeFileName(fileName);
                Assert.Fail("到達してはいけないコードです。" );
            }
            catch (TargetInvocationException te)
            {
                ArgumentNullException ae = te.InnerException as ArgumentNullException;
                Assert.IsInstanceOfType(te.InnerException, typeof(ArgumentNullException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(FileDownloadRequestController), LogLevel.INFO));
        }
    }
}
