// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using System.Xml;
using TERASOLUNA.Fw.Common.Configuration;

namespace TERASOLUNA.Fw.Web.Configuration.ExceptionTransition
{
    /// <summary>
    /// \t@C exceptionTransitionConfiguration ZNV\܂B
    /// </summary>
    /// <remarks>
    /// <see cref="ConfigurationSection"/> NXgAexceptionTransitionConfiguration JX^\nhłB
    /// ڍׂɂẮA<see cref="ConfigurationSection"/> QƂĂB
    /// </remarks>
    public class ExceptionTransitionConfigurationSection : ConfigurationSection
    {
        /// <summary>
        /// exceptionTransitionConfiguraiton ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exceptionTransitionConfiguration" łB
        /// </remarks>
        private const string SECTION_NAME = "exceptionTransitionConfiguration";

        /// <summary>
        /// mode ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "mode" łB
        /// </remarks>
        private const string MODE_ATTRIBUTE_NAME = "mode";

        /// <summary>
        /// logging ̑łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "logging" łB
        /// </remarks>
        private const string LOGGING_ATTRIBUTE_NAME = "logging";

        /// <summary>
        /// <see cref="FilesCollection"/> ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "files" łB
        /// </remarks>
        private const string FILES_ELEMENT_NAME = "files";

        /// <summary>
        /// <see cref="ExceptionTransitionCollection"/> ̗vfłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exceptionTransitionConfiguration" łB 
        /// </remarks>
        private const string EXCEPTION_TRANSITION_CONFIGURATION_ELEMENT_NAME = "exceptionTransitionConfiguration";

        /// <summary>
        /// exceptionTransition vf exceptionType łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "exceptionType" łB
        /// </remarks>
        private const string EXCEPTION_TYPE_ATTRIBUTE_NAME = "exceptionType";

        /// <summary>
        /// exceptionTransition vf nextPage łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "nextPage" łB
        /// </remarks>
        private const string NEXT_PAGE_ATTRIBUTE_NAME = "nextPage";

        /// <summary>
        /// Oݒt@C XML OԂłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "http://www.terasoluna.jp/schema/ExceptionTransitionSchema.xsd" łB
        /// </remarks>
        private const string XML_NAMESPACE = "http://www.terasoluna.jp/schema/ExceptionTransitionSchema.xsd";

        /// <summary>
        /// Oݒt@C XML OԃvtBbNXB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "ex" łB
        /// </remarks>
        private const string XML_NAMESPACE_PREFIX = "ex";

        /// <summary>
        /// Oݒt@C}[WŊƂvf XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "ex:exceptionTransitionConfiguration" łB
        /// </remarks>s
        private const string SECTION_XPATH = XML_NAMESPACE_PREFIX + ":exceptionTransitionConfiguration";

        /// <summary>
        /// Oݒt@C}[WŃ}[Wvf XPATH łB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "ex:exceptionTransitionConfiguration/ex:exceptionTransition" łB
        /// </remarks>s
        private const string ELEMENT_XPATH = SECTION_XPATH + "/" + XML_NAMESPACE_PREFIX + ":exceptionTransition";

        /// <summary>
        /// XML XL[}t@C̊SłB
        /// </summary>
        /// <remarks>
        /// ̒萔̒l "TERASOLUNA.Fw.Web.Configuration.ExceptionTransition.ExceptionTransitionConfiguration.xsd" łB
        /// </remarks>s
        private const string XML_SCHEMA_FILE_NAME = "TERASOLUNA.Fw.Web.Configuration.ExceptionTransition.ExceptionTransitionConfiguration.xsd";


        /// <summary>
        /// <see cref="ExceptionTransitionConfigurationSection"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>

        public ExceptionTransitionConfigurationSection()
        {
        }

        /// <summary>
        /// mode ̐ݒl擾܂B
        /// </summary>
        /// <value>
        /// mode ̐ݒlB
        /// </value>
        [ConfigurationProperty(MODE_ATTRIBUTE_NAME, DefaultValue = "on")]
        public string Mode
        {
            get
            {
                return (string)base[MODE_ATTRIBUTE_NAME];
            }
        }

        /// <summary>
        /// logging ̐ݒl擾܂B
        /// </summary>
        /// <value>
        /// logging ̐ݒlB
        /// </value>
        [ConfigurationProperty(LOGGING_ATTRIBUTE_NAME, DefaultValue = "off")]
        public string Logging
        {
            get
            {
                return (string)base[LOGGING_ATTRIBUTE_NAME];
            }
        }

        /// <summary>
        /// files vf擾܂B
        /// </summary>
        /// <remarks>
        /// exceptionTransitionConfiguration ZNV <see cref="FilesCollection"/> NX̃CX^X擾܂B
        /// </remarks>
        [ConfigurationProperty(FILES_ELEMENT_NAME, IsDefaultCollection = false, IsRequired = true)]
        public FilesCollection Files
        {
            get
            {
                FilesCollection filesCollection = (FilesCollection)base[FILES_ELEMENT_NAME];
                return filesCollection;
            }
        }

        /// <summary>
        /// exceptionTransitionConfiguration vf擾܂B
        /// </summary>
        ///<remarks>
        /// exceptionTransitionConfiguration ZNV <see cref="ExceptionTransitionCollection"/> NX̃CX^X擾܂B
        /// </remarks>
        [ConfigurationProperty(EXCEPTION_TRANSITION_CONFIGURATION_ELEMENT_NAME, IsDefaultCollection = false)]
        public ExceptionTransitionCollection ExceptionTransitionCollection
        {
            get
            {
                ExceptionTransitionCollection exceptionTransitionCollection = (ExceptionTransitionCollection)base[EXCEPTION_TRANSITION_CONFIGURATION_ELEMENT_NAME];
                return exceptionTransitionCollection;
            }
        }

        /// <summary>
        /// files vf̐ݒe exceptionTransition vf𐶐 exceptionTransitionConfiguration vfɒǉ܂B
        /// </summary>
        /// <remarks>
        /// <para><see cref="MergeConfiguration"/> IuWFNg𐶐AOݒt@C̐ݒ}[W܂B</para>
        /// <para>}[WOݒt@C̓e <see cref="ExceptionTransitionElement"/> IuWFNg𐶐A
        /// <see cref="ExceptionTransitionCollection"/> ɒǉ܂B</para>
        /// </remarks>
        /// <exception cref="ArgumentException">
        /// ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH słB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŃ}[Wvf XPATH słB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// \t@C̊Oݒt@C}[WŊƂvf XPATH ̐ݒ񂪕słB
        /// </item>
        /// <item>
        /// t@C̓ǂݍݎsłB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  XML XL[}؃G[łB
        /// </item>
        /// <item>
        /// Oݒt@C}[WŊƂvf XPATH  Oݒt@C}[WŃ}[Wvf XPATH }[WɁAXML XL[}؃G[łB
        /// </item>
        /// </list>
        /// </exception>
        public virtual void CreateExceptionTransitionElements()
        {
            // Oݒt@C̐ݒ}[W
            MergeConfiguration mgConfig = new MergeConfiguration(XML_NAMESPACE, XML_NAMESPACE_PREFIX, XML_SCHEMA_FILE_NAME);
            mgConfig.LoadConfig(SECTION_NAME, Files);
            XmlDocument xmlDoc = mgConfig.MergeXmlDocument(SECTION_XPATH, ELEMENT_XPATH);

            // Oݒt@C̐ݒexceptionTransitionConfigurationvfɒǉ
            AddExceptionTransitionElements(xmlDoc);
        }

        /// <summary>
        /// Oݒt@C̓e exceptionTransition vf𐶐AexceptionTransitionConfiguration vfɒǉ܂B
        /// </summary>
        /// <param name="xmlDoc">Oݒt@C̓eێ <see cref="XmlDocument" /> B</param>
        private void AddExceptionTransitionElements(XmlDocument xmlDoc)
        {
            XmlNodeList list = xmlDoc.DocumentElement.ChildNodes;

            foreach (XmlNode node in list)
            {
                if (node is XmlElement)
                {
                    string exceptionType = node.Attributes[EXCEPTION_TYPE_ATTRIBUTE_NAME].InnerText;
                    string nextPage = node.Attributes[NEXT_PAGE_ATTRIBUTE_NAME].InnerText;
                    ExceptionTransitionElement element = new ExceptionTransitionElement(exceptionType, nextPage);
                    ExceptionTransitionCollection.Add(element);
                }
            }
        }
    }
}
