﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

namespace TERASOLUNA.Fw.Common
{
    /// <summary>
    /// メッセージ種別を宣言する列挙型です。
    /// </summary>
    /// <remarks>
    /// ビジネスロジックの結果として設定するメッセージの種別は本列挙型を使用します。
    /// </remarks>
    public enum MessageType
    {
        /// <summary>
        /// 指定なし
        /// </summary>
        /// <remarks>  
        /// タイプ指定の必要が無い場合に使用する。（規定値）
        /// </remarks>
        None,

        /// <summary>
        /// デバッグメッセージ種別です。
        /// </summary>
        /// <remarks>  
        /// デバッグ用のメッセージの場合に使用する。
        /// </remarks>
        Debug,

        /// <summary>
        /// 情報メッセージ種別です。
        /// </summary>
        /// <remarks>  
        /// 処理完了など情報レベルのメッセージの場合に使用する。
        /// </remarks>
        Information,

        /// <summary>
        /// 警告メッセージ種別です。
        /// </summary>
        /// <remarks>  
        /// 検索結果が多すぎなど警告レベルのメッセージの場合に使用する。
        /// </remarks>
        Warning,

        /// <summary>
        /// エラーメッセージ種別です。
        /// </summary>
        /// <remarks>  
        /// 処理の失敗などエラーレベルのメッセージの場合に使用する。
        /// </remarks>
        Error
    }
}
