// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using System.Reflection;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Common
{
    /// <summary>
    /// CX^X𐶐邽߂̃[eBeBNXłB
    /// </summary>
    /// <remarks>
    /// <para>
    /// <see cref="ClassUtil"/> ͒ʏAt[[Nŗp܂Bt[[N̗p҂
    /// ڌĂяoƂ͂܂B
    /// </para>
    /// <para>
    /// tNV𗘗pāACX^X𐶐܂B
    /// </para>
    /// </remarks>
    public static class ClassUtil
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(ClassUtil));

        /// <summary>
        /// \t@CAL[w肵Č^擾AtNVp
        /// CX^X𐶐܂B^擾łȂꍇ͗OX[܂B
        /// </summary>
        /// <typeparam name="T"> CX^X󂯂^B</typeparam>
        /// <param name="appSettingsKey"> \t@C^擾邽߂ɗpL[
        /// B</param>
        /// <returns>ꂽ <typeparamref name="T"/> ^̃CX^XB</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="appSettingsKey"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="appSettingsKey"/> 󕶎łB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// \t@CsłB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf`A܂ <paramref name="appSettingsKey"/>
        /// L[Ƃ\t@CappSettingsvfvalue󕶎łB
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// ^邱Ƃł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// w肳ꂽ^͒ۃNXȂ̂ŁAł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel̃AZuC̓WFlbN^NXłB
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// ^̃ftHgRXgN^ĂяoƂł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// ^̃ftHgRXgN^OX[܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// ^̃CX^X <typeparamref name="T"/> ɃLXg邱Ƃł܂B
        /// </item>
        /// </list>
        /// </exception>
        public static T CreateInstanceFromAppSettings<T>(string appSettingsKey) where T : class
        {
            // ̓`FbN
            if (appSettingsKey == null)
            {
                ArgumentNullException exception = new ArgumentNullException("appSettingsKey");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "appSettingsKey"), exception);
                }
                throw exception;
            }
            if (appSettingsKey.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "appSettingsKey");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            //@CX^X̐
            T result = DoCreateInstanceFromAppSettings<T>(appSettingsKey, null);

            return result;
        }

        /// <summary>
        /// \t@CAL[w肵Č^擾AtNVp
        /// CX^X𐶐܂Bȉ̏ꍇA<paramref name="defaultType"/> Ŏw
        /// ꂽ <see cref="Type"/> ̃CX^X𐶐܂B
        /// <list type="bullet">
        /// <item>
        /// \t@C AppSettings vf <paramref name="appSettingsKey"/> L[Ƃ add vf`B
        /// </item>
        /// <item>
        /// \t@C AppSettings vf <paramref name="appSettingsKey"/> L[Ƃ add vf`Ă邪Avalue 󕶎B
        /// </item>
        /// </list>
        /// </summary>
        /// <typeparam name="T"> CX^X󂯂^B</typeparam>
        /// <param name="appSettingsKey"> \t@C^擾邽߂ɗpL[B</param>
        /// <param name="defaultType"> \t@C^擾łȂꍇA
        /// p^B</param>
        /// <returns>ꂽ <typeparamref name="T"/> ^̃CX^XB</returns>
        /// <exception cref="ArgumentNullException">
        /// <list type="bullet">
        /// <item>
        /// <paramref name="appSettingsKey"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="defaultType"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="appSettingsKey"/> 󕶎łB
        /// </item>
        /// <item>
        /// <paramref name="defaultType"/> ͒ۃNXłB
        /// </item>
        /// <item>
        /// <paramref name="defaultType"/> ̓WFlbN^̃NXłA^p[^ݒ肳Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// \t@CsłB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="defaultType"/> ̃ftHgRXgN^ĂяoƂł܂B
        /// </item>
        /// <item>
        /// <paramref name="defaultType"/> ̃ftHgRXgN^OX[܂B
        /// </item>
        /// <item>
        /// <paramref name="defaultType"/> ̃CX^X <typeparamref name="T"/> ɃLXg邱Ƃł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// ^邱Ƃł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// w肳ꂽ^͒ۃNXȂ̂ŁAł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel̃AZuC琶^AWFlbN^ł邪^p[^`łB
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// ^̃ftHgRXgN^ĂяoƂł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// ^̃ftHgRXgN^OX[܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf擾
        /// ^̃CX^X <typeparamref name="T"/> ɃLXg邱Ƃł܂B
        /// </item>
        /// </list>
        /// </exception>
        public static T CreateInstanceFromAppSettings<T>(
            string appSettingsKey, Type defaultType) where T : class
        {
            // ̓`FbN
            if (appSettingsKey == null)
            {
                ArgumentNullException exception = new ArgumentNullException("appSettingsKey");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "appSettingsKey"), exception);
                }
                throw exception;
            }
            if (appSettingsKey.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "appSettingsKey");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }
            if (defaultType == null)
            {
                ArgumentNullException exception = new ArgumentNullException("defaultType");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "defaultType"), exception);
                }
                throw exception;
            }
            if (defaultType.IsAbstract)
            {
                string message = string.Format(Properties.Resources.E_PARAM_ABSTRACT_TYPE, "defaultType", defaultType.AssemblyQualifiedName);
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }
            if (defaultType.ContainsGenericParameters)
            {
                string message = string.Format(Properties.Resources.E_PARAM_GENERIC_TYPE, "defaultType", defaultType.AssemblyQualifiedName);
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            //@CX^X̐
            T result = DoCreateInstanceFromAppSettings<T>(appSettingsKey, defaultType);

            return result;
        }

        /// <summary>
        /// \t@CAL[w肵Č^擾AtNVp
        /// CX^X𐶐܂Bȉ̏ꍇA<paramref name="defaultType"/> Ŏw
        /// ꂽ <see cref="Type"/> ̃CX^X𐶐܂B
        /// <list type="bullet">
        /// <item>
        /// \t@C AppSettings vf <paramref name="appSettingsKey"/> L[Ƃ add vf`B
        /// </item>
        /// <item>
        /// \t@C AppSettings vf <paramref name="appSettingsKey"/> L[Ƃ add vf`Ă邪Avalue 󕶎B
        /// </item>
        /// </list>
        /// </summary>
        /// <typeparam name="T"> CX^X󂯂^B</typeparam>
        /// <param name="appSettingsKey"> \t@C^擾邽߂ɗpL[B</param>
        /// <param name="defaultType"> \t@C^擾łȂꍇA
        /// p^B</param>
        /// <returns>ꂽ <typeparamref name="T"/> ^̃CX^XB</returns>
        /// <exception cref="ArgumentException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="defaultType"/> ͒ۃNXłB
        /// </item>
        /// <item>
        /// <paramref name="defaultType"/> ̓WFlbN^̃NXłA^p[^ݒ肳Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// \t@CsłB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="defaultType"/> ̃ftHgRXgN^ĂяoƂł܂B
        /// </item>
        /// <item>
        /// <paramref name="defaultType"/> ̃ftHgRXgN^OX[܂B
        /// </item>
        /// <item>
        /// <paramref name="defaultType"/> ̃CX^X <typeparamref name="T"/> ɃLXg邱Ƃł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf`A܂ <paramref name="appSettingsKey"/>
        /// L[Ƃ\t@CappSettingsvfvalue󕶎A<paramref name="defaultType"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// ^邱Ƃł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// w肳ꂽ^͒ۃNXȂ̂ŁAł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel̃AZuC琶^AWFlbN^ł邪^p[^`łB
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// ^̃ftHgRXgN^ĂяoƂł܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf́Avaluel
        /// ^̃ftHgRXgN^OX[܂B
        /// </item>
        /// <item>
        /// <paramref name="appSettingsKey"/> L[Ƃ\t@CappSettingsvf擾
        /// ^̃CX^X <typeparamref name="T"/> ɃLXg邱Ƃł܂B
        /// </item>
        /// </list>
        /// </exception>
        private static T DoCreateInstanceFromAppSettings<T>(
            string appSettingsKey, Type defaultType) where T : class
        {
            // ^\t@C擾B
            string typeName = ConfigurationManager.AppSettings[appSettingsKey];

            // ^^擾B
            // ^擾łAdefaultTypenull̏ꍇAOƂ
            T result = null;
            if (string.IsNullOrEmpty(typeName))
            {
                if (defaultType != null)
                {
                    if (_log.IsDebugEnabled)
                    {
                        _log.Debug(string.Format(
                            Properties.Resources.D_USE_DEFAULT_TYPE,
                            appSettingsKey, defaultType.AssemblyQualifiedName));
                    }

                    // CX^X̐
                    result = GetInstanceByType<T>(defaultType);
                }
                else
                {
                    string message = string.Format(Properties.Resources.E_TARGET_TYPE_NOT_FOUND, appSettingsKey);
                    TerasolunaException exception = new TerasolunaException(message);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(message, exception);
                    }
                    throw exception;
                }
            }
            else
            {
                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(
                        Properties.Resources.D_GET_TYPENAME_FROM_APPSETTINGS,
                        appSettingsKey, typeName));
                }

                // ^̎擾
                Type type = CreateTypeByTypeName(typeName);

                // 擾^̊mF
                if (type.IsAbstract)
                {
                    string message = string.Format(Properties.Resources.E_ABSTRACT_TYPE, type.AssemblyQualifiedName);
                    TerasolunaException exception = new TerasolunaException(message);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(message, exception);
                    }
                    throw exception;
                }
                if (type.ContainsGenericParameters)
                {
                    string message = string.Format(Properties.Resources.E_GENERIC_TYPE, type.AssemblyQualifiedName);
                    TerasolunaException exception = new TerasolunaException(message);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(message, exception);
                    }
                    throw exception;
                }

                // CX^X̐
                result = GetInstanceByType<T>(type);
            }

            return result;
        }

        /// <summary>
        /// w肵AZuCACX^X𐶐܂B
        /// </summary>
        /// <para>
        /// <paramref name="typeName"/>  <see cref="Type"/> 𐶐܂B
        /// <see cref="Type"/> łȂꍇAOX[܂B
        /// </para>1
        /// <para>
        /// <paramref name="typeName"/>  <see cref="Type"/> CX^X𐶐܂B
        /// CX^X𐶐łȂꍇAOX[܂B
        /// </para>
        /// <para>
        /// ꂽCX^X <typeparamref name="T"/> ɃLXgĕԋp܂B
        /// <typeparamref name="T"/> ɃLXgłȂꍇAOX[܂B
        /// </para>
        /// <typeparam name="T"> CX^X󂯂^B</typeparam>
        /// <param name="typeName"> 擾^\AZuCB</param>
        /// <returns>ꂽ <typeparamref name="T"/> ^̃CX^XB</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="typeName"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="typeName"/> 󕶎łB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="typeName"/> ̌^擾邱Ƃł܂B
        /// </item>
        /// <item>
        /// <paramref name="typeName"/> ̌^͒ۃNXłB
        /// </item>
        /// <item>
        /// <paramref name="typeName"/> ̌^̓WFlbN^̃NXłA^p[^ݒ肳Ă܂B
        /// </item>
        /// <item>
        /// <paramref name="typeName"/> ̌^̃ftHgRXgN^ĂяoƂł܂B
        /// </item>
        /// <item>
        /// <paramref name="typeName"/> ̌^̃ftHgRXgN^ŗO܂B
        /// </item>
        /// <item>
        /// <paramref name="typeName"/> ̌^͌^p[^ <typeparamref name="T"/> ɃLXgł܂B
        /// </item>
        /// </list>
        /// </exception>
        public static T CreateInstanceByTypeName<T>(string typeName) where T : class
        {
            // ̓`FbN
            if (typeName == null)
            {
                ArgumentNullException exception = new ArgumentNullException("typeName");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "typeName"), exception);
                }
                throw exception;
            }
            if (typeName.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "typeName");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // ^̎擾
            Type type = CreateTypeByTypeName(typeName);

            // 擾^̊mF
            if (type.IsAbstract)
            {
                string message = string.Format(Properties.Resources.E_ABSTRACT_TYPE, type.AssemblyQualifiedName);
                TerasolunaException exception = new TerasolunaException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }
            if (type.ContainsGenericParameters)
            {
                string message = string.Format(Properties.Resources.E_GENERIC_TYPE, type.AssemblyQualifiedName);
                TerasolunaException exception = new TerasolunaException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // CX^X̐
            T result = GetInstanceByType<T>(type);

            return result;
        }

        /// <summary>
        /// w肵^Ǝw肵^ɕKvȃWFlbN^̃AZuC񂩂CX^X𐶐܂B
        /// </summary>
        /// <typeparam name="T">
        /// CX^X󂯂^B
        /// </typeparam>
        /// <param name="typeName">擾^\AZuCB</param>
        /// <param name="genericTypeNames"><paramref name="typeName"/> ɕKvȌ^p[^\ϒB</param>
        /// <returns>ꂽ <typeparamref name="T"/> ^̃CX^XB</returns>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B 
        /// <list type="bullet">
        /// <item>
        /// <paramref name="typeName"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="genericTypeNames"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// ȉ̂悤ȏꍇɗOX[܂B 
        /// <list type="bullet">
        /// <item>
        /// <paramref name="typeName"/> 󕶎łB
        /// </item>
        /// <item>
        /// <paramref name="genericTypeNames"/> ̔z null QƂ܂͋󕶎񂪊܂܂Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// AZuC <paramref name="typeName"/> ̌^擾邱Ƃł܂B
        /// </item>
        /// <item>
        /// AZuCz <paramref name="genericTypeNames"/> ɁA^擾邱ƂłȂAZuC܂B
        /// </item>
        /// <item>
        /// <paramref name="genericTypeNames"/> ɐݒ肳ĂAZuCz񐔂A
        /// <paramref name="typeName"/> 琶ꂽ^ɕKvȃWFlbN菭ȂłB
        /// </item>
        /// <item>
        /// <paramref name="genericTypeNames"/> ɐݒ肳ĂAZuCž^́A
        /// <paramref name="typeName"/> 琶ꂽ^ɕKvȃWFlbN̐𖞂Ă܂B
        /// </item>
        /// <item>
        /// <paramref name="typeName"/> 琶^͒ۃNXłB
        /// </item>
        /// <item>
        /// <paramref name="typeName"/>  <paramref name="genericTypeNames"/> 琶^
        /// WFlbN^̃NXłB
        /// </item>
        /// <item>
        /// <paramref name="typeName"/>  <paramref name="genericTypeNames"/> 琶^
        /// ftHgRXgN^ĂяoƂł܂B
        /// </item>
        /// <item>
        /// <paramref name="typeName"/>  <paramref name="genericTypeNames"/> 琶^
        /// ftHgRXgN^OX[܂B
        /// </item>
        /// <item>
        /// <paramref name="typeName"/>  <paramref name="genericTypeNames"/> 琶^
        /// CX^X <typeparamref name="T"/> ɃLXg邱Ƃł܂B
        /// </item>
        /// </list>
        /// </exception>
        public static T CreateInstanceWithGenericTypes<T>(
            string typeName, params string[] genericTypeNames) where T : class
        {
            // ̓`FbN
            if (typeName == null)
            {
                ArgumentNullException exception = new ArgumentNullException("typeName");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "typeName"), exception);
                }
                throw exception;
            }
            if (typeName.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "typeName");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }
            if(genericTypeNames == null)
            {
                ArgumentNullException exception = new ArgumentNullException("genericTypeNames");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "genericTypeNames"), exception);
                }
                throw exception;
            }

            // ^擾B
            Type type = CreateTypeByTypeName(typeName);

            // 擾^̊mF
            if (type.IsAbstract)
            {
                string message = string.Format(Properties.Resources.E_PARAM_ABSTRACT_TYPE, "typeName", type.AssemblyQualifiedName);
                TerasolunaException exception = new TerasolunaException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // ʂƂėp^B
            Type targetType = null;

            // WFlbN^ǂ̊mF
            if (type.IsGenericType)
            {
                int genericCount = type.GetGenericArguments().Length;
                if (genericCount > genericTypeNames.Length)
                {
                    string message = string.Format(
                        Properties.Resources.E_LESS_PARAMS, type.AssemblyQualifiedName, genericCount);
                    TerasolunaException exception = new TerasolunaException(message);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(message, exception);
                    }
                    throw exception;
                }

                // WFlbNp[^݂ꍇApč\zꂽWFlbN^𐶐B
                Type[] genericTypes = new Type[genericCount];
                for (int i = 0; i < genericCount; i++)
                {
                    if (genericTypeNames[i] == null)
                    {
                        string message = string.Format(Properties.Resources.E_NULL_ARGUMENT, "genericTypeNames[" + i + "]");
                        ArgumentException exception = new ArgumentException(message);
                        if (_log.IsErrorEnabled)
                        {
                            _log.Error(message, exception);
                        }
                        throw exception;
                    }
                    if (genericTypeNames[i].Length == 0)
                    {
                        string message = string.Format(Properties.Resources.E_EMPTY_STRING, "genericTypeNames[" + i + "]");
                        ArgumentException exception = new ArgumentException(message);
                        if (_log.IsErrorEnabled)
                        {
                            _log.Error(message, exception);
                        }
                        throw exception;
                    }

                    // ^̎擾
                    Type genericType = CreateTypeByTypeName(genericTypeNames[i]);

                    // ^̊mF
                    if (genericType.ContainsGenericParameters)
                    {
                        string message = string.Format(Properties.Resources.E_GENERIC_TYPE, genericType.AssemblyQualifiedName);
                        TerasolunaException exception = new TerasolunaException(message);
                        if (_log.IsErrorEnabled)
                        {
                            _log.Error(message, exception);
                        }
                        throw exception;
                    }

                    genericTypes[i] = genericType;
                }

                try
                {
                    targetType = type.MakeGenericType(genericTypes);
                }
                catch (ArgumentException e)
                {
                    string message = string.Format(
                        Properties.Resources.E_MAKE_GENERICTYPE_FAILED, type.AssemblyQualifiedName);
                    TerasolunaException exception = new TerasolunaException(message, e);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(message, exception);
                    }
                    throw exception;
                }

                if (_log.IsDebugEnabled)
                {
                    _log.Debug(string.Format(Properties.Resources.D_MAKE_GENERICTYPE_SUCCESS, targetType.FullName));
                }
            }
            else
            {
                targetType = type;
            }

            // CX^X̐
            T result = GetInstanceByType<T>(targetType);

            return result;
        }

        /// <summary>
        /// w肵^̃CX^X𐶐܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <paramref name="targetType"/> ^̃CX^XtNV𗘗păCX^X𐶐܂B
        /// CX^XɎsꍇAOX[܂B
        /// </para>
        /// <para>
        /// ꂽCX^X^p[^ <typeparamref name="T"/> ɃLXgsAԋp܂B
        /// ^p[^ <typeparamref name="T"/> ɃLXgłȂꍇAOX[܂B
        /// </para>
        /// </remarks>
        /// <typeparam name="T"> CX^X󂯂^B</typeparam>
        /// <param name="targetType"> CX^X̌^B</param>
        /// <returns>ꂽ <typeparamref name="T"/> ^̃CX^XB</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="targetType"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="targetType"/> ͒ۃNXłB
        /// </item>
        /// <item>
        /// <paramref name="targetType"/> ̓WFlbN^̃NXłA^p[^ݒ肳Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="targetType"/> ̃ftHgRXgN^ĂяoƂł܂B
        /// </item>
        /// <item>
        /// <paramref name="targetType"/> ̃ftHgRXgN^OX[܂B
        /// </item>
        /// <item>
        /// <paramref name="targetType"/> ̃CX^X <typeparamref name="T"/> ɃLXg邱Ƃł܂B
        /// </item>
        /// </list>
        /// </exception>
        public static T CreateInstanceByType<T>(Type targetType) where T : class
        {
            // ̓`FbN
            if (targetType == null)
            {
                ArgumentNullException exception = new ArgumentNullException("targetType");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "targetType"), exception);
                }
                throw exception;
            }
            if (targetType.IsAbstract)
            {
                string message = string.Format(Properties.Resources.E_PARAM_ABSTRACT_TYPE, "targetType", targetType.AssemblyQualifiedName);
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }
            if (targetType.ContainsGenericParameters)
            {
                string message = string.Format(Properties.Resources.E_PARAM_GENERIC_TYPE, "targetType", targetType.AssemblyQualifiedName);
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // CX^X̐
            T result = GetInstanceByType<T>(targetType);

            return result;
        }

        /// <summary>
        /// AZuC\A <see cref="Type"/> CX^X擾܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <paramref name="typeName"/>Ŏw肳ꂽAZuC <see cref="Type"/> CX^X擾܂B
        /// <paramref name="typeName"/>Ŏw肳ꂽAZuCłȂꍇAOX[܂B
        /// </para>
        /// </remarks>
        /// <param name="typeName">擾^\AZuCB</param>
        /// <returns>AZuCꂽ <see cref="Type"/> CX^XB</returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="typeName"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name  ="typeName"/> 󕶎łB
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// <paramref name="typeName"/> ̌^擾邱Ƃł܂B
        /// </exception>
        public static Type GetType(string typeName)
        {
            // ̓`FbN
            if (typeName == null)
            {
                ArgumentNullException exception = new ArgumentNullException("typeName");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(Properties.Resources.E_NULL_ARGUMENT, "typeName"), exception);
                }
                throw exception;
            }
            if (typeName.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "typeName");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // ^̎擾
            Type type = CreateTypeByTypeName(typeName);

            return type;
        }

        /// <summary>
        /// w肵^̃CX^X𐶐܂B
        /// </summary>
        /// <typeparam name="T">CX^X󂯂^B</typeparam>
        /// <param name="type">CX^X̌^B</param>
        /// <returns>ꂽ <typeparamref name="T"/> ^̃CX^XB</returns>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="type"/> ̃ftHgRXgN^ĂяoƂł܂B
        /// </item>
        /// <item>
        /// <paramref name="type"/> ̃ftHgRXgN^ŗO܂B
        /// </item>
        /// <item>
        /// <paramref name="type"/> ͌^p[^ <typeparamref name="T"/> ɃLXgł܂B
        /// </item>
        /// </list>
        /// </exception>
        private static T GetInstanceByType<T>(Type type) where T : class
        {
            // ^typẽCX^X𐶐B
            // publicňȂRXgN^݂KvB
            T result = null;
            try
            {
                result = Activator.CreateInstance(type) as T;
            }
            catch (MemberAccessException e)
            {
                string message = string.Format(
                    Properties.Resources.E_MEMBER_ACCESS_EXCEPTION,
                    type.AssemblyQualifiedName);
                TerasolunaException exception = new TerasolunaException(message, e);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }
            catch (TargetInvocationException e)
            {
                string message = string.Format(
                    Properties.Resources.E_TARGET_INVOCATION_EXCEPTION,
                    type.AssemblyQualifiedName);
                TerasolunaException exception = new TerasolunaException(message, e);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            // ^ T ɃLXgłȂꍇ
            if (result == null)
            {
                string message = string.Format(
                    Properties.Resources.E_INVALID_CAST_TYPE_FROM_GENERICPARAM,
                    type.AssemblyQualifiedName, typeof(T).AssemblyQualifiedName);
                TerasolunaException exception = new TerasolunaException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(Properties.Resources.D_CREATE_INSTANCE_SUCCESS,
                    typeof(T).AssemblyQualifiedName, type.AssemblyQualifiedName));
            }

            return result;
        }

        /// <summary>
        /// AZuC <see cref="Type"/> 擾܂B
        /// </summary>
        /// <param name="typeName">AZuCB</param>
        /// <returns><paramref name="typeName"/>  <see cref="Type"/>B</returns>
        /// <exception cref="TerasolunaException">
        /// <paramref name="typeName"/> ̌^擾邱Ƃł܂B
        /// </exception>
        private static Type CreateTypeByTypeName(string typeName)
        {
            // ^̎擾
            Type type = null;
            try
            {
                type = Type.GetType(typeName, true);
            }
            catch (Exception e)
            {
                string message = string.Format(Properties.Resources.E_TYPE_LOAD_FAILED, typeName);
                TerasolunaException exception = new TerasolunaException(message, e);

                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            if (_log.IsDebugEnabled)
            {
                _log.Debug(string.Format(Properties.Resources.D_TYPE_LOADED, type.AssemblyQualifiedName));
            }

            return type;
        }
    }

}
