﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.Client.Conversion
{
    /// <summary>
    /// データセット変換時に発生したエラーを表します。
    /// </summary>
    [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1032:ImplementStandardExceptionConstructors")]
    public class ConversionException : TerasolunaException
    {
        /// <summary>
        /// <see cref="ConversionException"/> クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <remarks>
        /// デフォルトコンストラクタです。
        /// </remarks>
        public ConversionException()
            : base(Properties.Resources.E_CONVERSION_EXCEPTION)
        {
        }

        /// <summary>
        /// 指定したエラーメッセージを使用して、
        /// <see cref="ConversionException"/> クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="message">エラーメッセージ。</param>
        public ConversionException(string message)
            : base(message)
        {
        }

        /// <summary>
        /// 指定したエラーメッセージと、この例外の原因である内部例外への参照を使用して、 
        /// <see cref="ConversionException"/> クラスの新しいインスタンスを初期化します。
        /// </summary>
        /// <param name="message">エラーメッセージ。</param>
        /// <param name="inner">現在の例外の原因である例外。</param>
        public ConversionException(string message, Exception inner)
            : base(message, inner)
        {
        }
    }
}
