// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using TERASOLUNA.Fw.Common;

namespace TERASOLUNA.Fw.Client.Communication
{
    /// <summary>
    /// ʐMɃT[oŗOƂ\ONXłB
    /// </summary>
    [Serializable]
    public class ServerException : Exception
    {
        /// <summary>
        /// T[oŔG[^Cv(O)B
        /// </summary>
        private string _errorType = null;

        /// <summary>
        /// T[oŔÕbZ[W̃XgB
        /// </summary>
        private IList<MessageInfo> _errors = new List<MessageInfo>();

        /// <summary>
        /// T[oŔG[^Cv(O)擾܂B
        /// </summary>
        /// <value>T[oŔG[^Cv(O)B</value>
        public string ErrorType
        {
            get
            {
                return _errorType;
            }
        }

        /// <summary>
        /// T[oŔÕbZ[W̃Xg擾܂B
        /// </summary>
        /// <value>T[oŔÕbZ[W̃XgB</value>
        public IList<MessageInfo> Errors
        {
            get
            {
                return _errors;
            }
        }

        /// <summary>
        /// <see cref="ServerException"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^B
        /// </remarks>
        public ServerException()
            : base()
        {
        }

        /// <summary>
        /// w肵G[ bZ[WgpāA<see cref="ServerException"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="message">ǑG[ bZ[WB</param>
        /// <remarks>
        /// RXgN^B
        /// </remarks>
        public ServerException(string message)
            : base(message)
        {
        }

        /// <summary>
        /// w肵G[ bZ[WƁA̗ǑłOւ̎QƂgpāA
        /// <see cref="ServerException"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="message">ǑG[ bZ[WB</param>
        /// <param name="innerException">݂̗ǑłOBOw肳ĂȂꍇ́Anull QƁB</param>
        public ServerException(string message, Exception innerException)
            : base(message, innerException)
        {
        }

        /// <summary>
        /// w肵G[ bZ[WƁAT[oŔG[^Cv(O)gpāA
        /// <see cref="ServerException"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>RXgN^B</remarks>
        /// <param name="message">ǑG[ bZ[WB</param>
        /// <param name="errorType">T[oŔG[^Cv(O)B</param>
        public ServerException(string message, string errorType)
            : base(message)
        {
            _errorType = errorType;
        }

        /// <summary>
        /// w肵G[ bZ[WAT[oŔG[^Cv(O)ƃG[bZ[WXggpāA
        /// <see cref="ServerException"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="message">ǑG[ bZ[WB</param>
        /// <param name="errorType">T[oŔG[^Cv(O)B</param>
        /// <param name="errors">T[oŔÕbZ[W̃XgB</param>
        public ServerException(string message, string errorType, IList<MessageInfo> errors)
            : this(message, errorType)
        {
            _errors = errors;
        }

        /// <summary>
        /// VAf[^gpāA<see cref="ServerException"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="info">VAꂽIuWFNg f[^ێIuWFNgB</param>
        /// <param name="context">]܂͓]ɊւReLXgB</param>
        /// <remarks>fVACYۂɌĂяo܂B</remarks>
        protected ServerException(SerializationInfo info, StreamingContext context)
            : base(info, context)
        {
        }
    }
}
