﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using System.Xml;
using TERASOLUNA.Fw.Common.Configuration;
using System.Configuration;
using System.Xml.Schema;
using System.IO;
using TERASOLUNA.Fw.Common.Configuration.BLogic;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.CommonUT.Configuration.BLogic
{
    /// <summary>
    ///TERASOLUNA.Fw.Common.Configuration.BLogic.BLogicConfigurationSection のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Common.Configuration.BLogic.BLogicConfigurationSection 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class BLogicConfigurationSectionTest
    {

        private TestContext testContextInstance;
        private const string CONFIG_FILE_NAME_01 = "TestItem_BLogicConfigSection01.config";
        private const string CONFIG_FILE_NAME_02 = "TestItem_BLogicConfigSection02.config";
        private const string CONFIG_FILE_NAME_03 = "TestItem_BLogicConfigSection03.config";
        private const string CONFIG_FILE_NAME_04 = "TestItem_BLogicConfigSection04.config";
        private const string CONFIG_FILE_NAME_05 = "TestItem_BLogicConfigSection05.config";
        private const string CONFIG_FILE_NAME_06 = "TestItem_BLogicConfigSection06.config";
        private const string CONFIG_FILE_NAME_07 = "TestItem_BLogicConfigSection07.config";
        private const string CONFIG_FILE_NAME_08 = "TestItem_BLogicConfigSection08.config";
        private const string CONFIG_FILE_NAME_09 = "TestItem_BLogicConfigSection09.config";
        private const string CONFIG_FILE_NAME_10 = "TestItem_BLogicConfigSection10.config";
        private const string CONFIG_FILE_NAME_11 = "TestItem_BLogicConfigSection11.config";
        private const string CONFIG_FILE_NAME_12 = "TestItem_BLogicConfigSection12.config";
        private const string CONFIG_FILE_NAME_13 = "TestItem_BLogicConfigSection13.config";
        private const string CONFIG_FILE_NAME_14 = "TestItem_BLogicConfigSection14.config";
        private const string CONFIG_FILE_NAME_15 = "TestItem_BLogicConfigSection15.config";
        private const string CONFIG_FILE_NAME_16 = "TestItem_BLogicConfigSection16.config";
        private const string CONFIG_FILE_NAME_17 = "TestItem_BLogicConfigSection17.config";
        private const string CONFIG_FILE_NAME_18 = "TestItem_BLogicConfigSection18.config";
        private const string CONFIG_FILE_NAME_19 = "TestItem_BLogicConfigSection19.config";
        private const string CONFIG_FILE_NAME_20 = "TestItem_BLogicConfigSection20.config";
        private const string CONFIG_FILE_NAME_21 = "TestItem_BLogicConfigSection21.config";
        private const string CONFIG_FILE_NAME_22 = "TestItem_BLogicConfigSection22.config";
        private const string CONFIG_FILE_NAME_23 = "TestItem_BLogicConfigSection23.config";
        private const string CONFIG_FILE_NAME_24 = "TestItem_BLogicConfigSection24.config";
        private const string CONFIG_FILE_NAME_25 = "TestItem_BLogicConfigSection25.config";
        private const string CONFIG_FILE_NAME_26 = "TestItem_BLogicConfigSection26.config";
        private const string CONFIG_FILE_NAME_27 = "TestItem_BLogicConfigSection27.config";


        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion


        /// <summary>
        /// BLogicConfigurationSection () のテスト
        /// </summary>
        /// <TestTarget>Constructor()</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>インスタンスが生成されること</TestAssertion>
        [TestMethod()]
        public void TestConstructor01()
        {
            BLogicConfigurationSection target = new BLogicConfigurationSection();
            Assert.IsNotNull(target);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// Files のテスト
        /// </summary>
        /// <TestTarget>Files</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>FilesCollectionが返却されること</TestAssertion>
        [TestMethod()]
        public void TestFiles01()
        {
            BLogicConfigurationSection target = new BLogicConfigurationSection();
            Assert.IsInstanceOfType(target.Files, typeof(FilesCollection));

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// BLogicCollection のテスト
        ///</summary>
        /// <TestTarget>BLogicCollection</TestTarget>
        /// <TestCondition></TestCondition>
        /// <TestAssertion>BLogicCollectionが返却されること</TestAssertion>
        [TestMethod()]
        public void TestBLogicCollection01()
        {
            BLogicConfigurationSection target = new BLogicConfigurationSection();
            Assert.IsInstanceOfType(target.BLogicCollection, typeof(BLogicCollection));

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>外部設定ファイルの設定情報がBLogicCollectionプロパティに保持されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal02.config")]
        public void TestCreateBLogicElements01()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_01);

            target.CreateBLogicElements();

            Assert.AreEqual("Biz1", target.BLogicCollection[0].Name);
            Assert.AreEqual("Biz.Class1, Biz", target.BLogicCollection[0].Type);
            Assert.AreEqual("Biz2", target.BLogicCollection[1].Name);
            Assert.AreEqual("Biz.Class2, Biz", target.BLogicCollection[1].Type);
            Assert.AreEqual("Biz3", target.BLogicCollection[2].Name);
            Assert.AreEqual("Biz.Class3, Biz", target.BLogicCollection[2].Type);

            Assert.AreEqual("Db1", target.BLogicCollection[0].DbInfos[0].Name);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのblogic要素のname属性の値が重複していること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection02.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal03.config")]
        public void TestCreateBLogicElements02()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_02);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのblogicConfiguration要素が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection03.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal04.config")]
        public void TestCreateBLogicElements03()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_03);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのblogic要素が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection04.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal05.config")]
        public void TestCreateBLogicElements04()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_04);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのblogic要素のname属性が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection05.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal06.config")]
        public void TestCreateBLogicElements05()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_05);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのblogic要素のtype属性が無いこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection06.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal07.config")]
        public void TestCreateBLogicElements06()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_06);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルに不正な要素が存在すること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection07.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal08.config")]
        public void TestCreateBLogicElements07()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_07);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }


        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>構成ファイルにfile要素がないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection08.config")]
        public void TestCreateBLogicElements08()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_08);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException)
            {
                // 成功
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>構成ファイルに設定されている外部設定ファイルが存在しないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection09.config")]
        public void TestCreateBLogicElements09()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_09);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(FileNotFoundException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性にファイル名に使用できない文字が含まれていること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection10.config")]
        public void TestCreateBLogicElements10()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_10);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(ArgumentException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が260文字以上であること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection11.config")]
        public void TestCreateBLogicElements11()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_11);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(PathTooLongException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>構成ファイルのfile要素のpath属性が無効なパスであること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection12.config")]
        public void TestCreateBLogicElements12()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_12);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(DirectoryNotFoundException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルがXML形式でないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection13.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal09.config")]
        public void TestCreateBLogicElements13()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_13);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>構成ファイルにblogicConfigurationノードがないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection14.config")]
        public void TestCreateBLogicElements14()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_14);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException)
            {
                // 成功
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>構成ファイルにblogicConfiguration\files\fileノードがないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection15.config")]
        public void TestCreateBLogicElements15()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_15);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException)
            {
                // 成功
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>構成ファイルにblogicConfiguration\files\file :path属性がないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection16.config")]
        public void TestCreateBLogicElements16()
        {
            try
            {
                BLogicConfigurationSection target =
                    ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_16);

                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException)
            {
                // 成功
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルの2つめのファイルが異常であること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection17.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal08.config")]
        public void TestCreateBLogicElements17()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_17);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのname属性の値が空文字であること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection18.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal10.config")]
        public void TestCreateBLogicElements18()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_18);

            target.CreateBLogicElements();
            Assert.AreEqual("", target.BLogicCollection[0].Name);
            Assert.AreEqual("Biz.Class1, Biz", target.BLogicCollection[0].Type);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのname属性の値が重複することであること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection19.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal11.config")]
        public void TestCreateBLogicElements19()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_19);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのtype属性の値が空文字であること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection20.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal12.config")]
        public void TestCreateBLogicElements20()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_20);


            target.CreateBLogicElements();
            Assert.AreEqual("Biz1", target.BLogicCollection[0].Name);
            Assert.AreEqual("", target.BLogicCollection[0].Type);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのtype属性が重複すること</TestCondition>
        /// <TestAssertion>正常にname属性、type属性が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection21.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal13.config")]
        public void TestCreateBLogicElements21()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_21);

            target.CreateBLogicElements();
            Assert.AreEqual("Biz1", target.BLogicCollection[0].Name.ToString());
            Assert.AreEqual("Biz.Class1, Biz", target.BLogicCollection[0].Type.ToString());
            Assert.AreEqual("Biz2", target.BLogicCollection[1].Name.ToString());
            Assert.AreEqual("Biz.Class1, Biz", target.BLogicCollection[1].Type.ToString());

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのtype属性が複数の外部ファイルに跨って重複すること</TestCondition>
        /// <TestAssertion>正常にname属性、type属性が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection22.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal01.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal14.config")]
        public void TestCreateBLogicElements22()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_22);

            target.CreateBLogicElements();
            Assert.AreEqual("Biz1", target.BLogicCollection[0].Name.ToString());
            Assert.AreEqual("Biz.Class1, Biz", target.BLogicCollection[0].Type.ToString());
            Assert.AreEqual("Biz2", target.BLogicCollection[1].Name.ToString());
            Assert.AreEqual("Biz.Class2, Biz", target.BLogicCollection[1].Type.ToString());
            Assert.AreEqual("Biz3", target.BLogicCollection[2].Name.ToString());
            Assert.AreEqual("Biz.Class1, Biz", target.BLogicCollection[2].Type.ToString());

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }
        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのtype属性が不正なフォーマットであること</TestCondition>
        /// <TestAssertion>正常にname属性、type属性が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection23.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal15.config")]
        public void TestCreateBLogicElements23()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_23);

            target.CreateBLogicElements();
            Assert.AreEqual("Biz1", target.BLogicCollection[0].Name.ToString());
            Assert.AreEqual("InvalidFormat", target.BLogicCollection[0].Type.ToString());

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのdbInfo要素が存在しないこと</TestCondition>
        /// <TestAssertion>正常にname属性、type属性が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection24.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal16.config")]
        public void TestCreateBLogicElements24()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_24);

            target.CreateBLogicElements();

            Assert.AreEqual("Biz1", target.BLogicCollection[0].Name);
            Assert.AreEqual("Biz.Class1, Biz", target.BLogicCollection[0].Type);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのDbInfo要素が複数あること</TestCondition>
        /// <TestAssertion>正常にname属性、type属性が取得できること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection25.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal17.config")]
        public void TestCreateBLogicElements25()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_25);

            target.CreateBLogicElements();

            Assert.AreEqual("Biz1", target.BLogicCollection[0].Name);
            Assert.AreEqual("Biz.Class1, Biz", target.BLogicCollection[0].Type);
            Assert.AreEqual("Db1", target.BLogicCollection[0].DbInfos[0].Name);
            Assert.AreEqual("Db2", target.BLogicCollection[0].DbInfos[1].Name);
            Assert.AreEqual("Db3", target.BLogicCollection[0].DbInfos[2].Name);

            Assert.AreEqual(3, target.BLogicCollection[0].DbInfos.Count);

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのname属性が存在しないこと</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection26.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal18.config")]
        public void TestCreateBLogicElements26()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_26);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

        /// <summary>
        /// CreateBLogicElements () のテスト
        /// </summary>
        /// <TestTarget>CreateBLogicElements()</TestTarget>
        /// <TestCondition>外部設定ファイルのname属性の値が空であること</TestCondition>
        /// <TestAssertion>ConfigurationErrorExceptionがスローされること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicConfigSection27.config")]
        [DeploymentItem(@"Configuration\BLogic\TestItem_BLogicExternal19.config")]
        public void TestCreateBLogicElements27()
        {
            BLogicConfigurationSection target =
                ConfigTestHelper.GetBLogicConfigurationSectionFromCustomFile(CONFIG_FILE_NAME_27);

            try
            {
                target.CreateBLogicElements();
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException ex)
            {
                // 成功
                Assert.IsInstanceOfType(ex.InnerException, typeof(XmlSchemaException));
            }
            catch (Exception e)
            {
                Assert.Fail("到達してはいけないコードです。" + e.ToString());
            }

            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(BLogicConfigurationSection), LogLevel.INFO));
        }

    }

}
