﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Collections.Generic;

namespace TERASOLUNA.Fw.Common.Validation
{
    /// <summary>
    /// 検証結果のエラーリストを保持するクラスです。
    /// </summary>
    public class ValidationResult
    {
        /// <summary>
        /// <see cref="ValidationMessageInfo"/> のリストを保持します。
        /// </summary>
        private IList<MessageInfo> _errors = new List<MessageInfo>();

        /// <summary>
        /// 検証エラー <see cref="ValidationMessageInfo"/> のリストを取得します。
        /// </summary>
        /// <remarks>
        /// <para> <see cref="MessageInfo"/> のリストとして定義していますが、
        ///  <see cref="ValidationMessageInfo"/> のみが入ります。</para>
        /// <para>エラーが 0 件の場合は、長さ 0 のリストを返します。</para>
        /// </remarks>
        /// <value>
        /// 検証エラー <see cref="ValidationMessageInfo"/> のリスト。
        /// </value>
        public IList<MessageInfo> Errors
        {
            get { return _errors; }
        }

        /// <summary>
        /// <see cref="ValidationResult"/> クラスの新しいインスタンスを作成します。
        /// </summary>
        /// <remarks>
        /// デフォルトコンストラクタです。
        /// </remarks>
        public ValidationResult()
        {
        }

        /// <summary>
        /// 検証エラーの有無を判定します。
        /// </summary>
        /// <value>
        /// <seealso cref="ValidationResult.Errors"/> が 0 件ならば、 true 。 1 件以上あれば false 。
        /// </value>
        public bool IsValid
        {
            get
            {
                return (_errors.Count == 0);
            }
        }
    }
}
