// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Client;

namespace TERASOLUNA.Fw.ClientUT
{
    /// <summary>
    /// スタブ3: ExecuteAsync 異常系
    /// </summary>
    public class EventController_CoordinatorStub03 : Coordinator
    {
        private static EventController _controller;

        public EventController_CoordinatorStub03()
        {
            TERASOLUNA_Fw_Client_CoordinatorAccessor accessor = new TERASOLUNA_Fw_Client_CoordinatorAccessor(this);
            accessor._isBusy = true;
        }

        public static EventController Controller
        {
            get
            {
                return _controller;
            }
        }

        public override void ExecuteAsync(EventController eventController)
        {
            _controller = eventController;
        }
    }
}
