// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Client.Configuration.Conversion;
using TERASOLUNA.Fw.Client.Configuration.View;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Client.Configuration;
using System.Configuration;
using TERASOLUNA.Fw.Common;
namespace TERASOLUNA.Fw.ClientUT.Configuration
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.Configuration.TerasolunaClientConfiguration のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.Configuration.TerasolunaClientConfiguration 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class TerasolunaClientConfigurationTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
            TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor._conversionConfigSection = null;
            TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor._viewConfigSection = null;
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        [TestCleanup()]
        public void MyTestCleanup()
        {
            TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor.CONVERSION_CONFIGURAION_SECTION_NAME = "conversionConfiguration";
            TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor._conversionConfigSection = null;

            TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor.VIEW_CONFIGURATION_NAME = "viewConfiguration";
            TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor._viewConfigSection = null;
        }
        
        #endregion

        /// <summary>
        /// ConversionConfigSection のテスト
        /// </summary>
        /// <TestTarget>ConversionConfigSection</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ConversionConfigurationSectionのインスタンスが取得されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\Conversion\ConversionConfigurationTestData\ConversionConfiguration_External01.config")]
        public void ConversionConfigSectionTest01()
        {
            // 実施
            ConversionConfigurationSection target = TerasolunaClientConfiguration.ConversionConfigSection;

            // 確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaClientConfiguration), LogLevel.INFO));
            Assert.IsInstanceOfType(target, typeof(ConversionConfigurationSection));
            Assert.IsNotNull(TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor._conversionConfigSection);
            Assert.IsTrue(target.ConvertCollection.Count > 0);
        }

        /// <summary>
        /// ConversionConfigSection のテスト
        /// </summary>
        /// <TestTarget>ConversionConfigSection</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのconfigSectionsの要素に"conversionConfiguration"キーがあり、
        /// value 属性が ConversionConfigurationSection 型ではないこと
        /// （"conversionConfiguration"キーの value 属性が ConversionConfigurationSection 型ではない場合の試験の代わり。）
        /// </TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionが発生すること</TestAssertion>
        [TestMethod()]
        public void ConversionConfigSectionTest02()
        {
            // 準備
            TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor.CONVERSION_CONFIGURAION_SECTION_NAME = "dummyConfiguration";

            try
            {
                // 実施
                ConversionConfigurationSection target = TerasolunaClientConfiguration.ConversionConfigSection;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string exceptionMessage = string.Format(
                    MessageManager.GetMessage("E_CONFIGURATION_INVALID_CAST", "ConversionConfiguration", typeof(DummyConfigurationSection).FullName));
                Assert.AreEqual(exceptionMessage, e.Message);
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(TerasolunaClientConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(TerasolunaClientConfiguration), typeof(ConfigurationErrorsException),
                "E_CONFIGURATION_INVALID_CAST", "ConversionConfiguration", typeof(DummyConfigurationSection).FullName));
        }

        /// <summary>
        /// ConversionConfigSection のテスト
        /// </summary>
        /// <TestTarget>ConversionConfigSection</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのconfigSectionsの要素に"conversionConfiguration"キーがないこと
        /// （"conversionConfiguration"キーがない場合の試験の代わり。）
        /// </TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void ConversionConfigSectionTest03()
        {
            // 準備
            TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor.CONVERSION_CONFIGURAION_SECTION_NAME = "noConfiguration";

            // 実施
            ConversionConfigurationSection target = TerasolunaClientConfiguration.ConversionConfigSection;

            // 確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaClientConfiguration), LogLevel.INFO));
            Assert.IsNull(target);
            Assert.IsNull(TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor._conversionConfigSection);
        }

        /// <summary>
        /// ViewConfigSection のテスト
        /// </summary>
        /// <TestTarget>ViewConfigSection</TestTarget>
        /// <TestCondition>構成ファイル、外部設定ファイルが正常なこと</TestCondition>
        /// <TestAssertion>ViewConfigurationSectionのインスタンスが取得されること</TestAssertion>
        [TestMethod()]
        [DeploymentItem(@"Configuration\View\ViewConfigurationTestData\ViewConfiguration_ViewConfigExternal01.config")]
        public void ViewConfigSectionTest01()
        {
            // 実施
            ViewConfigurationSection target = TerasolunaClientConfiguration.ViewConfigSection;

            // 確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaClientConfiguration), LogLevel.INFO));
            Assert.IsInstanceOfType(target, typeof(ViewConfigurationSection));
            Assert.IsNotNull(TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor._viewConfigSection);
            Assert.IsTrue(target.ViewCollection.Count > 0);
        }

        /// <summary>
        /// ViewConfigSection のテスト
        /// </summary>
        /// <TestTarget>ViewConfigSection</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのconfigSectionsの要素に"dummyConfiguration"キーがあり、
        /// value 属性が ViewConfigurationSection 型ではないこと
        /// （"viewConfiguration"キーの value 属性が ViewConfigurationSection 型ではない場合の試験の代わり。）
        /// </TestCondition>
        /// <TestAssertion>ConfigurationErrorsExceptionが発生すること</TestAssertion>
        [TestMethod()]
        public void ViewConfigSectionTest02()
        {
            // 準備
            TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor.VIEW_CONFIGURATION_NAME = "dummyConfiguration";

            try
            {
                // 実施
                ViewConfigurationSection target = TerasolunaClientConfiguration.ViewConfigSection;
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ConfigurationErrorsException e)
            {
                // 確認
                string exceptionMessage = string.Format(
                    MessageManager.GetMessage("E_CONFIGURATION_INVALID_CAST", "ViewConfiguration", typeof(DummyConfigurationSection).FullName));
                Assert.AreEqual(exceptionMessage, e.Message);
            }

            // 確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(TerasolunaClientConfiguration), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(TerasolunaClientConfiguration), typeof(ConfigurationErrorsException),
                "E_CONFIGURATION_INVALID_CAST", "ViewConfiguration", typeof(DummyConfigurationSection).FullName));
        }

        /// <summary>
        /// ViewConfigSection のテスト
        /// </summary>
        /// <TestTarget>ViewConfigSection</TestTarget>
        /// <TestCondition>
        /// 構成ファイルのconfigSectionsの要素に"noConfiguration"キーがないこと
        /// （"viewConfiguration"キーがない場合の試験の代わり。）
        /// </TestCondition>
        /// <TestAssertion>nullが返却されること</TestAssertion>
        [TestMethod()]
        public void ViewConfigSectionTest03()
        {
            // 準備
            TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor.VIEW_CONFIGURATION_NAME = "noConfiguration";

            // 実施
            ViewConfigurationSection target = TerasolunaClientConfiguration.ViewConfigSection;

            // 確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaClientConfiguration), LogLevel.INFO));
            Assert.IsNull(target);
            Assert.IsNull(TERASOLUNA_Fw_Client_Configuration_TerasolunaClientConfigurationAccessor._viewConfigSection);
        }

    }
}
