﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Data;

namespace TERASOLUNA.Fw.Client.Conversion
{
    /// <summary>
    /// データセット変換機能を提供するインターフェイスです。
    /// </summary>
    public interface IConverter
    {
        /// <summary>
        /// <paramref name="srcData"/> の <see cref="DataSet"/> を
        /// <paramref name="destData"/> の <see cref="DataSet"/>
        /// に変換します。
        /// </summary>
        /// <param name="id">データセット変換情報を識別するためのキーとなる値。</param>
        /// <param name="srcData">変換元 <see cref="DataSet"/> 。</param>
        /// <param name="destData">変換先 <see cref="DataSet"/> 。</param>
        /// <exception cref="ArgumentNullException">
        /// <para><paramref name="id"/> が null 参照です。</para>
        /// <para><paramref name="srcData"/> が null 参照です。</para>
        /// <para><paramref name="destData"/> が null 参照です。</para>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="id"/> が空文字列です。
        /// </exception>
        /// <exception cref="ConversionException">
        /// データセット変換中にエラーが発生しました。
        /// </exception>
        void Convert(string id, DataSet srcData, DataSet destData);

        /// <summary>
        /// <paramref name="destData"/> の <see cref="DataSet"/> を
        /// <paramref name="srcData"/> の <see cref="DataSet"/>
        /// に変換します。
        /// </summary>
        /// <param name="id">データセット変換情報を識別するためのキーとなる値。</param>
        /// <param name="srcData">変換先 <see cref="DataSet"/> 。</param>
        /// <param name="destData">変換元 <see cref="DataSet"/> 。</param>
        /// <exception cref="ArgumentNullException">
        /// <para><paramref name="id"/> が null 参照です。</para>
        /// <para><paramref name="srcData"/> が null 参照です。</para>
        /// <para><paramref name="destData"/> が null 参照です。</para>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="id"/> が空文字列です。
        /// </exception>
        /// <exception cref="ConversionException">
        /// データセット変換中にエラーが発生しました。
        /// </exception>
        void Reverse(string id, DataSet srcData, DataSet destData);
    }
}
