// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.Configuration.View
{
    /// <summary>
    /// ʑJڐݒt@C <see cref="ViewConfiguration"/> ݒ擾܂B
    /// </summary>
    public abstract class ViewConfiguration
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(ViewConfiguration));

        /// <summary>
        /// View ̃^Cv擾܂B
        /// </summary>
        /// <param name="id">擾 View ̎ʎqB</param>
        /// <returns>݂ꍇ́A<paramref name="id"/> ̒lɑΉ 
        /// View ̃^CvBȊȌꍇ null QƁB</returns>
        /// <remarks>
        /// ʑJڐݒt@CA<paramref name="id"/> ̒lɑΉ type 
        /// l擾܂B
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="id"/>  null QƂłB
        /// </exception>
        /// <exception cref="ArgumentException">
        /// <paramref name="id"/> ̕łB
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// AvP[V\t@Cǂݍ߂܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// AvP[V\t@C̐ݒ񂪕słB
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// ʑJڐݒt@Cǂݍ߂܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// ʑJڐݒt@C XML XL[}słB
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        public static string GetViewTypeName(string id)
        {
            if (id == null)
            {
                ArgumentNullException exception = new ArgumentNullException("id");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "id"), exception);
                }
                throw exception;
            }
            if (id.Length == 0)
            {
                string message = string.Format(Properties.Resources.E_EMPTY_STRING, "id");
                ArgumentException exception = new ArgumentException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            ViewConfigurationSection viewConfigSection = TerasolunaClientConfiguration.ViewConfigSection;

            // idɑΉݒ肪ꍇnullԋp
            string elementType = null;
            if (viewConfigSection != null && viewConfigSection.ViewCollection[id] != null)
            {
                elementType = viewConfigSection.ViewCollection[id].Type;
            }

            if (_log.IsTraceEnabled)
            {
                if (elementType == null)
                {
                    _log.Trace(string.Format(
                        Properties.Resources.T_VIEW_CONFIGURATION_NOT_LOAD_PARAMETER, id));
                }
                else
                {
                    _log.Trace(string.Format(
                        Properties.Resources.T_VIEW_CONFIGURATION_LOAD_PARAMETER, id, elementType));
                }
            }

            return elementType;
        }
    }
}
