// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Web.Controller;
using System.Web;
using System.IO;
using TERASOLUNA.Fw.WebUT;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.WebUT.Controller
{
    ///<summary>
    /// HttpContextWrapper のテストクラスです。
    ///</summary>

    [TestClass()]
    public class HttpContextWrapperTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        ///<summary>
        /// HttpContextWrapper () のテスト
        ///</summary>
        ///<remarks>
        /// デフォルトコンストラクタでインスタンス化ができることを確認するテスト。
        ///</remarks>
        [DeploymentItem("TERASOLUNA.Fw.Web.Multipart.dll")]
        [TestMethod()]
        public void ConstructorTest01()
        {
            // 準備 & 実行
            HttpContextWrapper target = new HttpContextWrapperStub01() as HttpContextWrapper;

            // 検証
            Assert.IsNotNull(target);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(HttpContextWrapper), LogLevel.INFO));

        }

        ///<summary>
        /// HttpContextWrapper (HttpContext) のテスト
        ///</summary>
        ///<remarks>
        /// 引数HttpContextがnullの場合、
        /// 例外(ArgumentNullException)が発生することを確認するテスト。
        ///</remarks>
        [TestMethod()]
        public void ConstructorTest02()
        {
            try
            {
                // 失敗
                HttpContext httpContext = null;
                HttpContextWrapper target = new HttpContextWrapper(httpContext);
                Assert.Fail("到達してはいけないコードです。");
            }
            catch (ArgumentNullException ex)
            {
                //成功
                Assert.AreEqual("httpContext", ex.ParamName);
            }
            catch (Exception ex)
            {
                // 失敗
                Assert.Fail("予期せぬエラーです。" + ex.ToString());
            }

            // ログの確認
            Assert.AreEqual(1, LogUTUtil.CountLogs(typeof(HttpContextWrapper), LogLevel.INFO));
            Assert.IsTrue(LogUTUtil.CheckErrorUseMessageId(typeof(HttpContextWrapper), typeof(ArgumentNullException),"E_NULL_ARGUMENT","httpContext"));
        }
    }
}
