// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using System.IO;
using System.Net.Mime;
using System.Text;
using System.Web;
using System.Web.Configuration;
using TERASOLUNA.Fw.Common;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Controller
{
    /// <summary>
    /// NCAg̃t@CAbv[h𔺂rWlXWbNsv
    /// Rg[NXłB
    /// </summary>
    public class FileUploadRequestController : BLogicRequestController
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(FileUploadRequestController));

        /// <summary>
        /// NGXg̓̓Xg[xɓǂݍލőobt@TCYłB
        /// </summary>
        /// <remarks>
        /// <para>
        /// ̒萔̒l 8192 łB
        /// </para>
        /// </remarks>
        protected const int BUFFER_SIZE = 1024 * 8;

        /// <summary>
        /// content-dispositon wb_̂łB
        /// </summary>
        /// <remarks>
        /// <para>
        /// ̒萔̒l "content-disposition" łB
        /// </para>
        /// </remarks>
        protected static readonly string HEADER_CONTENT_DISPOSITION = "content-disposition";

        /// <summary>
        /// content-disposition wb_̐ݒlƂĐݒ肳t@Cp[^̃L[łB
        /// </summary>
        /// <remarks>
        /// <para>
        /// ̒萔̒l "filename" łB
        /// </para>
        /// </remarks>
        protected static readonly string CONTENT_DISPOSITION_FILENAME = "filename";

        /// <summary>
        /// Base64 \GR[fBOʖłB
        /// </summary>
        /// <remarks>
        /// <para>
        /// ̒萔̒l "B" łB
        /// </para>
        /// </remarks>
        protected static readonly string MIME_ENCODE_TYPE = "B";

        /// <summary>
        /// Abv[ht@Ĉ <see cref="HttpContext.Items"/> 
        /// ݒ/擾ۂɃL[ƂȂ镶łB
        /// </summary>
        /// <remarks>
        /// <para>
        /// ̒萔̒l "TERASOLUNA_UploadFileName" łB
        /// </para>
        /// </remarks>
        protected static readonly string KEY_CONTEXT_ITEM_UPLOAD_FILE_NAME = "TERASOLUNA_UploadFileName";

        /// <summary>
        /// ꎞۊǃfBNgpX <see cref="HttpContext.Items"/> 
        /// ݒ/擾ۂɃL[ƂȂ镶łB
        /// </summary>
        /// <remarks>
        /// <para>
        /// ̒萔̒l "TERASOLUNA_TempDirectoryPath" łB
        /// </para>
        /// </remarks>
        protected static readonly string KEY_CONTEXT_ITEM_TMP_DIR_INFO = "TERASOLUNA_TempDirectoryPath";

        /// <summary>
        /// ꎞۊǃfBNg̃[g΃pX Web.config  Appsettings 
        /// 擾ۂɃL[ƂȂ镶łB
        /// </summary>
        /// <remarks>
        /// <para>
        /// ̒萔̒l "RootTmpDirectory" łB
        /// </para>
        /// </remarks>
        protected static readonly string KEY_APPSETTINGS_ROOT_TMP_DIR = "RootTmpDirectory";

        /// <summary>
        /// HTTP NGXg̃wb_ݒl؂܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// <para>
        /// <see cref="BLogicRequestController.ValidateContentType"/> ĂяoA
        /// <c>content-type</c> wb_ݒl؂܂B
        /// </para>
        /// <para>
        /// <c>content-disposition</c> wb_ݒl؂܂B
        /// </para>
        /// <para>
        /// <see cref="GetContentFileName"/> ĂяoA
        /// <c>content-disposition</c> Abv[ht@C擾܂B
        /// </para>
        /// </remarks>
        /// <exception cref="InvalidRequestException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <c>content-type</c> wb_ ݒłB
        /// </item>
        /// <item>
        /// <c>content-type</c> wb_ ݒl󕶎łB
        /// </item>
        /// <item>
        /// <c>content-type</c> wb_ ݒl̃tH[}bgsłB
        /// </item>
        /// <item>
        /// <c>content-type</c> wb_ ݒl̃fBA^Cv
        /// <c>application/octet-stream</c> ł͂܂B
        /// </item>
        /// <item>
        /// <c>content-disposition</c> wb_ ݒłB
        /// </item>
        /// <item>
        /// <c>content-disposition</c> wb_ ݒl󕶎łB
        /// </item>
        /// <item>
        /// <c>content-disposition</c> wb_ ݒl̃tH[}bgs̗R
        /// t@Ĉ擾ł܂łB
        /// </item>
        /// </list>
        /// </exception>
        protected override void ValidateRequestHeader(HttpContext context)
        {
            //content-typewb_̌
            ValidateContentType(context.Request.ContentType, MediaTypeNames.Application.Octet);
            
            //content-dispositionwb_̌
            string contentDisposition = context.Request.Headers[HEADER_CONTENT_DISPOSITION];
            if (string.IsNullOrEmpty(contentDisposition))
            {
                // content-dispositionwb_ݒ܂͒l̏ꍇ
                InvalidRequestException exception = new InvalidRequestException(string.Format(
                    Properties.Resources.E_REQUIRED_HEADER_EMPTY, HEADER_CONTENT_DISPOSITION));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            // Abv[ht@C̎擾
            string uploadFileName = GetContentFileName(contentDisposition);

            // 㑱̏Ńt@Ĉ𗘗p̂ŁAێĂB
            context.Items[KEY_CONTEXT_ITEM_UPLOAD_FILE_NAME] = uploadFileName;
        }

        /// <summary> 
        /// content-disposition wb_ݒlAbv[ht@C擾܂B 
        /// </summary> 
        /// <param name="contentDisposition"> wb_ݒlB</param> 
        /// <returns>Abv[ht@ĆB
        /// t@C̎擾Ɏsꍇ́AOX[A null ͕Ԃ܂B</returns> 
        /// <remarks>
        /// <paramref name="contentDisposition"/> ͂Afilename p[^Ƃ
        /// ݒ肳Ăl <see cref="DecodeFileName"/> 𗘗pāA
        /// fR[hꂽAbv[ht@Ĉ擾܂B
        /// <example>
        /// Ƀt@Ĉ擾\ content-disposition wb_ݒl̗܂B
        /// ̗̏ꍇA"ӂOP.csv" Ƃt@Ĉ擾܂B
        /// <code>
        /// <![CDATA[
        /// attachment; filename=?ISO-2022-JP?B?GyRCJFUkISQkJGsjMCMxGyhCLmNzdg==?=
        /// ]]>
        /// </code>
        /// </example>
        /// </remarks>
        /// <exception cref="InvalidRequestException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// Base64ŃGR[hꂽt@Ĉ̃tH[}bgsł邽߁A
        /// fR[hɎs܂B
        /// </item>
        /// <item>
        /// 삵ĂvbgtH[ŃT|[gĂȂR[hw肳Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual string GetContentFileName(string contentDisposition)
        {
            string contentFileName = null;

            string[] paramArray = contentDisposition.Split(';');

            for (int i = 0; i < paramArray.Length; i++)
            {
                int delimiterFirstPos = paramArray[i].IndexOf('=');
                if (delimiterFirstPos >= 0)
                {
                    // '=' ܂ł̕擾
                    string keyStr = paramArray[i].Substring(0, delimiterFirstPos).Trim();
                    
                    // '=' ȍ~̕擾
                    string valueStr = paramArray[i].Substring(delimiterFirstPos + 1).Trim();

                    // filenameȍ~̕擾 
                    if (CONTENT_DISPOSITION_FILENAME.Equals(keyStr, StringComparison.OrdinalIgnoreCase))
                    {
                        if (valueStr.Length == 0)
                        {
                            InvalidRequestException exception = new InvalidRequestException(string.Format(
                                    Properties.Resources.E_NOT_FOUND_FILENAME));
                            if (_log.IsErrorEnabled)
                            {
                                _log.Error(exception.Message, exception);
                            }
                            throw exception;
                        }

                        contentFileName = DecodeFileName(valueStr);
                        break;
                    }
                }
            }

            if (contentFileName == null)
            {
                string message = string.Format(Properties.Resources.E_NOT_FOUND_CONTENT_DISPOSITION_FILENAME);
                InvalidRequestException exception = new InvalidRequestException(message);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(message, exception);
                }
                throw exception;
            }

            return contentFileName;
        } 
 
 
        /// <summary> 
        /// GR[hĂt@ĈfR[h܂B 
        /// </summary> 
        /// <param name="encodeStr">GR[hꂽt@C܂ޕB</param> 
        /// <returns>fR[hꂽt@ĆBtH[}bgsɂA
        /// Ȃꍇ null QƂԋp܂B</returns> 
        /// <exception cref="InvalidRequestException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// Content-Disposition wb_Ŏw肳ꂽlłt@C̃GR[h`słB
        /// </item>
        /// <item>
        /// Content-Disposition wb_Ŏw肳ꂽlłt@C̃GR[fBO Base64 ł͂܂B
        /// </item>
        /// <item>
        /// Content-Disposition wb_Ŏw肳ꂽlłt@C󕶎łB
        /// </item>
        /// <item>
        /// Base64 ŃGR[hꂽt@Ĉ̒ 4 ̔{ł͂܂B
        /// </item>
        /// <item>
        /// Content-Disposition wb_Ƀt@C݂܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual string DecodeFileName(string encodeStr) 
        { 
            string fileName = null;
            string encodingName = null;
            string encodingTypeName = null;
            string encodedFileName = null;
 
            // Conent-Disposition̗vf̎擾
            string[] strArray = encodeStr.Split('?');
            if (strArray.Length < 5)
            {
                InvalidRequestException exception = new InvalidRequestException(string.Format(
                    Properties.Resources.E_INVALID_CONTENT_DISPOSITION_FILENAME, encodeStr));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            encodingName = strArray[1];
            encodingTypeName = strArray[2];
            encodedFileName = strArray[3];

            // GR[fBOnull E 󕶎`FbN
            if (string.IsNullOrEmpty(encodingName))
            {
                InvalidRequestException exception = new InvalidRequestException(string.Format(
                    Properties.Resources.E_INVALID_CONTENT_DISPOSITION_FILENAME, encodeStr));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            // GR[fBO^Cṽ`FbN
            if(!MIME_ENCODE_TYPE.Equals(encodingTypeName, StringComparison.OrdinalIgnoreCase))
            {
                InvalidRequestException exception = new InvalidRequestException(string.Format(
                    Properties.Resources.E_INVALID_CONTENT_DISPOSITION_FILENAME, encodeStr));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
                
            // GR[hꂽt@C̋󕶎`FbN
            if(string.IsNullOrEmpty(encodedFileName))
            {
                InvalidRequestException exception = new InvalidRequestException(string.Format(
                    Properties.Resources.E_INVALID_CONTENT_DISPOSITION_FILENAME, encodeStr));
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
                       
            // oCgz̃t@C擾
            byte[] byteArray = null;
            try
            {
                byteArray = Convert.FromBase64String(encodedFileName);
            }
            catch (FormatException fe)
            {
                InvalidRequestException exception = new InvalidRequestException(string.Format(
                    Properties.Resources.E_INVALID_CONTENT_DISPOSITION_FILENAME, encodeStr), fe);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                    throw exception;
            }

            // t@C̎擾
            try
            {
                fileName = Encoding.GetEncoding(encodingName).GetString(byteArray);
            }
            catch (ArgumentException ae)
            {
                InvalidRequestException exception = new InvalidRequestException(string.Format(
                    Properties.Resources.E_INVALID_CONTENT_DISPOSITION_FILENAME, encodeStr), ae);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            return fileName; 
        }

        /// <summary>
        /// NGXg̃{fB͂܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Reques tA Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// <para>
        /// <see cref="HttpContext.Items"/>  
        /// <see cref="KEY_CONTEXT_ITEM_UPLOAD_FILE_NAME"/> 
        /// Abv[ht@Ĉ擾A<see cref="CreateTemporaryDirectory"/> ĂяoA
        /// ꎞۊǃfBNg𐶐܂B̎ɐꎞۊǃfBNg̃pX <see cref="HttpContext.Items"/>  <see cref="KEY_CONTEXT_ITEM_TMP_DIR_INFO"/> Ɋi[܂B
        /// </para>
        /// <para>
        /// ꎞۊǃfBNg̔zɎ擾Abv[ht@Ĉ̃t@C
        /// <see cref="CreateTemporaryFile"/> Ăяo܂B
        /// </para>
        /// <para>
        /// ꎞt@C̃t@CpXɁA<see cref="UploadFileInfo"/> A
        /// <see cref="HttpContext.Items"/>  
        /// <see cref="BLogicRequestController.KEY_CONTEXT_ITEM_INPUTPARAM"/>  
        ///  <see cref="UploadFileInfo"/> i[܂B
        /// </para>
        /// </remarks>
        /// <exception cref="InvalidRequestException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <see cref="HttpContext.Items"/>  
        /// <see cref="KEY_CONTEXT_ITEM_UPLOAD_FILE_NAME"/> ɁA
        /// t@ĈƂĎgpłȂgĂ܂B
        /// </item>
        /// <item>
        /// POST ꂽf[^TCYő咷𒴂Ă܂B
        /// </item>
        /// <item>
        /// Ώۂ̃t@CpX̃TCY𒴂Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// ꎞۊǃ[gfBNgւ̃t@Cݒ肳Ă܂B
        /// </item>
        /// <item>
        /// ꎞۊǃ[gfBNgւ̃fBNgݒ肳Ă܂B
        /// </item>
        /// <item>
        /// NGXg̓̓Xg[̓ǂݍݒɃNCAgƂ̐ڑؒf܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ConfigurationErrorsException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// Web.config  AppSettings ɐݒ肳ĂAbv[h
        /// ꎞۊǃ[gfBNg̃pXsłB
        /// </item>
        /// <item>
        /// Web.config  AppSettings ɐݒ肳ĂAbv[h
        /// ꎞۊǃ[gfBNg΃pXł͂܂B
        /// </item>
        /// <item>
        /// Web.config  AppSettings ɐݒ肳ĂAbv[h
        /// ꎞۊǃ[gfBNg݂܂B
        /// </item>
        /// <item>
        /// Web.config  AppSettings ɐݒ肳ĂAbv[h
        /// ꎞۊǃ[gfBNg̃pX̐ݒlt@CpXƂĐݒł
        /// fBNgpX̍őTCY𒴂Ă܂B
        /// </item>
        /// <item>
        /// Web.config  AppSettings ɐݒ肳ĂAbv[h
        /// ꎞۊǃ[gfBNgpX̐ݒlɃfBNĝƂ
        /// włȂ܂܂Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        protected override void ParseRequestBody(HttpContext context)
        {
            string fileName = context.Items[KEY_CONTEXT_ITEM_UPLOAD_FILE_NAME] as string;

            // ꎞۊǃfBNg𐶐B
            DirectoryInfo tempDirInfo = CreateTemporaryDirectory(context.Request);
            // ꎞۊǃfBNg̃pXێĂB
            context.Items[KEY_CONTEXT_ITEM_TMP_DIR_INFO] = tempDirInfo.FullName;

            // ꎞۊǃfBNgɃAbv[ht@C𐶐B
            FileInfo fileInfo = CreateTemporaryFile(fileName, context.Request, tempDirInfo);

            // UploadpDataSet𐶐AAbv[ht@CݒB
            UploadFileInfo uploadFileInfo = new UploadFileInfo();
            uploadFileInfo.TempFiles.AddTempFilesRow(fileInfo.FullName);
            uploadFileInfo.ApplicationRoot.AddApplicationRootRow(context.Server.MapPath("~"));

            // UploadpDataSetrWlXWbNNX̓̓p[^Ƃ
            // context.ItemsɐݒB
            context.Items[KEY_CONTEXT_ITEM_INPUTPARAM] = uploadFileInfo;
        }

        /// <summary>
        /// NGXg̓̓Xg[Abv[hf[^
        /// ꎞt@Cw̃fBNgɐ܂B
        /// </summary>
        /// <param name="fileName">t@ĆB</param>
        /// <param name="request">NGXgB</param>
        /// <param name="targetDirectory">ꎞt@C𐶐Ώۂ̃fBNgB</param>
        /// <returns>ꎞt@C̏B</returns>
        /// <remarks>
        /// <paramref name="targetDirectory"/> Ɏw肳ꂽfBNg̒ 
        /// <paramref name="fileName"/> Ɏw肳ꂽt@Ĉňꎞt@C쐬A 
        /// <paramref name="request"/>  <see cref="HttpRequest.InputStream"/> ǂݍ񂾁A
        /// oCif[^ꎞt@CƂď݂܂B
        /// </remarks>
        /// <exception cref="InvalidRequestException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="fileName"/> ɁAt@ĈƂĎgpłȂw肳Ă܂B
        /// </item>
        /// <item>
        /// POSTꂽf[^TCYő咷𒴂Ă܂B
        /// </item>
        /// <item>
        /// Ώۂ̃t@CpX̃TCY𒴂Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// ꎞۊǃ[gfBNgւ̃t@Cݒ肳Ă܂B
        /// </item>
        /// <item>
        /// NGXg̓̓Xg[̓ǂݍݒɃNCAgƂ̐ڑؒf܂B
        /// </item>
        /// </list>
        /// </exception>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1011:ConsiderPassingBaseTypesAsParameters")]
        protected virtual FileInfo CreateTemporaryFile(string fileName, HttpRequest request, DirectoryInfo targetDirectory)
        {
            FileInfo fileInfo = null;
            string absoluteTmpDir = targetDirectory.FullName;

            // 쐬fBNg̒Ƀt@C쐬AAbv[hf[^ށB
            try
            {
                string absoluteFilePath = absoluteTmpDir + "\\" + fileName;

                fileInfo = new FileInfo(absoluteFilePath);

                // ̓Xg[ɐݒ肳ĂoCiꎞۊǃfBNg
                // t@C𐶐ďށB
                using (FileStream stream = fileInfo.Open(FileMode.CreateNew))
                {
                    byte[] buffer = new byte[BUFFER_SIZE];
                    int readSize = request.InputStream.Read(buffer, 0, BUFFER_SIZE);
                    while (readSize > 0)
                    {
                        stream.Write(buffer, 0, readSize);
                        readSize = request.InputStream.Read(buffer, 0, BUFFER_SIZE);
                    }
                }
            }
            catch (ArgumentException ae)
            {
                // Content-Dispositionwb_擾̃t@C̃t@Ct@CƂĎgpłȂgĂȂǁB
                InvalidRequestException exception = new InvalidRequestException(string.Format(
                    Properties.Resources.E_CREATE_UPLOAD_FILENAME, fileName), ae);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            catch (HttpException he)
            {
                // POSTf[^̃TCYő咷𒴂ꍇB
                InvalidRequestException exception = new InvalidRequestException(Properties.Resources.E_INVALID_REQUEST + he.Message, he);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            catch (UnauthorizedAccessException uae)
            {
                // ݒ肳ꂽꎞۊǃ[gfBNgɃt@C𐶐łȂꍇ
                TerasolunaException exception = new TerasolunaException(Properties.Resources.E_CREATE_UPLOAD_TMPFILE_FAILED, uae);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            catch (IOException ioe)
            {
                TerasolunaException exception = new TerasolunaException(Properties.Resources.E_CREATE_UPLOAD_TMPFILE_FAILED, ioe);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            return fileInfo;
        }

        /// <summary>
        /// Abv[hf[^̈ꎞt@C̐ΏۂƂA
        /// NGXgɈӂȈꎞۊǃfBNg쐬܂B
        /// </summary>
        /// <param name="request">NGXgB</param>
        /// <returns>fBNgi[ <see cref="DirectoryInfo"/> IuWFNgB</returns>
        /// <remarks>
        /// Web.config  AppSettings  L[ <see cref="KEY_APPSETTINGS_ROOT_TMP_DIR"/> ɐݒ肳ꂽ
        /// ꎞۊǃfBNg̃[gƂȂfBNg擾A擾[gfBNg
        /// <seealso cref="Guid.NewGuid"/> ɂ擾O[oʎqfBNgƂ
        /// NGXgɈӂȈꎞۊǃfBNg𐶐܂B
        /// </remarks>
        /// <exception cref="ConfigurationErrorsException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// Web.config  AppSettings ɐݒ肳ĂAbv[h
        /// ꎞۊǃ[gfBNg̃pXsłB
        /// </item>
        /// <item>
        /// Web.config  AppSettings ɐݒ肳ĂAbv[h
        /// ꎞۊǃ[gfBNg΃pXł͂܂B
        /// </item>
        /// <item>
        /// Web.config  AppSettings ɐݒ肳ĂAbv[h
        /// ꎞۊǃ[gfBNg݂܂B
        /// </item>
        /// <item>
        /// Web.config  AppSettings ɐݒ肳ĂAbv[h
        /// ꎞۊǃ[gfBNg̃pX̐ݒlt@CpXƂĐݒł
        /// fBNgpX̍őTCY𒴂Ă܂B
        /// </item>
        /// <item>
        /// Web.config  AppSettings ɐݒ肳ĂAbv[h
        /// ꎞۊǃ[gfBNgpX̐ݒlɃfBNĝƂ
        /// włȂ܂܂Ă܂B
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="TerasolunaException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// ꎞۊǃ[gfBNgւ̃fBNgݒ肳Ă܂B
        /// </item>
        /// <item>
        /// fBNg̐Ɏs܂B
        /// </item>
        /// </list>
        /// </exception>
        protected virtual DirectoryInfo CreateTemporaryDirectory(HttpRequest request)
        {
            string tmpDir = WebConfigurationManager.AppSettings[KEY_APPSETTINGS_ROOT_TMP_DIR] as string;
            if (tmpDir != null)
            {
                // Web.configɎw肳ꂽpXǂ`FbNB
                if (tmpDir.Length == 0)
                {
                    ConfigurationErrorsException exception = new ConfigurationErrorsException(Properties.Resources.E_INVALID_UPLOAD_TMPDIR);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }
                try
                {
                    if (!Path.IsPathRooted(tmpDir))
                    {
                        // ꎞt@Ci[p̃[gfBNg̐ݒl΃pXłȂꍇ
                        ConfigurationErrorsException exception = new ConfigurationErrorsException(Properties.Resources.E_INVALID_UPLOAD_TMPDIR);
                        if (_log.IsErrorEnabled)
                        {
                            _log.Error(exception.Message, exception);
                        }
                        throw exception;
                    }
                }
                catch (ArgumentException ae)
                {
                    // ꎞt@Ci[p̃[gfBNg̐ݒlɃfBNgpX
                    // psȕ񂪊܂܂Ăꍇ
                    ConfigurationErrorsException exception = new ConfigurationErrorsException(Properties.Resources.E_INVALID_UPLOAD_TMPDIR, ae);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }
                if (!Directory.Exists(tmpDir))
                {
                    // w肳ꂽꎞt@Ci[p̃[gfBNg݂Ȃꍇ
                    ConfigurationErrorsException exception = new ConfigurationErrorsException(Properties.Resources.E_INVALID_UPLOAD_TMPDIR);
                    if (_log.IsErrorEnabled)
                    {
                        _log.Error(exception.Message, exception);
                    }
                    throw exception;
                }
            }
            else
            {
                // ݒ肳ĂȂꍇ͊lƂāAVXëꎞfBNg̃pX𗘗pB
                tmpDir = Path.GetTempPath();
            }

            // NGXgɈӂȈꎞۊǃfBNgpX𐶐B
            // dm͒ႢdȂƂ͕ۏႳĂȂ̂ŁA
            // Directory݃`FbNďdȂ悤ɂĂB
            string absoluteTmpDir = null;
            do
            {
                absoluteTmpDir = Path.Combine(tmpDir, Guid.NewGuid().ToString());
            }
            while (Directory.Exists(absoluteTmpDir));


            // fBNg쐬B
            DirectoryInfo createdDirInfo;
            try
            {
                createdDirInfo = Directory.CreateDirectory(absoluteTmpDir);
            }
            catch (UnauthorizedAccessException uae)
            {
                // ݒ肳ꂽꎞۊǃ[gfBNgɏ݂łȂꍇ
                TerasolunaException exception = new TerasolunaException(Properties.Resources.E_CREATE_UPLOAD_TMPFILE_FAILED, uae);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }
            catch (IOException ioe)
            {
                TerasolunaException exception = new TerasolunaException(Properties.Resources.E_CREATE_UPLOAD_TMPFILE_FAILED, ioe);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            return createdDirInfo;
        }

        /// <summary>
        /// ͒ľ؂s܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// ͒ľ؂sȂ悤ɁA<see cref="BLogicRequestController.ValidateInputData"/>
        /// I[o[Ch܂B
        /// </remarks>
        /// <returns> true ԋp܂B</returns>
        protected override bool ValidateInputData(HttpContext context)
        {
            // Abv[h͓͒l؂͍sȂ߁AtrueԋpB
            return true;
        }

        /// <summary>
        /// ƖG[̃X|X݂܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// <see cref="Release"/> ĂяoAꎞۊǃfBNg
        /// ̔z̃t@C폜A
        /// <see cref="BLogicRequestController.WriteBLogicErrorResponse"/> Ăяo
        /// X|X݂܂B
        /// </remarks>
        protected override void WriteBLogicErrorResponse(HttpContext context)
        {
            // X|XݑOɈꎞt@C̍폜sB
            Release(context);
            base.WriteBLogicErrorResponse(context);
        }

        /// <summary>
        /// ĨX|X݂܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// <see cref="Release"/> ĂяoAꎞۊǃfBNg
        /// ̔z̃t@C폜A
        /// <see cref="BLogicRequestController.WriteSuccessResponse"/> Ăяo
        /// X|X݂܂B
        /// </remarks>
        protected override void WriteSuccessResponse(HttpContext context)
        {
            // X|XݑOɈꎞt@C̍폜sB
            Release(context);
            base.WriteSuccessResponse(context);
        }

        /// <summary>
        /// VXeG[̃X|X݂̏s܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <param name="ex">OIuWFNgB</param>
        /// <remarks>
        /// <para>
        /// <see cref="Release"/> ĂяoAꎞۊǃfBNg
        /// ̔z̃t@C폜A <see cref="BLogicRequestController.WriteSystemErrorResponse"/> Ăяo
        /// X|X݂܂B
        /// </para>
        /// <para>
        /// <see cref="Release"/> ɂĔO͕⑫A
        /// X|X̐ƂȂOu <see cref="BLogicRequestController.WriteSystemErrorResponse"/> ɓn܂B
        /// </para>
        /// </remarks>
        [System.Diagnostics.CodeAnalysis.SuppressMessage("Microsoft.Design", "CA1031:DoNotCatchGeneralExceptionTypes")]
        protected override void WriteSystemErrorResponse(HttpContext context, Exception ex)
        {
            // X|XݑOɈꎞt@C̍폜sB
            Exception targetEx = ex;
            try
            {
                Release(context);
            }
            catch (Exception newEx)
            {
                if (_log.IsWarnEnabled)
                {
                    _log.Warn(Properties.Resources.W_NOT_DELETE_FILE, newEx);
                }

                // ㏈ŗOꍇ͂ŃLb`O
                // ƂɃX|X쐬܂B
                targetEx = newEx;
            }
            base.WriteSystemErrorResponse(context, targetEx);
        }

        /// <summary>
        /// NGXgɗp\[X̌㏈s܂B
        /// </summary>
        /// <param name="context"> 
        /// HTTP v邽߂ɎgpAgݍ݂̃T[o[ IuWFNg
        /// (Ƃ΁A Request A Response A Session A Server )
        /// ւ̎QƂ񋟂 <see cref="HttpContext"/> NX̃CX^XB
        /// </param>
        /// <remarks>
        /// <para>
        /// NGXgɐꎞۊǃfBNg
        /// сA̔z̃TufBNgAt@C폜܂B
        /// </para>
        /// <para>
        /// ΏۂƂȂfBNgpX<see cref="HttpContext.Items"/>  <see cref="KEY_CONTEXT_ITEM_TMP_DIR_INFO"/> 擾܂B
        /// </para>
        /// </remarks>
        /// <para>
        /// <see cref="HttpContext.Items"/> 
        /// <see cref="KEY_CONTEXT_ITEM_TMP_DIR_INFO"/> ݒ肳ĂȂꍇA
        /// ΏۂƂȂfBNgȂꍇ́A܂B
        /// </para>
        /// <exception cref="TerasolunaException">
        /// Abv[ht@C̈ꎞt@C폜邱Ƃł܂B
        /// </exception>
        protected virtual void Release(HttpContext context)
        {
            // ꎞt@CۊǃfBNg폜܂B
            string tempDirPath = context.Items[KEY_CONTEXT_ITEM_TMP_DIR_INFO] as string;
            if (tempDirPath != null)
            {
                if (Directory.Exists(tempDirPath))
                {
                    try
                    {
                        Directory.Delete(tempDirPath, true);
                    }
                    catch (IOException ioe)
                    {
                        TerasolunaException exception = new TerasolunaException(Properties.Resources.E_DELETE_TMPFILE_FAILED, ioe);
                        if (_log.IsErrorEnabled)
                        {
                            _log.Error(exception.Message, exception);
                        }
                        throw exception;
                    }
                    catch (UnauthorizedAccessException uae)
                    {
                        TerasolunaException exception = new TerasolunaException(Properties.Resources.E_DELETE_TMPFILE_FAILED, uae);
                        if (_log.IsErrorEnabled)
                        {
                            _log.Error(exception.Message, exception);
                        }
                        throw exception;
                    }
                }
            }
        }
    }
}
