// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Web.Configuration.ExceptionCode
{
    /// <summary>
    /// G[ʑJڐݒt@C ExceptionTransitionConfiguration ݒ擾܂B
    /// </summary>
    public abstract class ExceptionCodeConfiguration
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private static ILog _log = LogFactory.GetLogger(typeof(ExceptionCodeConfiguration));

        /// <summary>
        /// w肳ꂽOɑΉOR[h擾܂B
        /// </summary>
        /// <param name="type">O <see cref="Type"/> B</param>
        /// <returns>
        /// <paramref name="type"/> Ɏw肳ꂽOɑΉOR[hB
        /// ΉOR[h݂Ȃꍇ null QƁB
        /// </returns>
        /// <remarks>
        /// OR[hݒt@CA<paramref name="type"/> ̒lɑΉ code ̒l擾܂B
        /// Ή code ̒l݂ȂꍇAnull QƂԂ܂B
        /// </remarks>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="type"/>  null QƂłB
        /// </exception>
        /// <exception cref="System.Configuration.ConfigurationErrorsException">
        /// \t@CǂݍނƂł܂B
        /// </exception>
        public static string GetCode(Type type)
        {
            if (type == null)
            {
                ArgumentNullException exception = new ArgumentNullException("type");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "type"), exception);
                }
                throw exception;
            }

            string ret = null;

            ExceptionCodeConfigurationSection eccs = TerasolunaWebConfiguration.ExceptionCodeConfigSection;
            if (eccs != null)
            {
                ExceptionCodeElement element = eccs.ExceptionCodeCollection[type.FullName];
                if (element != null)
                {
                    ret = element.Code;
                }
            }

            return ret;
        }

        /// <summary>
        /// w肳ꂽOɑ΂ OR[h 擾܂B
        /// </summary>
        /// <remarks>
        /// w肳ꂽOCX^X̊SNX̂L[ƂAOR[hݒt@C
        /// OR[h擾܂B
        /// Ώۂ̗OR[hݒ肪Ȃꍇ̓x[XNX̗OSNX̂擾A
        /// ēx݂܂B
        /// <see cref="Exception"/> Ɏ܂łɑΉOR[h擾łȂ
        /// ꍇ null ԋp܂B
        /// </remarks>
        /// <param name="ex">
        /// <see cref="System.Exception"/> IuWFNgB
        /// </param>
        /// <returns>
        /// <paramref name="ex"/> Ɏw肳ꂽOɑΉOR[hB
        /// ΉOR[h݂Ȃꍇ null QƂԋp܂B
        /// </returns>
        /// <exception cref="ArgumentNullException">
        /// <paramref name="ex"/>  null QƂłB
        /// </exception>
        /// <exception cref="System.Configuration.ConfigurationErrorsException">
        /// \t@CǂݍނƂł܂łB
        /// </exception>
        public static string GetExceptionCode(Exception ex)
        {
            if (ex == null)
            {
                ArgumentNullException exception = new ArgumentNullException("ex");
                if (_log.IsErrorEnabled)
                {
                    _log.Error(string.Format(
                        Properties.Resources.E_NULL_ARGUMENT, "ex"), exception);
                }
                throw exception;
            }

            Type t = ex.GetType();

            string code = null;

            while (t != null)
            {
                code = GetCode(t);
                if (code != null)
                {
                    break;
                }
                t = t.BaseType;
            }

            if (_log.IsTraceEnabled)
            {
                if (code == null)
                {
                    string message = string.Format(
                        Properties.Resources.T_EXCEPTION_CODE_CONFIGURATION_NOT_LOAD_PARAMETER, ex.GetType().FullName);
                    _log.Trace(message);
                }
                else
                {
                    string message = string.Format(
                        Properties.Resources.T_EXCEPTION_CODE_CONFIGURATION_LOAD_PARAMETER, ex.GetType().FullName, code);
                    _log.Trace(message);
                }
            }
            return code;
        }
    }
}
