﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.  

using System.Collections.Generic;
using TERASOLUNA.Fw.Common.BLogic;
using TERASOLUNA.Fw.Web.Controller;

namespace TERASOLUNA.Fw.Web.BLogic
{
    /// <summary>
    /// 受け取ったデータをパートごとに保持した <see cref="IMultipartItem"/> を配列に格納したものを使用するためのインターフェイスです。
    /// </summary>
    public interface IUploadBLogic : IBLogic
    {
        /// <summary>
        /// 受け取ったデータをパートごとに保持した <see cref="IMultipartItem"/> を配列に格納したものを取得または設定します。
        /// </summary>
        /// <value>
        /// マルチパートデータを保持した配列。
        /// </value>
        IDictionary<string, IMultipartItem> MultipartItemList { get; set;}
    }
}
