﻿// <著作権>
// Copyright (c) 2008, NTT DATA Corporation.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Common;
using System.Runtime.Serialization;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using System.IO;
using System.Runtime.Serialization.Formatters.Binary;

namespace TERASOLUNA.Fw.CommonUT
{
    /// <summary>
    ///TERASOLUNA.Fw.Exception.TerasolunaException のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Exception.TerasolunaException 単体テストをここに含めます
    ///</summary>
    
    [TestClass()]
    public class TerasolunaExceptionTest
    {
        private TestContext testContextInstance;

        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        [TestInitialize()]
        public void MyTestInitialize()
        {
            LogUTUtil.Clear();
        }

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException () のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestAssertion>インスタンスが返却されること</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor01()
        {
            TerasolunaException target = new TerasolunaException();

            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestAssertion>設定したメッセージを取得できること</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor02()
        {
            string message = "TERASOLUNA";
            TerasolunaException target = new TerasolunaException(message);
            Assert.AreEqual("TERASOLUNA", target.Message);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string, Exception) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestAssertion>設定したメッセージを取得できること</TestAssertion>
        /// <TestAssertion>設定した例外を取得できること</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor03()
        {
            string message = "TERASOLUNA";
            System.Exception inner = new ArgumentException();
            TerasolunaException target =
                new TerasolunaException(message, inner);
            Assert.AreEqual("TERASOLUNA", target.Message);
            Assert.IsTrue(target.InnerException is ArgumentException);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition>引数に空文字を指定</TestPreCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor06()
        {
            string message = "";

            TerasolunaException target = new TerasolunaException(message);

            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition>引数にnullを指定</TestPreCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor07()
        {
            string message = null;

            TerasolunaException target = new TerasolunaException(message);

            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaException), LogLevel.INFO));
        }


        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string, Exception) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestPreCondition>第一引数に空文字を指定</TestPreCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor08()
        {
            string message = "";
            Exception inner = new ArgumentException();

            TerasolunaException target = new TerasolunaException(message, inner);
            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string, Exception) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestPreCondition>第一引数にnullを指定</TestPreCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor09()
        {
            string message = null;
            Exception inner = new ArgumentException();

            TerasolunaException target = new TerasolunaException(message, inner);

            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException (string, Exception) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestPreCondition></TestPreCondition>
        /// <TestPreCondition>第二引数にnullを指定</TestPreCondition>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor10()
        {
            string message = "TERASOLUNA";
            System.Exception inner = new ArgumentException();
            inner = null;

            TerasolunaException target = new TerasolunaException(message, inner);

            Assert.IsNotNull(target);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaException), LogLevel.INFO));
        }

        ///--------------------------------------------------------------------
        /// <summary>
        /// TerasolunaException(SerializationInfo, StreamingContext) のテスト
        /// </summary>
        /// <TestTarget>ctor</TestTarget>
        /// <TestAssertion>例外がスローされないこと</TestAssertion>
        /// <remarks></remarks>
        ///--------------------------------------------------------------------
        [TestMethod()]
        public void TestCtor11()
        {
            string expectedMessage = "TERASOLUNA";
            TerasolunaException newException = new TerasolunaException(expectedMessage);
            TerasolunaException deserializeException = null;

            // シリアライズ用に利用
            using(MemoryStream stream = new MemoryStream())
            {
                // 例外をシリアライズ
                IFormatter formatter = new BinaryFormatter();
                formatter.Serialize(stream, newException);

                // シリアライズした例外をデシリアライズ
                stream.Position = 0;
                deserializeException = (TerasolunaException)formatter.Deserialize(stream);
            }

            //確認
            Assert.IsNotNull(newException);
            Assert.IsNotNull(deserializeException);
            Assert.AreEqual(expectedMessage, deserializeException.Message);
            //ログ
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(TerasolunaException), LogLevel.INFO));
        }
    }
}
