// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Configuration;
using Microsoft.Practices.EnterpriseLibrary.Validation;
using Microsoft.Practices.EnterpriseLibrary.Validation.Configuration;
using TERASOLUNA.Fw.Common.Validation.Validators;

namespace TERASOLUNA.Fw.Common.Validation.Configuration
{
    /// <summary>
    /// ݒ񂩂 <see cref="NumberValidator"/> 𐶐E邽߂ <see cref="ValidatorData"/> pNXłB
    /// </summary>
    public class NumberValidatorData : ValueValidatorData
    {
        private const string INTEGER_LENGTH_PROPERTY_NAME = "integerLength";
        private const string SCALE_LENGTH_PROPERTY_NAME = "scale";
        private const string IS_INTEGER_ACCORDED_PROPERTY_NAME = "isAccordedInteger";
        private const string IS_SCALE_ACCORDED_PROPERTY_NAME = "isAccordedScale";

        /// <summary>
        /// <see cref="NumberValidatorData"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public NumberValidatorData()
        { }

        /// <summary>
        /// ̌擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>̌B</value>
        [ConfigurationProperty(INTEGER_LENGTH_PROPERTY_NAME, IsRequired = true)]
        public int IntegerLength
        {
            get { return (int)this[INTEGER_LENGTH_PROPERTY_NAME]; }
            set { this[INTEGER_LENGTH_PROPERTY_NAME] = value; }
        }

        /// <summary>
        /// ̌擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>̌B</value>
        [ConfigurationProperty(SCALE_LENGTH_PROPERTY_NAME, DefaultValue = 0)]
        public int Scale
        {
            get { return (int)this[SCALE_LENGTH_PROPERTY_NAME]; }
            set { this[SCALE_LENGTH_PROPERTY_NAME] = value; }
        }

        /// <summary>
        /// ̌v`FbN邩ǂbooll擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>̌v`FbN邩ǂboollB</value>
        [ConfigurationProperty(IS_SCALE_ACCORDED_PROPERTY_NAME, DefaultValue = false)]
        public bool IsAccordedScale
        {
            get { return (bool)this[IS_SCALE_ACCORDED_PROPERTY_NAME]; }
            set { this[IS_SCALE_ACCORDED_PROPERTY_NAME] = value; }
        }

        /// <summary>
        /// ̌v`FbN邩ǂbooll擾܂͐ݒ肵܂B
        /// </summary>
        /// <value>̌v`FbN邩ǂboollB</value>
        [ConfigurationProperty(IS_INTEGER_ACCORDED_PROPERTY_NAME, DefaultValue = false)]
        public bool IsAccordedInteger
        {
            get { return (bool)this[IS_INTEGER_ACCORDED_PROPERTY_NAME]; }
            set { this[IS_INTEGER_ACCORDED_PROPERTY_NAME] = value; }
        }

        /// <summary>
        /// ݒ <see cref="NumberValidator"/> ̃CX^X𐶐܂B
        /// </summary>
        /// <remarks>
        /// <see cref="NumberValidator"/> ̃CX^X𐶐Aԋp܂B
        /// </remarks>
        /// <param name="targetType">ؑΏۂ̒ľ^B</param>
        /// <returns>ꂽ <see cref="NumberValidator"/> B</returns>
        /// <exception cref="ArgumentException">
        /// <list type="bullet">
        /// <item>
        /// <seealso cref="IntegerLength"/>  0 ȉłB
        /// </item>
        /// <item>
        /// <seealso cref="Scale"/> 0łB
        /// </item>
        /// </list>
        /// </exception>          
        protected override Validator DoCreateValidator(Type targetType)
        {
            return new NumberValidator(IntegerLength,
                                       IsAccordedInteger,
                                       Scale,
                                       IsAccordedScale,
                                       MessageTemplate,
                                       Tag,
                                       Negated);
        }
    }
}
