// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Text;
using TERASOLUNA.Fw.Client.Conversion;
using System.Data;

namespace TERASOLUNA.Fw.ClientUT.CoordinatorTestData
{
    public class Coordinator_IConverterImpl01 : IConverter
    {
        // Convert() 呼び出し確認用
        private string _convertId = null;
        private DataSet _convertSrcData = null;
        private DataSet _convertDestData = null;
        private bool _isCalledConvert = false;

        // Reverse() 呼び出し確認用
        private string _reverseId = null;
        private DataSet _reverseSrcData = null;
        private DataSet _reverseDestData = null;
        private bool _isCalledReverse = false;

        public string ConvertId
        {
            get { return _convertId; }
        }

        public DataSet ConvertSrcData
        {
            get { return _convertSrcData; }
        }

        public DataSet ConvertDestData
        {
            get { return _convertDestData; }
        }

        public bool IsCalledConvert
        {
            get { return _isCalledConvert; }
        }

        public string ReverseId
        {
            get { return _reverseId; }
        }

        public DataSet ReverseSrcData
        {
            get { return _reverseSrcData; }
        }

        public DataSet ReverseDestData
        {
            get { return _reverseDestData; }
        }

        public bool IsCalledReverse
        {
            get { return _isCalledReverse; }
        }

        public void Convert(string id, DataSet srcData, DataSet destData)
        {
            _convertId = id;
            _convertSrcData = srcData;
            _convertDestData = destData;
            _isCalledConvert = true;
        }

        public void Reverse(string id, DataSet srcData, DataSet destData)
        {
            _reverseId = id;
            _reverseSrcData = srcData;
            _reverseDestData = destData;
            _isCalledReverse = true;
        }
    }
}
