// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using Microsoft.VisualStudio.TestTools.UnitTesting;
using System;
using System.Text;
using System.Collections.Generic;
using TERASOLUNA.Fw.Utlib.Logging;
using TERASOLUNA.Fw.Common.Logging;
using TERASOLUNA.Fw.Client.Communication;
using TERASOLUNA.Fw.ClientUT.Communication.ReceiverBaseData;
namespace TERASOLUNA.Fw.ClientUT.Communication
{
    /// <summary>
    ///TERASOLUNA.Fw.Client.Communication.Receiver.ReceiverBase&lt;T&gt; のテスト クラスです。すべての
    ///TERASOLUNA.Fw.Client.Communication.Receiver.ReceiverBase&lt;T&gt; 単体テストをここに含めます
    ///</summary>
    [TestClass()]
    public class ReceiverBaseTest
    {


        private TestContext testContextInstance;

        /// <summary>
        ///現在のテストの実行についての情報および機能を
        ///提供するテスト コンテキストを取得または設定します。
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }
        #region 追加のテスト属性
        // 
        //テストを作成するときに、次の追加属性を使用することができます:
        //
        //クラスの最初のテストを実行する前にコードを実行するには、ClassInitialize を使用
        //
        //[ClassInitialize()]
        //public static void MyClassInitialize(TestContext testContext)
        //{
        //}
        //
        //クラスのすべてのテストを実行した後にコードを実行するには、ClassCleanup を使用
        //
        //[ClassCleanup()]
        //public static void MyClassCleanup()
        //{
        //}
        //
        //各テストを実行する前にコードを実行するには、TestInitialize を使用
        //
        //[TestInitialize()]
        //public void MyTestInitialize()
        //{
        //}
        //
        //各テストを実行した後にコードを実行するには、TestCleanup を使用
        //
        //[TestCleanup()]
        //public void MyTestCleanup()
        //{
        //}
        //
        #endregion

        /// <summary>
        /// BufferSize のテスト
        /// </summary>
        /// <remarks>
        /// 1以上の数値を設定した場合、
        /// 設定した値を取得することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void BufferSizeTest01()
        {
            // 準備
            ReceiverBase target = new ReceiverBaseImpl();
            int expectedBufferSize = 1;

            // 実行
            target.BufferSize = expectedBufferSize;
            int actualBufferSize = target.BufferSize;

            // 結果
            Assert.AreEqual(expectedBufferSize, actualBufferSize);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ReceiverBase), LogLevel.INFO));
        }

        /// <summary>
        /// BufferSize のテスト
        /// </summary>
        /// <remarks>
        /// 0 を設定した場合、
        /// デフォルトの BufferSize 値を取得することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void BufferSizeTest02()
        {
            // 準備
            ReceiverBase target = new ReceiverBaseImpl();
            int expectedBufferSize = 0;
            int expectedDefaultBufferSize = 1024 * 8;

            // 実行
            target.BufferSize = expectedBufferSize;
            int actualBufferSize = target.BufferSize;

            // 結果
            Assert.AreEqual(expectedDefaultBufferSize, actualBufferSize);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ReceiverBase), LogLevel.INFO));
        }

        /// <summary>
        /// BufferSize のテスト
        /// </summary>
        /// <remarks>
        /// -1 を設定した場合、
        /// デフォルトの BufferSize 値を取得することを確認するテスト。
        /// </remarks>
        [TestMethod()]
        public void BufferSizeTest03()
        {
            // 準備
            ReceiverBase target = new ReceiverBaseImpl();
            int expectedBufferSize = -1;
            int expectedDefaultBufferSize = 1024 * 8;

            // 実行
            target.BufferSize = expectedBufferSize;
            int actualBufferSize = target.BufferSize;

            // 結果
            Assert.AreEqual(expectedDefaultBufferSize, actualBufferSize);

            // ログの確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ReceiverBase), LogLevel.INFO));
        }

        /// <summary>
        /// CalcReceivePercentage (int, long) のテスト
        /// </summary>
        [TestMethod()]
        public void CalcReceivePercentageTest01()
        {
            ReceiverBaseImpl target = new ReceiverBaseImpl();
            TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor accessor = new TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor(target);
            int actual = accessor.CalcReceivePercentage(0, 1);
            Assert.AreEqual(50, actual);

            // ログ確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ReceiverBase), LogLevel.INFO));
        }

        /// <summary>
        /// CalcReceivePercentage (int, long) のテスト
        /// </summary>
        [TestMethod()]
        public void CalcReceivePercentageTest02()
        {
            ReceiverBaseImpl target = new ReceiverBaseImpl();
            TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor accessor = new TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor(target);
            int actual = accessor.CalcReceivePercentage(1, 1);
            Assert.AreEqual(100, actual);

            // ログ確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ReceiverBase), LogLevel.INFO));
        }

        /// <summary>
        /// CalcReceivePercentage (int, long) のテスト
        /// </summary>
        [TestMethod()]
        public void CalcReceivePercentageTest03()
        {
            ReceiverBaseImpl target = new ReceiverBaseImpl();
            TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor accessor = new TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor(target);
            int actual = accessor.CalcReceivePercentage(2, 3);
            Assert.AreEqual(2 * 50 / 3, actual - 50); // 83であることの確認

            // ログ確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ReceiverBase), LogLevel.INFO));
        }


        /// <summary>
        /// GetEncodingTest (string) のテスト
        /// </summary>
        [TestMethod()]
        public void GetEncodingTest01()
        {
            ReceiverBaseImpl target = new ReceiverBaseImpl();
            TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor accessor = new TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor(target);

            Encoding actual = accessor.GetEncoding(null);

            // 確認
            Assert.IsInstanceOfType(actual, typeof(ASCIIEncoding));

            // ログ確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ReceiverBase), LogLevel.INFO));
        }

        /// <summary>
        /// GetEncodingTest (string) のテスト
        /// </summary>
        [TestMethod()]
        public void GetEncodingTest02()
        {
            ReceiverBaseImpl target = new ReceiverBaseImpl();
            TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor accessor = new TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor(target);

            Encoding actual = accessor.GetEncoding(string.Empty);

            // 確認
            Assert.IsInstanceOfType(actual, typeof(ASCIIEncoding));

            // ログ確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ReceiverBase), LogLevel.INFO));
        }

        /// <summary>
        /// GetEncodingTest (string) のテスト
        /// </summary>
        [TestMethod()]
        public void GetEncodingTest03()
        {
            ReceiverBaseImpl target = new ReceiverBaseImpl();
            TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor accessor = new TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor(target);

            Encoding actual = accessor.GetEncoding("TERASOLUNA");

            // 確認
            Assert.IsInstanceOfType(actual, typeof(ASCIIEncoding));

            // ログ確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ReceiverBase), LogLevel.INFO));
        }

        /// <summary>
        /// GetEncodingTest (string) のテスト
        /// </summary>
        [TestMethod()]
        public void GetEncodingTest04()
        {
            ReceiverBaseImpl target = new ReceiverBaseImpl();
            TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor accessor = new TERASOLUNA_Fw_Client_Communication_ReceiverBaseAccessor(target);

            Encoding actual = accessor.GetEncoding("UTF-8");

            // 確認
            Assert.IsInstanceOfType(actual, Encoding.UTF8.GetType());

            // ログ確認
            Assert.AreEqual(0, LogUTUtil.CountLogs(typeof(ReceiverBase), LogLevel.INFO));
        }
    }
}
