// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Data;

namespace TERASOLUNA.Fw.Client
{
    /// <summary>
    /// <see cref="EventController.PreprocessedFailed"/> Cxg̃f[^񋟂܂B
    /// </summary>
    /// <remarks>
    /// Cxg@\񋟂OG[Cxg (<see cref="EventController.PreprocessedFailed"/>) 
    /// Cxgnh֓np^łB
    /// </remarks>
    public class PreprocessedFailedEventArgs@: EventArgs
    {
        /// <summary>
        /// <see cref="Coordinator"/> ł̑OG[ʂłB
        /// </summary>
        private ExecutionResult _executionResult = null;

        /// <summary>
        /// rWlXWbN<see cref="DataSet"/> B
        /// </summary>
        private DataSet _blogicParamData = null;

        /// <summary>
        /// <see cref="Coordinator"/> ł̑OG[ʂ擾܂B
        /// </summary>
        /// <value>
        /// <see cref="Coordinator"/> ł̑OG[ʁB
        /// </value>
        public ExecutionResult ExecutionResult
        {
            get
            {
                return _executionResult;
            }

        }
        /// <summary>
        /// rWlXWbN <see cref="DataSet"/> 擾܂B
        /// </summary>
        /// <value>
        /// rWlXWbN <see cref="DataSet"/> B
        /// </value>
        public DataSet BLogicParamData
        {
            get
            {
                return _blogicParamData;
            }
        }

        /// <summary>
        /// <see cref="PreprocessedFailedEventArgs"/> NX̐VCX^X܂B
        /// </summary>
        /// <param name="blogicParamData">
        /// rWlXWbN <see cref="DataSet"/> B
        /// </param>
        /// <param name="executionResult">
        /// <see cref="Coordinator"/> ł̑OG[ʁB
        /// </param>
        public PreprocessedFailedEventArgs(ExecutionResult executionResult, DataSet blogicParamData)
        {
            _executionResult = executionResult;
            _blogicParamData = blogicParamData;
        }
    }
}
