﻿// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Windows.Forms;

namespace TERASOLUNA.Fw.Client.Forms
{
    /// <summary>
    /// フォワード結果を識別する列挙体です。
    /// </summary>
    /// <remarks>
    /// <para>
    /// <see cref="DialogResult"/> と同様の値を持ちます。 <see cref="ForwarderBase.Execute"/> の
    /// 戻り値として使用されます。
    /// </para>
    /// <para>
    /// デフォルトの実装では、画面が正常に初期化された場合は 「None」 が返却され、異常があった
    /// 場合は 「Abort」 が返却されます。
    /// </para>
    /// </remarks>
    public enum ForwardResult
    {
        /// <summary>
        /// 画面からの戻り値は 「Abort」 です。画面の初期化に失敗した場合、この値が返されます。
        /// </summary>
        Abort, 
        /// <summary>
        /// 画面からの戻り値は 「Cancel」 です。通常は "キャンセル" というラベルが指定された
        /// ボタン、またはアプリケーションモーダルで表示したフォームの右上の×ボタンを押して閉じた
        /// 際に送られます。
        /// </summary>
        Cancel,
        /// <summary>
        /// 画面からの戻り値は 「Ignore」 です。通常は "無視" というラベルが指定されたボタンから
        /// 送られます。
        /// </summary>
        Ignore,
        /// <summary>
        /// 画面からの戻り値は 「No」 です。通常は "いいえ" というラベルが指定された
        /// ボタンから送られます。
        /// </summary>
        No,
        /// <summary>
        /// 画面からの戻り値は 「None」 です。画面からの戻り値が存在しない場合に返却されます。
        /// モードレスの画面を表示した際に返されます。
        /// </summary>
        None,
        /// <summary>
        /// 画面からの戻り値は 「OK」 です。通常は "OK" というラベルが指定されたボタンから送られ
        /// ます。
        /// </summary>
        OK,
        /// <summary>
        /// 画面からの戻り値は 「Retry」 です。通常は "再試行" というラベルが指定されたボタンから
        /// 送られます。
        /// </summary>
        Retry,
        /// <summary>
        /// 画面からの戻り値は 「Yes」 です。通常は "はい" というラベルが指定されたボタンから送られ
        /// ます。
        /// </summary>
        Yes
    }
}
