// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System;
using System.Collections.Generic;
using System.Net;

namespace TERASOLUNA.Fw.Client.Communication
{
    /// <summary>
    /// f[^M@\񋟂C^[tFCXłB
    /// </summary>
    /// <typeparam name="TParam">
    /// T[oɑMf[^IuWFNǧ^B
    /// </typeparam>
    public interface IHttpSender<TParam> where TParam : class
    {
        /// <summary>
        /// <paramref name="request"/> œnꂽ <see cref="HttpWebRequest"/> pāA
        /// <paramref name="paramData"/>  <paramref name="headerCollection"/> ̏𑗐M܂B
        /// </summary>
        /// <remarks>
        /// <see cref="IHttpSender{TParam}.Send"/> ہA
        /// ʐM̗O <see cref="WebException"/> ƂăX[܂B
        /// </remarks>
        /// <param name="request">MsNGXgIuWFNgB</param>
        /// <param name="paramData">Mf[^i[IuWFNgB</param>
        /// <param name="headerCollection">
        /// NGXgwb_̖Oƒl̃yAi[Ă <see cref="IDictionary{String, String}"/>B
        /// </param>
        /// <param name="reporter">is󋵒ʒms <see cref="IProgressChangeReporter"/>B</param>
        /// <exception cref="ArgumentNullException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <paramref name="request"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="paramData"/>  null QƂłB
        /// </item>
        /// <item>
        /// <paramref name="headerCollection"/>  null QƂłB
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ArgumentException">
        /// ʐMŕKvȃf[^słB
        /// </exception>
        /// <exception cref="WebException">
        /// T[oƂ̒ʐMɃG[܂B܂͒ʐMLZ܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// MɓŃG[܂B
        /// </exception>
        void Send(HttpWebRequest request,
                  TParam paramData,
                  IDictionary<string, string> headerCollection,
                  IProgressChangeReporter reporter);
    }
}
