// Copyright (c) 2008, NTT DATA Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

using System.Data;
using System.IO;
using System.Net;
using System.Text;
using System.Xml;
using TERASOLUNA.Fw.Common.Logging;

namespace TERASOLUNA.Fw.Client.Communication
{
    /// <summary>
    /// XML M@\񋟂NXłB
    /// </summary>
    /// <typeparam name="TResult">
    /// M XML f[^i[邽߂̃f[^Zbg^B
    /// </typeparam>
    public class DataSetXmlReceiver<TResult> : ReceiverBase
        where TResult : DataSet, new()
    {
        /// <summary>
        /// <see cref="ILog"/> NX̃CX^XłB
        /// </summary>
        /// <remarks>
        /// Oo͂ɗp܂B
        /// </remarks>
        private ILog _log = LogFactory.GetLogger(typeof(DataSetXmlReceiver<TResult>));

        /// <summary>
        /// M XML f[^ǂݍރ[hłB
        /// </summary>
        private XmlReadMode _readMode = XmlReadMode.Auto;

        /// <summary>
        /// M XML f[^ǂݍރ[h\ <see cref="XmlReadMode"/> l擾܂͐ݒ肵܂B
        /// </summary>
        /// <remarks>
        /// ̃vpeB̃ftHgl "Auto" łB
        /// </remarks>
        public XmlReadMode ReadMode
        {
            get
            {
                return _readMode;
            }
            set
            {
                _readMode = value;
            }
        }

        /// <summary>
        /// <see cref="DataSetXmlReceiver{TResult}"/> NX̐VCX^X܂B
        /// </summary>
        /// <remarks>
        /// ftHgRXgN^łB
        /// </remarks>
        public DataSetXmlReceiver()
        {
        }

        /// <summary>
        /// <paramref name="request"/> œnꂽ <see cref="HttpWebResponse"/>p XML f[^Ms܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// <paramref name="request"/> œnꂽ <see cref="HttpWebResponse"/>  HTTP X|X{fB擾A
        /// <typeparamref name="TResult"/> Ŏw肳ꂽ^̃f[^Zbgɓǂݍ݂܂B
        /// </para>
        /// <para>߂lƂȂ <see cref="CommunicationResult"/> ̊evpeB͈ȉ̒ʂłB</para>
        /// <para>
        /// <list type="table">
        /// <listheader>
        ///     <term>CommunicationResult̃vpeB</term>
        ///     <description>ݒ肳l</description>
        /// </listheader>
        /// <item>
        ///     <term>Headers</term>
        ///     <description>HTTP X|Xwb_̃L[/li[܂B</description>
        /// </item>
        /// <item>
        ///     <term>ResultData</term>
        ///     <description>M XML f[^i[f[^ZbgB</description>
        /// </item>
        /// </list>
        /// </para>
        /// <para>
        /// XML f[^𐳏ɎMĂĂA<typeparamref name="TResult"/> Ŏw肳ꂽf[^Zbǧ^
        /// M XML f[^̌`vȂꍇA<see cref="CommunicationResult"/> ɂ̓f[^͓ǂݍ
        /// ܂܂B
        /// </para>
        /// <para>
        /// T[o瑗 Cookie Ȃǂ̃wb_ <see cref="CommunicationResult.ResponseHeaders"/>@Ɋi[܂B
        /// p҂͕KvɉĂ̏𗘗p邱Ƃł܂B
        /// </para>
        /// <para>
        /// XML f[^ <see cref="DataSet.ReadXml(XmlReader)"/> \bhpēǂݍ܂܂B̂ƂA
        /// XL[}𗘗p邩ǂ <see cref="ReadMode"/> vpeB̒lɂČ܂܂B
        /// </para>
        /// <para>
        /// <paramref name="reporter"/>  <c>null</c> QƂł͂ȂꍇA
        /// <see cref="ReceiverBase.BufferSize"/> vpeBɐݒ肳ꂽobt@TCỸf[^iftHg8 KB jT[oɑM閈ɁA
        /// <see cref="IProgressChangeReporter.ReportProgressChanged"/> Cxg𔭐܂B
        /// </para>
        /// </remarks>
        /// <param name="response">Ms HTTP X|XIuWFNgB</param>
        /// <param name="reporter">is󋵒ʒms<see cref="IProgressChangeReporter"/>CX^XB</param>
        /// <returns>Mʂێ <see cref="CommunicationResult"/>CX^XB</returns>
        /// <exception cref="WebException">
        /// ʐMG[܂B܂́ANGXgLZ܂B
        /// </exception>
        /// <exception cref="CommunicationException">
        /// ȉ̂悤ȏꍇɗOX[܂B
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// Mf[^XMLdł͂܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// MXMLdɃ[gm[h܂B
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// ʐMɃG[܂B
        /// </description>
        /// </item>
        /// </list>
        /// </exception>
        /// <exception cref="ServerException">
        /// T[oŋƖG[܂BT[oł̋ƖG[ HTTP X|Xwb_ "exception" 
        /// wb_邩ǂŔf܂BG[̃nhOɂĂ <see cref="ReceiverBase.HandleErrorResult"/> 
        /// QƂ܂B
        /// </exception>
        protected override CommunicationResult ReceiveResponse(HttpWebResponse response, IProgressChangeReporter reporter)
        {
            // XMLf[^ǂݍ
            XmlDocument receiveXml = GetXmlFromResponseBody(response, reporter);

            // M̃Oo
            if (_log.IsTraceEnabled)
            {
                // HTTPwb_
                StringBuilder responseHeader = new StringBuilder();
                responseHeader.AppendLine(Properties.Resources.T_RESPONSE_RECEIVE_HEADER);
                foreach (string key in response.Headers.AllKeys)
                {
                    responseHeader.AppendLine(string.Format(
                    Properties.Resources.T_DICTIONARY_KEY_VALUE,
                    key, response.Headers[key]));
                }
                _log.Trace(responseHeader.ToString().Trim());

                // HTTP{fB
                StringBuilder responseBody = new StringBuilder();
                responseBody.AppendLine(Properties.Resources.T_RESPONSE_RECEIVE_BODY);
                using (Stream st = new MemoryStream())
                {
                    receiveXml.Save(st);
                    st.Position = 0;
                    StreamReader reader = new StreamReader(st);
                    responseBody.Append(reader.ReadToEnd());
                }
                _log.Trace(responseBody.ToString());
            }

            // T[oŋƖG[Ă΁AServerExceptionƂ
            string errorType = response.Headers[ERROR_TYPE];
            if (errorType != null)
            {
                // T[oŔO̓eServerExceptionɃbvčăX[
                ServerException exception = HandleErrorResult(errorType, receiveXml);
                if (_log.IsErrorEnabled)
                {
                    _log.Error(exception.Message, exception);
                }
                throw exception;
            }

            // XMLDataSetɕϊ
            TResult receiveDataSet = null;
            using (XmlReader xmlReader = new XmlNodeReader(receiveXml))
            {
                receiveDataSet = new TResult();
                receiveDataSet.ReadXml(xmlReader);
            }

            // ʂ CommunicationResult IuWFNgɊi[
            CommunicationResult communicationResult = CreateCommunicationResult(response, receiveDataSet);

            return communicationResult;
        }

        /// <summary>
        /// HTTP X|XƎMf[^i[<paramref name="receiveData"/>ɁA
        /// ʐMʂ\ <see cref="CommunicationResult"/> CX^X쐬܂B
        /// </summary>
        /// <remarks>
        /// <para>
        /// ʐMʂ\ <see cref="CommunicationResult"/> 𐶐܂B<see cref="CommunicationResult.ResultData"/>
        ///  vpeB <paramref name="receiveData"/> i[A<see cref="CommunicationResult.ResponseHeaders"/>vpeB
        /// HTTP X|Xwb_̃L[/lSĒǉ܂B
        /// </para>
        /// <para>
        /// ̃\bh <c>null</c> QƂԂ܂B
        /// </para>
        /// </remarks>
        /// <param name="response">Ms HTTP X|XIuWFNgB</param>
        /// <param name="receiveData">M XML f[^i[f[^Zbg</param>
        /// <returns>ʐMʂ\ <see cref="CommunicationResult"/> CX^XB</returns>
        protected virtual CommunicationResult CreateCommunicationResult(WebResponse response, TResult receiveData)
        {
            CommunicationResult result = new CommunicationResult();
            result.ResultData = receiveData;
            foreach (string key in response.Headers.Keys)
            {
                result.ResponseHeaders.Add(key, response.Headers[key]);
            }
            return result;
        }
    }
}
