/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.JobStatusSummarizer;

/**
 * Ԃ̃T}CYNXB<BR>
 * qWȕԃXgmFAT}CYB<BR>
 * ftHgł́AqWȕʂdvȌʂD悵A
 * eWuԂƂĐݒ肷B
 * iN󋵔ԍ傫dvxƔfBj><BR>Wu
 * C^tF[X<code>JobStatusSummarizer</code>̎NX 
 * <code>bean</code>`<code>id="JobStatusSummarizer"</code>ɒ`邱Ƃ
 * ύX邱ƂłB<BR>
 * 
 */
public class StandardJobStatusSummarizer implements JobStatusSummarizer {

    /**
     * WuԂ̌ʃT}CYB
     * WuԂݒ肷B 
     * qWȕIԂmFA傫̂D悵Đݒ肷B
     * 
     * @param jobStatus
     *            Ώۂ̏
     */
    public void summarize(JobStatus jobStatus) {
        if (jobStatus.getChildJobStatusList() == null
                || jobStatus.getChildJobStatusList().isEmpty()) {
            return;
        }

        // qWȕ󋵂mFAԏdȌ(WuԂint\傫
        // )eWȕ󋵂ɐݒ肷
        for (JobStatus childJobStatus : jobStatus.getChildJobStatusList()) {
            summarize(childJobStatus);

            if (jobStatus.getJobState().ordinal()
                    < childJobStatus.getJobState().ordinal()
                    && (jobStatus.getJobState() != JobStatus.STATE.STARTED
                    || childJobStatus.getJobState() 
                    != JobStatus.STATE.RESTARTED)) {

                jobStatus.setJobState(childJobStatus.getJobState());
                jobStatus.setJobExitCode(childJobStatus.getJobExitCode());
            }
        }
        
        summarizeExitCode(jobStatus);
    }
    
    
    /**
     * WuԂ̏IR[hT}CYB
     * WuԂݒ肷B 
     * eWȕIR[hݒ肳ĂȂꍇ
     * qWȕIR[hmFA傫̂D悵Đݒ肷B
     * 
     * @param jobStatus
     *            Ώۂ̏
     */
    private void summarizeExitCode(JobStatus jobStatus) {
        if (jobStatus.getJobExitCode() != null) {
            return;
        }
        Integer exitCode = null;
        for (JobStatus childJobStatus : jobStatus.getChildJobStatusList()) {
            summarizeExitCode(childJobStatus);
            if (childJobStatus.getJobExitCode() != null
                    && (jobStatus.getJobState() 
                            == childJobStatus.getJobState())) {
                if (exitCode == null) {
                    exitCode = childJobStatus.getJobExitCode();
                } else {
                    if ((exitCode < childJobStatus.getJobExitCode())) {
                        exitCode = childJobStatus.getJobExitCode();
                    }
                }

            }
        }
        jobStatus.setJobExitCode(exitCode);
    }
}
