/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.batch.functionsample.sample007;

import java.util.ArrayList;
import java.util.List;

import jp.terasoluna.fw.batch.openapi.BLogic;
import jp.terasoluna.fw.batch.openapi.BLogicResult;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;
import jp.terasoluna.fw.file.dao.FileLineWriter;
import jp.terasoluna.fw.file.dao.FileUpdateDAO;
import jp.terasoluna.batch.functionsample.common.NyusyukkinData;

/**
 * rWlXWbNNXB<br>
 * iBatis̋@\păwb_--gCo͂B
 * 
 */
public class Sample007BLogic implements BLogic<Sample007HeaderMeisaiData, JobContext> {

    
    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private FileUpdateDAO updateDAO;
    
    /**
     * t@Co̓fBNgB
     * SpringɂCX^Xݒ肳B
     */
    private String basePath;
    
    public BLogicResult execute(Sample007HeaderMeisaiData meisai, JobContext arg1) {

    // t@Co͗psC^̎擾
    FileLineWriter<NyusyukkinData> fileLineWriter 
        = updateDAO.execute(basePath + meisai.getSitenmei() + ".csv", NyusyukkinData.class);

    try{
        //wb_̏o
        List<String> header = new ArrayList<String>();
        header.add("xXF" + meisai.getSitenmei());
        header.add("ZF" + meisai.getSitenjusyo());
        header.add("dbԍF" + meisai.getSitentel());
        fileLineWriter.printHeaderLine(header);

        long nyukinKingaku = 0L;
        long syukkinKingaku = 0L;
        //f[^̏o
        for(NyusyukkinData nyusyukkin : meisai.getNyusyukkinList()){
        	fileLineWriter.printDataLine(nyusyukkin);
        	
        	if(nyusyukkin.getNyusyukkincd() == 0){
        	    nyukinKingaku += nyusyukkin.getKingaku();
        	}else{
        	    syukkinKingaku += nyusyukkin.getKingaku();
        	}
        }
        
        //gC̏o
        List<String> trailer = new ArrayList<String>();
        trailer.add("vF" + nyukinKingaku);
        trailer.add("ovF" + syukkinKingaku);
        fileLineWriter.printTrailerLine(trailer);
        
    }finally{
        fileLineWriter.closeFile();
    }
    
    return new BLogicResult(ReturnCode.NORMAL_CONTINUE);
    }
    
    /**
     * UpdateDAOݒ肷B
     * @param updateDAO ݒ肷UpdateDAO
     */
    public void setUpdateDAO(FileUpdateDAO updateDAO) {
        this.updateDAO = updateDAO;
    }
    
    /**
     * t@Co̓fBNgݒ肷B
     * @param basePath ݒ肷t@Co̓fBNg̃pX
     */
    public void setBasePath(String basePath){
    this.basePath = basePath;
    }

}
