/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.sample.service.blogic;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.fw.dao.QueryDAO;
import jp.terasoluna.fw.service.thin.BLogic;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.sample.commons.ZandakaData;


/**
 * "ce[u"f[^擾Aꗗ\Xg𐶐rWlXWbNNXB
 *
 */
public class ListBLogicImpl implements BLogic<Map<String, String>> {

    /**
     * DAONXB
     * SpringɂCX^Xݒ肳B
     */
    private QueryDAO queryDAO = null;

    /**
     * QueryDAOԋpB
     *
     * @return ێQueryDAO
     */
    public QueryDAO getQueryDAO() {
        return queryDAO;
    }

    /**
     * QueryDAOݒ肷B
     *
     * @param dao ݒ肷QueryDAO
     */
    public void setQueryDAO(QueryDAO dao) {
        this.queryDAO = dao;
    }
    
    
    /**
     * cXgԋpB
     * @param map y[Wێ}bv
     * @return cXg
     */
    public Map<String, Object> getZandakaList(Map<String, String> map) {

        String strIndex = map.get("startIndex");
        String strRow = map.get("row");
        
        //擾̐ݒ
        int startIndex = 0;
        int row = 20;
        if (strIndex != null) {
            try {
                startIndex = Integer.parseInt(strIndex);
            } catch (NumberFormatException e) {
                startIndex = 0;
            }
        }
        if (strRow != null) {
            try {
                row = Integer.parseInt(strRow);
            } catch (NumberFormatException e) {
                row = 20;
            }
        }
        
    	//c擾
    	//ce[uʂɕ\錏̎cf[^ڋqID̏Ŏ擾    
       	ZandakaData[] zandakaDatas = queryDAO.executeForObjectArray("Sample.getZandakaDataList", null, ZandakaData.class, startIndex, row);
       	
    	//擾ԋp
    	//擾wڋqhcxAwcxAwŏIxԋpB
        Map<String, Object> retMap = new HashMap<String, Object>();

        retMap.put("totalCount", getTotalCount());
        retMap.put("zandakaDatas", zandakaDatas);

        return retMap;

    }
    
    /**
     * rWlXWbNsB
     * @param map y[Wێ}bv
     * @return rWlXWbN
     */
    public BLogicResult execute(Map<String, String> map) {
        //BLogicResult̐Aʂ̐ݒ
        //rWlXWbN̎sAʂ̎擾
        Map<String, Object> retMap = getZandakaList(map);
        BLogicResult result = new BLogicResult();
        result.setResultString("success");
        result.setResultObject(retMap);
        return result;
        
    }
    
    /**
     * ꗗ̑S擾ĕԋpB
     *
     * @return 擾
     */
    public String getTotalCount() {

        String count
            = queryDAO.executeForObject("Sample.getZandakaDataCount", null, String.class);
        if (count == null || "".equals(count)) {
            count = "0";
        }
        return count;
        
    }

}
