/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.init;

import java.util.Date;

/**
 * WuǗe[ũf[^擾pp[^NXB<BR>
 * <code>jobControl-sqlMap.xml</code>ɒ`ꂽȉ̃NX`ύX邱Ƃ
 * Ǝ̃p[^NX쐬邱ƂoB<BR>
 * <code>&lt;typeAlias alias="jobControlInfo" 
 * type="jp.terasoluna.fw.batch.init.JobControlInfo"/&gt;</code>
 * 
 */
public class JobControlInfo extends AbstractJobControlInfo {

    /**
     * Serializablepo[WID
     */
    private static final long serialVersionUID = 3551061550379453205L;

    /**
     * WuNGXgԍ
     */
    private String jobRequestNo = null;

    /**
     * WuID
     */
    private String jobId = null;

    /**
     * WuBean`t@CPATH
     */
    private String jobDiscriptorPath = null;

    /**
     * Wup[^
     */
    private String jobParameters = null;

    /**
     * WuN
     */
    private String jobState = null;

    /**
     * WuIR[h
     */
    private String jobExitCode = null;

    /**
     * Wu˗̍XV
     */
    private Date updateTime = null;

    /**
     * Wu˗̓o^
     */
    private Date registerTime = null;

    /**
     * WuIR[h擾B
     * 
     * @return WuIR[h
     */
    public String getJobExitCode() {
        return jobExitCode;
    }

    /**
     * WuIR[hݒB
     * 
     * @param jobExitCode
     *            WuIR[h
     */
    public void setJobExitCode(String jobExitCode) {
        this.jobExitCode = jobExitCode;
    }

    /**
     * WuBean`t@CPATH擾B
     * 
     * @return WuBean`t@CPATH
     */
    public String getJobDiscriptorPath() {
        return jobDiscriptorPath;
    }

    /**
     * WuBean`t@CPATHݒB
     * 
     * @param jobDiscriptorPath
     *            WuBean`t@CPATH
     */
    public void setJobDiscriptorPath(String jobDiscriptorPath) {
        this.jobDiscriptorPath = jobDiscriptorPath;
    }

    /**
     * WuID擾B
     * 
     * @return String WuID
     */
    public String getJobId() {
        return jobId;
    }

    /**
     * WuIDݒB
     * 
     * @param jobId
     *            WuID
     */
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    /**
     * Wup[^擾B
     * 
     * @return Wup[^
     */
    public String[] getJobParameters() {
        if (jobParameters == null) {
            return new String[0];
        }
        return jobParameters.split(getJobParametersSplitStr());
    }

    /**
     * WuNp[^ݒB
     * 
     * @param jobParameters
     *            WuNp[^
     */
    public void setJobParameters(String jobParameters) {
        this.jobParameters = jobParameters;
    }

    /**
     * Wu˗̓o^擾B
     * 
     * @return Wu˗̓o^
     */
    public Date getRegisterTime() {
        return registerTime;
    }

    /**
     * Wu˗̓o^ݒB
     * 
     * @param registerTime
     *            Wu˗̓o^
     */
    public void setRegisterTime(Date registerTime) {
        this.registerTime = registerTime;
    }

    /**
     * WuNGXgԍ擾B
     * 
     * @return WuNGXgԍ
     */
    public String getJobRequestNo() {
        return jobRequestNo;
    }

    /**
     * WuNGXgԍݒB
     * 
     * @param jobRequestNo
     *            WuNGXgԍ
     */
    public void setJobRequestNo(String jobRequestNo) {
        this.jobRequestNo = jobRequestNo;
    }

    /**
     * WuN󋵂擾B
     * 
     * @return WuN
     */
    public String getJobState() {
        return jobState;
    }

    /**
     * WuN󋵂ݒB
     * 
     * @param jobState
     *            WuN
     */
    public void setJobState(String jobState) {
        this.jobState = jobState;
    }

    /**
     * Wu˗̍XV擾B
     * 
     * @return Wu˗̍XV
     */
    public Date getUpdateTime() {
        return updateTime;
    }

    /**
     * Wu˗̍XVݒB
     * 
     * @param updateTime
     *            Wu˗̍XV
     */
    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }
}
