/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;

import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.GenericPropertyUtil} NX̃eXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * <code>JavaBean</code>̃vpeB<code>Generics</code>߂̃[eBeBNXB
 * <p>
 *
 * @see jp.terasoluna.fw.util.GenericPropertyUtil
 */
public class GenericPropertyUtilTest extends TestCase {

    /**
     * PropertyUtilsBeanB
     */
    private PropertyUtilsBean defaultPropertyUtilsBean = null;

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(GenericPropertyUtilTest.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        defaultPropertyUtilsBean = beanUtilsBean.getPropertyUtils();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        UTUtil.setPrivateField(beanUtilsBean, "propertyUtilsBean",
                defaultPropertyUtilsBean);
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public GenericPropertyUtilTest(String name) {
        super(name);
    }

    /**
     * testResolveCollectionType01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * beannull̏ꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveCollectionType01() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveCollectionType(null, null);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveCollectionType02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:ObjectCX^X<br>
     *         () name:null<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * namenull̏ꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveCollectionType02() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveCollectionType(
                    new Object(), null);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveCollectionType03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:ObjectClassCX^X<br>
     *         () name:""i󕶎j<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * name󕶎̏ꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveCollectionType03() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveCollectionType(
                    new Object(), "");
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveCollectionType04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:ObjectClassCX^X<br>
     *         () name:"   "i󔒕j<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * name󔒕̏ꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveCollectionType04() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveCollectionType(
                    new Object(), "   ");
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveCollectionType05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hList<String> list0AgetterȂNXB<br>
     *         () name:"list0"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * Ή郁\bh݂ȂꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveCollectionType05() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveCollectionType(
                    new GenericPropertyUtil_Stub01(),
                    "list0");
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveCollectionType06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() bean:tB[hList<String> list1ƁAgetterNXB<br>
     *         () name:"list1"<br>
     *
     * <br>
     * ҒlF(߂l) Class:String.class<br>
     *
     * <br>
     * vf^擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveCollectionType06() throws Exception {

        // eXg{
        Class actual = GenericPropertyUtil.resolveCollectionType(
                new GenericPropertyUtil_Stub01(),
                "list1");

        // 
        assertEquals(String.class, actual);
    }

    /**
     * testResolveCollectionType07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() bean:tB[hList<Map<String, Object>> list2ƁAgetterNXB<br>
     *         () name:"list2"<br>
     *
     * <br>
     * ҒlF(߂l) Class:Map.class<br>
     *
     * <br>
     * p[^ť^擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveCollectionType07() throws Exception {
        // eXg{
        Class actual = GenericPropertyUtil.resolveCollectionType(
                new GenericPropertyUtil_Stub01(),
                "list2");

        // 
        assertEquals(Map.class, actual);
    }

    /**
     * testResolveCollectionType08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() bean:tB[hList<String[]> list3ƁAgetterNXB<br>
     *         () name:"list3"<br>
     *
     * <br>
     * ҒlF(߂l) Class:String[].class<br>
     *
     * <br>
     * z^擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveCollectionType08() throws Exception {
        // eXg{
        Class actual = GenericPropertyUtil.resolveCollectionType(
                new GenericPropertyUtil_Stub01(),
                "list3");

        // 
        assertEquals(String[].class, actual);
    }

    /**
     * testResolveCollectionType09()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hint integerƁAgetterNXB<br>
     *         () name:"integer"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *
     * <br>
     * w肵vpeBv~eBu^̏ꍇAIllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveCollectionType09() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveCollectionType(
                    new GenericPropertyUtil_Stub01(),
                    "integer");
            // 
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveCollectionType10()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hObject objectƁAgetterNXB<br>
     *         () name:"object"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *
     * <br>
     * w肵vpeBCollectionȊǑ^̏ꍇAIllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveCollectionType10() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveCollectionType(
                    new GenericPropertyUtil_Stub01(),
                    "object");
            // 
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveCollectionType11()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hList<? extends String> list5ƂgetterNXB<br>
     *         () name:"list5"<br>
     *
     * <br>
     * ҒlF(߂l) Class:Object.class<br>
     *
     * <br>
     * ^p[^w肪ChJ[h̏ꍇAObjectԋp邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveCollectionType11() throws Exception {
        // eXg{
        Class actual = GenericPropertyUtil.resolveCollectionType(
                new GenericPropertyUtil_Stub01(),
                    "list5");
        // 
        assertEquals(Object.class, actual);
    }

    /**
     * testResolveTypeObjectStringClassint01()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:null<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'bean' ("<br>
     *                    + Object.class.getName() + " is null"<br>
     *
     * <br>
     * beannull̏ꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeObjectStringClassint01() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(null, (String) null, null, 0);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = "Argument 'bean' ("
                + Object.class.getName() + " is null";
            assertEquals(message ,e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeObjectStringClassint02()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:ObjectCX^X<br>
     *         () name:null<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'name' ("<br>
     *                    + String.class.getName() + " is empty"<br>
     *
     * <br>
     * namenull̏ꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeObjectStringClassint02() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(
                    new Object(), (String) null, null, 0);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = "Argument 'name' ("
                + String.class.getName() + " is empty";
            assertEquals(message ,e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeObjectStringClassint03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:ObjectCX^X<br>
     *         () name:""i󕶎j<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'name' ("<br>
     *                    + String.class.getName() + " is empty"<br>
     *
     * <br>
     * name󕶎̏ꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeObjectStringClassint03() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(
                    new Object(), "", null, 0);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = "Argument 'name' ("
                + String.class.getName() + " is empty";
            assertEquals(message ,e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeObjectStringClassint04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:ObjectCX^X<br>
     *         () name:"   "i󔒕j<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'name' ("<br>
     *                    + String.class.getName() + " is empty"<br>
     *
     * <br>
     * name󔒕̏ꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeObjectStringClassint04() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(
                    new Object(), "   ", null, 0);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = "Argument 'name' ("
                + String.class.getName() + " is empty";
            assertEquals(message ,e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeObjectStringClassint05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hMap<String, Object> map0AgetterȂNXB<br>
     *         () name:"map0"<br>
     *         () genericClass:Map.class<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * Ή郁\bh݂ȂꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeObjectStringClassint05() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(
                    new GenericPropertyUtil_Stub01(),
                    "map0", Map.class, 0);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeObjectStringClassint06()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hMap<String, Object> map1ƂgetterNXB<br>
     *         () name:"map1"<br>
     *         () genericClass:Map.class<br>
     *         () index:-1<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * index̐łꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeObjectStringClassint06() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(
                    new GenericPropertyUtil_Stub01(),
                    "map1", Map.class, -1);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeObjectStringClassint07()
     * <br><br>
     *
     * inj
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() bean:tB[hMap<String, Object> map1ƂgetterNXB<br>
     *         () name:"map1"<br>
     *         () genericClass:Map.class<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(߂l) Class:String.class<br>
     *
     * <br>
     * index^p[^͈͓̔łꍇɌ^擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeObjectStringClassint07() throws Exception {

        // eXg{
        Class actual = GenericPropertyUtil.resolveType(
                new GenericPropertyUtil_Stub01(),
                "map1", Map.class, 0);

        // 
        assertEquals(String.class, actual);
    }

    /**
     * testResolveTypeObjectStringClassint08()
     * <br><br>
     *
     * inj
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() bean:tB[hMap<String, Object> map1ƂgetterNXB<br>
     *         () name:"map1"<br>
     *         () genericClass:Map.class<br>
     *         () index:1<br>
     *
     * <br>
     * ҒlF(߂l) Class:Object.class<br>
     *
     * <br>
     * index^p[^͈͓̔łꍇɌ^擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeObjectStringClassint08() throws Exception {
        // eXg{
        Class actual = GenericPropertyUtil.resolveType(
                new GenericPropertyUtil_Stub01(),
                "map1", Map.class, 0);

        // 
        assertEquals(String.class, actual);
    }

    /**
     * testResolveTypeObjectStringClassint09()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hMap<String, Object> map1ƂgetterNXB<br>
     *         () name:"map1"<br>
     *         () genericClass:Map.class<br>
     *         () index:2<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * index^p[^͈̔͊OłꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeObjectStringClassint09() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(
                    new GenericPropertyUtil_Stub01(),
                    "map1", Map.class, 2);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeObjectStringClassint10()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hMap<String, Object> map1ƂgetterNXB<br>
     *         () name:"map1"<br>
     *         () genericClass:null<br>
     *         () index:1<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *
     * <br>
     * genericClassnullłꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeObjectStringClassint10() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(
                    new GenericPropertyUtil_Stub01(),
                    "map1", null, 1);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeObjectStringClassint11()
     * <br><br>
     *
     * inj
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() bean:tB[hMap<String[], List<String>> map2ƂgetterNXB<br>
     *         () name:"map2"<br>
     *         () genericClass:Map.class<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(߂l) Class:String[].class<br>
     *
     * <br>
     * z^擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeObjectStringClassint11() throws Exception {

        // eXg{
        Class actual = GenericPropertyUtil.resolveType(
                new GenericPropertyUtil_Stub01(),
                "map2", Map.class, 0);

        // 
        assertEquals(String[].class, actual);
    }

    /**
     * testResolveTypeObjectStringClassint12()
     * <br><br>
     *
     * inj
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() bean:tB[hMap<String[], List<String>> map2ƂgetterNXB<br>
     *         () name:"map2"<br>
     *         () genericClass:Map.class<br>
     *         () index:1<br>
     *
     * <br>
     * ҒlF(߂l) Class:List.class<br>
     *
     * <br>
     * p[^ť^擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeObjectStringClassint12() throws Exception {
        // eXg{
        Class actual = GenericPropertyUtil.resolveType(
                new GenericPropertyUtil_Stub01(),
                "map2", Map.class, 1);

        // 
        assertEquals(List.class, actual);
    }

    /**
     * testResolveTypeObjectStringClassint13()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hMap<String[], List<String>> map2ƂgetterNXB<br>
     *         () name:"map2"<br>
     *         () genericClass:String.class<br>
     *         () index:1<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *
     * <br>
     * genericClasstB[ȟ^ƍvȂꍇA
     * IllegalStateExceptionX[邱ƂmFeXgBB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeObjectStringClassint13() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(new GenericPropertyUtil_Stub01(),
                    "map2", String.class, 1);
            // 
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeObjectStringClassint14()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hint integerƂgetterNXB<br>
     *         () name:"integer"<br>
     *         () genericClass:int.class<br>
     *         () index:1<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                            bZ[WF"No parameterizedType was detected."<br>
     *
     * <br>
     * w肵vpeBv~eBu^̏ꍇA
     * IllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeObjectStringClassint14() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(
                    new GenericPropertyUtil_Stub01(),
                    "integer", int.class, 1);
            // 
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            assertEquals("No parameterizedType was detected.",
                    e.getMessage());
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeObjectStringClassint15()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hObject objectƂgetterNXB<br>
     *         () name:"object"<br>
     *         () genericClass:Object.class<br>
     *         () index:1<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                            bZ[WF"No parameterizedType was detected."<br>
     *
     * <br>
     * w肵vpeBIuWFNg^̏ꍇA
     * IllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeObjectStringClassint15() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(
                    new GenericPropertyUtil_Stub01(),
                    "object", Object.class, 1);
            // 
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            assertEquals("No parameterizedType was detected.",
                    e.getMessage());
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeObjectStringClassint16()
     * <br><br>
     *
     * inj
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() bean:tB[hMap<?, ?> map3ƂgetterNXB<br>
     *         () name:"map3"<br>
     *         () genericClass:Map.class<br>
     *         () index:1<br>
     *
     * <br>
     * ҒlF(߂l) Class:Object.class<br>
     *
     * <br>
     * ^p[^w肪ChJ[h̏ꍇAObjectԋp邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeObjectStringClassint16() throws Exception {
        // eXg{
        Class actual = GenericPropertyUtil.resolveType(
                new GenericPropertyUtil_Stub01(),
                "map3", Map.class, 0);

        // 
        assertEquals(Object.class, actual);
    }

    /**
     * testGetMethod01()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hString stringAgetter, setterȂNXB<br>
     *         () name:"string"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WFbean̊SCNX + " has no getter for property string"<br>
     *
     * <br>
     * ΉtB[h݂ȂꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMethod01() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.getMethod(
                    new GenericPropertyUtil_Stub02(), "string");
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = GenericPropertyUtil_Stub02.class.getName()
                + " has no getter for property string";
            assertEquals(message, e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testGetMethod02()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hString string1AgetterȂNXB<br>
     *         () name:"string1"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WFbean̊SCNX + " has no getter for property string1"<br>
     *
     * <br>
     * Ή郁\bh݂ȂꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMethod02() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.getMethod(
                    new GenericPropertyUtil_Stub02(), "string1");
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = GenericPropertyUtil_Stub02.class.getName()
                + " has no getter for property string1";
            assertEquals(message, e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testGetMethod03()
     * <br><br>
     *
     * inj
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() bean:tB[hString string2ƂgetterNXB<br>
     *         () name:"string2"<br>
     *
     * <br>
     * ҒlF(߂l) Method:beangetString2\bh<br>
     *
     * <br>
     * Ή郁\bhԋp邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMethod03() throws Exception {
        // eXg{
        Method actual = GenericPropertyUtil.getMethod(
                new GenericPropertyUtil_Stub02(), "string2");

        // 
        Method expected =
            GenericPropertyUtil_Stub02.class.getDeclaredMethod(
                    "getString2", new Class[0]);
        assertEquals(expected, actual);
    }

    /**
     * testGetMethod04()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hbean1AgetterȂNXB<br>
     *         () name:"bean1.string"<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Failed to detect getter for "<br>
     *                    + bean̊SCNX + "#bean1.string"<br>
     *                    bvꂽOFNoSuchMethodException<br>
     *
     * <br>
     * PropertyUtils#getPropertyDescriptorNoSuchMethodExceptionX[ꍇ̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMethod04() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.getMethod(
                    new GenericPropertyUtil_Stub02(), "bean1.string");
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = "Failed to detect getter for "
                + GenericPropertyUtil_Stub02.class.getName() + "#bean1.string";
            assertEquals(message, e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertTrue(e.getCause() instanceof NoSuchMethodException);
        }
    }

    /**
     * testGetMethod05()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hbean2ƂgetterNXB<br>
     *                (getterłRuntimeExceptionX[)<br>
     *         () name:"bean2.string"<br>
     *         () PropertyUtils#getPropertyDescriptor̎s:
     *                  InvocationTargetExceptionX[
     *                    JavaBeangetterRuntimeExceptionX[<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Failed to detect getter for "<br>
     *                    + bean̊SCNX + "#bean2.string"<br>
     *                    bvꂽOFInvocationTargetException<br>
     *
     * <br>
     * PropertyUtils#getPropertyDescriptorInvocationTargetExceptionX[ꍇ̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMethod05() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.getMethod(
                    new GenericPropertyUtil_Stub02(), "bean2.string");
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = "Failed to detect getter for "
                + GenericPropertyUtil_Stub02.class.getName() + "#bean2.string";
            assertEquals(message, e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertTrue(e.getCause() instanceof InvocationTargetException);
        }
    }

    /**
     * testGetMethod06()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:tB[hString string2ƂgetterNXB<br>
     *         () name:"string2"<br>
     *         () PropertyUtils#getPropertyDescriptor̎s:
     *                  IllegalAccessExceptionX[
     *                    PropertyUtilsBeañX^uIllegalAccessExceptionX[<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Failed to detect getter for "<br>
     *                    + bean̊SCNX + "#string2"<br>
     *                    bvꂽOFIllegalAccessException<br>
     *
     * <br>
     * PropertyUtils#getPropertyDescriptorIllegalAccessExceptionX[ꍇ̃eXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testGetMethod06() throws Exception {
        // O
        BeanUtilsBean beanUtilsBean = BeanUtilsBean.getInstance();
        UTUtil.setPrivateField(beanUtilsBean, "propertyUtilsBean",
                new GenericPropertyUtil_PropertyUtilsBeanStub01());
        try {
            
            // eXg{
            GenericPropertyUtil.getMethod(
                    new GenericPropertyUtil_Stub02(), "string2");
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = "Failed to detect getter for "
                + GenericPropertyUtil_Stub02.class.getName() + "#string2";
            assertEquals(message, e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
            assertTrue(e.getCause() instanceof IllegalAccessException);
        }
    }

    /**
     * testResolveTypeClassClassTypeint01()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:null<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'genericsClass' ("<br>
     *                    + Class.class.getName() + ") is null"<br>
     *
     * <br>
     * genericClassnull̏ꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeClassClassTypeint01() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType((Class) null, (Class) null, null, 0);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = "Argument 'genericsClass' ("
                    + Class.class.getName() + ") is null";
            assertEquals(message ,e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeClassClassTypeint02()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:List.class<br>
     *         () clazz:null<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    bZ[WFgenericClass+ " is not assignable from " + clazz<br>
     *
     * <br>
     * clazznull̏ꍇIllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeClassClassTypeint02() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(List.class, (Class) null, null, 0);
            // 
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            String message = List.class + " is not assignable from "
                + "null";
            assertEquals(message ,e.getMessage());
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeClassClassTypeint03()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:List.class<br>
     *         () clazz:Object.class<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalStateException<br>
     *                    bZ[WFgenericClass+ " is not assignable from " + clazz<br>
     *
     * <br>
     * clazzgenericClass̃TuNXł͂ȂꍇIllegalStateExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeClassClassTypeint03() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(List.class, Object.class, null, 0);
            // 
            fail("OX[܂łB");
        } catch (IllegalStateException e) {
            String message = List.class + " is not assignable from "
                + Object.class;
            assertEquals(message ,e.getMessage());
            assertEquals(IllegalStateException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeClassClassTypeint04()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:List.class<br>
     *         () clazz:ArrayListpNX(p[^Stringw)<br>
     *         () type:null<br>
     *         () index:-1<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'index'(-1) is out of bounds of"<br>
     *                    + " generics parameters")<br>
     *
     * <br>
     * index̐łꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeClassClassTypeint04() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(List.class,
                    GenericPropertyUtil_ArrayListStub01.class, null, -1);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = "Argument 'index'(-1) is out of bounds of"
                + " generics parameters";
            assertEquals(message ,e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeClassClassTypeint05()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:List.class<br>
     *         () clazz:ArrayListpNX(p[^Stringw)<br>
     *         () type:null<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(߂l) Class:String.class<br>
     *
     * <br>
     * index^p[^͈͓̔łꍇɌ^擾ł邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeClassClassTypeint05() throws Exception {
        // eXg{
        Class actual = GenericPropertyUtil.resolveType(List.class,
                GenericPropertyUtil_ArrayListStub01.class, null, 0);
        // 
        assertEquals(String.class, actual);
    }

    /**
     * testResolveTypeClassClassTypeint06()
     * <br><br>
     *
     * iُnj
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() genericClass:List.class<br>
     *         () clazz:ArrayListpNX(p[^Stringw)<br>
     *         () type:null<br>
     *         () index:1<br>
     *
     * <br>
     * ҒlF(ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF"Argument 'index'(1) is out of bounds of"<br>
     *                    + " generics parameters")<br>
     *
     * <br>
     * index^p[^͈̔͊OłꍇIllegalArgumentExceptionX[邱ƂmFeXgB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testResolveTypeClassClassTypeint06() throws Exception {
        try {
            // eXg{
            GenericPropertyUtil.resolveType(List.class,
                    GenericPropertyUtil_ArrayListStub01.class, null, 1);
            // 
            fail("OX[܂łB");
        } catch (IllegalArgumentException e) {
            String message = "Argument 'index'(1) is out of bounds of"
                + " generics parameters";
            assertEquals(message ,e.getMessage());
            assertEquals(IllegalArgumentException.class.getName(),
                    e.getClass().getName());
        }
    }

    /**
     * testResolveTypeClassClassTypeint07()
     * <br><br>
     *
     * inj
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:List.class<br>
     *         () clazz:ArrayList.class<br>
     *         () type:List.class<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(߂l) Class:Object.class<br>
     *            (ԕω) Oo:<br>
     *                    OxFTRACE
     *                    bZ[WF"Concrete type of Type(E) was not
     *                    found in ancestorList([java.util.AbstractList<E>, java.util.List<E>])"<br>
     *
     * <br>
     * ^łȂꍇObjectԋp邱ƂmFeXgB
     * ioHmF̂߂ɓʂɃg[XO`FbNj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeClassClassTypeint07() throws Exception {
        // eXg{
        Class actual = GenericPropertyUtil.resolveType(List.class,
                ArrayList.class, List.class, 0);
        // 
        assertEquals(Object.class, actual);
        assertTrue(LogUTUtil.checkTrace(
                "Concrete type of Type(E) was "
                + "not found in ancestorList([java.util.AbstractList<E>, "
                + "java.util.List<E>])"));
    }

    /**
     * testResolveTypeClassClassTypeint08()
     * <br><br>
     *
     * inj
     * <br>
     * ϓ_FE
     * <br><br>
     * ͒lF() genericClass:List.class<br>
     *         () clazz:ArrayList.class<br>
     *         () type:List<String>\ParameterizedType<br>
     *         () index:0<br>
     *
     * <br>
     * ҒlF(߂l) Class:String.class<br>
     *            (ԕω) Oo:<br>
     *                    OxFTRACE
     *                    bZ[WF"Argument 'genericClass'(java.util.List)
     *                    does not declare type parameter"<br>
     *
     * <br>
     * typeŌ^肳ꍇɁA^p[^ԋp邱ƂmFeXgB
     * ioHmF̂߂ɓʂɃg[XO`FbNj
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    @SuppressWarnings("unchecked")
    public void testResolveTypeClassClassTypeint08() throws Exception {
        //  O
        Method method = GenericPropertyUtil_Stub01.class.getMethod(
                "getList1", new Class[0]);
        Type type = method.getGenericReturnType();

        // eXg{
        Class actual = GenericPropertyUtil.resolveType(List.class,
                List.class, type, 0);
        // 
        assertEquals(String.class, actual);
        LogUTUtil.checkTrace("",
                new IllegalStateException("Argument "
                    + "'genericClass'(java.util.List) does not "
                    + "declare type parameter"));
    }
}
