/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.batch.core;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import jp.terasoluna.fw.batch.core.ResultCounter;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.openapi.ReturnCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobStatus {
    private int batchUpdateCount = 0;
    private int collected = 0;
    private int commitCount = 0;
    private long jobEndTime = 0L;
    private Integer jobExitCode = null;
    private long jobStartTime = 0L;
    private STATE jobState = STATE.SUBMITTED;
    private List<JobStatus> childJobStatusList = new ArrayList<JobStatus>();
    private boolean restartable = false;
    private int restartPoint = 0;
    private ResultCounter resultCounter = new ResultCounter();
    private String jobRequestNo = null;
    private String jobId = null;
    private int partitionNo = 0;
    private String partitionKey = null;

    public void suspend() {
        if (this.jobState == STATE.INTERRUPTED_FOR_IMMEDIATE_SHUTDOWN || this.jobState == STATE.INTERRUPTED_FOR_GRACEFUL_SHUTDOWN) {
            this.setJobState(STATE.SUSPENDING);
        }
    }

    protected void addChildJobStatus(JobStatus jobStatus) {
        this.childJobStatusList.add(jobStatus);
    }

    public void countBLogic(ReturnCode returnCode) {
        this.resultCounter.count(returnCode);
    }

    public JobStatus getChild(JobContext jobContext) {
        JobStatus childJobStatus = new JobStatus();
        this.resetChildData(childJobStatus, jobContext);
        return childJobStatus;
    }

    protected void resetChildData(JobStatus childJobStatus, JobContext jobContext) {
        childJobStatus.setJobId(this.getJobId());
        childJobStatus.setJobRequestNo(this.getJobRequestNo());
        childJobStatus.setRestartPoint(this.getRestartPoint());
        childJobStatus.setRestartable(this.isRestartable());
        childJobStatus.setJobState(this.getJobState());
        childJobStatus.setPartitionNo(jobContext.getPartitionNo());
        childJobStatus.setPartitionKey(jobContext.getPartitionKey());
        if (this.isShutdownImmediate() || this.isShutdownGraceful()) {
            childJobStatus.suspend();
        }
        this.addChildJobStatus(childJobStatus);
    }

    public int getCollected() {
        return this.collected;
    }

    public int getCommitCount() {
        int count = 0;
        if (!this.childJobStatusList.isEmpty()) {
            for (JobStatus result : this.childJobStatusList) {
                count += result.getCommitCount();
            }
        } else {
            count = this.commitCount;
        }
        return count;
    }

    public int getErrorContinueCount() {
        int count = 0;
        if (!this.childJobStatusList.isEmpty()) {
            for (JobStatus result : this.childJobStatusList) {
                count += result.getErrorContinueCount();
            }
        } else {
            count = this.resultCounter.getErrorContinueCount();
        }
        return count;
    }

    public Integer getJobExitCode() {
        return this.jobExitCode;
    }

    public int getBatchUpdateCount() {
        return this.batchUpdateCount;
    }

    public String getJobStartTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return sdf.format(new Date(this.jobStartTime));
    }

    public STATE getJobState() {
        return this.jobState;
    }

    public String getJobStateStr() {
        if (this.jobState != null) {
            return this.jobState.toString();
        }
        return null;
    }

    public List<JobStatus> getChildJobStatusList() {
        return this.childJobStatusList;
    }

    public int getNormalContinueCount() {
        int count = 0;
        if (!this.childJobStatusList.isEmpty()) {
            for (JobStatus result : this.childJobStatusList) {
                count += result.getNormalContinueCount();
            }
        } else {
            count = this.resultCounter.getNormalContinueCount();
        }
        return count;
    }

    public String getProcessingTime() {
        long now = System.currentTimeMillis();
        if (this.jobState.isEndStatus()) {
            now = this.jobEndTime;
        }
        return String.valueOf(now - this.jobStartTime) + "ms";
    }

    public int getRestartPoint() {
        return this.restartPoint + this.resultCounter.getToralCount();
    }

    public void incrementBatchUpdateCount(int batchUpdateCount) {
        this.batchUpdateCount += batchUpdateCount;
    }

    public void incrementCollected() {
        ++this.collected;
    }

    public void incrementCommitCount() {
        ++this.commitCount;
    }

    public boolean isContinue() {
        return !this.jobState.isEndStatus();
    }

    public boolean isExecuting() {
        return this.jobState == STATE.STARTED || this.jobState == STATE.RESTARTED;
    }

    public boolean isRestartable() {
        return this.restartable;
    }

    public boolean isShutdownGraceful() {
        return this.jobState == STATE.INTERRUPTED_FOR_GRACEFUL_SHUTDOWN;
    }

    public boolean isShutdownImmediate() {
        return this.jobState == STATE.INTERRUPTED_FOR_IMMEDIATE_SHUTDOWN;
    }

    public void setJobExitCode(Integer jobExitCode) {
        this.jobExitCode = jobExitCode;
    }

    public void setJobState(STATE jobState) {
        this.jobState = jobState;
        if (jobState.isEndStatus()) {
            this.jobEndTime = System.currentTimeMillis();
        }
        if (jobState == STATE.STARTED || jobState == STATE.RESTARTED) {
            this.jobStartTime = System.currentTimeMillis();
        }
    }

    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    public void setRestartPoint(int restartPoint) {
        this.restartPoint = restartPoint;
    }

    public void shutdownGraceful() {
        if (this.jobState.isEndStatus() || this.jobState == STATE.INTERRUPTED_FOR_GRACEFUL_SHUTDOWN || this.jobState == STATE.INTERRUPTED_FOR_IMMEDIATE_SHUTDOWN) {
            return;
        }
        this.setJobState(STATE.INTERRUPTED_FOR_GRACEFUL_SHUTDOWN);
        if (!this.childJobStatusList.isEmpty()) {
            for (JobStatus result : this.childJobStatusList) {
                result.shutdownGraceful();
            }
        }
    }

    public void shutdownImmediate() {
        if (this.jobState.isEndStatus() || this.jobState == STATE.INTERRUPTED_FOR_IMMEDIATE_SHUTDOWN) {
            return;
        }
        this.setJobState(STATE.INTERRUPTED_FOR_IMMEDIATE_SHUTDOWN);
        if (!this.childJobStatusList.isEmpty()) {
            for (JobStatus result : this.childJobStatusList) {
                result.shutdownImmediate();
            }
        }
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public int getPartitionNo() {
        return this.partitionNo;
    }

    public void setPartitionNo(int partitionNo) {
        this.partitionNo = partitionNo;
    }

    public String getJobRequestNo() {
        return this.jobRequestNo;
    }

    public void setJobRequestNo(String jobRequestNo) {
        this.jobRequestNo = jobRequestNo;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum STATE {
        SUBMITTED(false),
        STARTED(false),
        RESTARTED(false),
        ENDING_NORMALLY(true),
        ENDING_ABNORMALLY(true),
        INTERRUPTED_FOR_GRACEFUL_SHUTDOWN(false),
        INTERRUPTED_FOR_IMMEDIATE_SHUTDOWN(false),
        SUSPENDING(true);

        private final boolean isEndStatus;

        private STATE(boolean isEndStatus) {
            this.isEndStatus = isEndStatus;
        }

        public boolean isEndStatus() {
            return this.isEndStatus;
        }
    }
}

