/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.tutorial.web.action;

import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;
import jp.terasoluna.thin.tutorial.service.bean.UserBean;
import jp.terasoluna.thin.tutorial.service.blogic.DeleteBLogic;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.Globals;

/**
 * 폜ANVB
 *
 * 폜srWlXWbNĂсAf[^x[X̏폜B
 *
 */
public class DeleteAction extends AbstractBLogicAction<UserBean> {

    /**
     * ONXB
     */
    private Log log = LogFactory.getLog(DeleteAction.class);

    /**
     * srWlXWbNNXB
     */
    private DeleteBLogic deleteBLogic = null;

    /**
     * rWlXWbNԋpB
     *
     * @return ێrWlXWbN
     */
    public DeleteBLogic getDeleteBLogic() {
        return deleteBLogic;
    }

    /**
     * rWlXWbNݒ肷B
     *
     * @param deleteBLogic rWlXWbN
     */
    public void setDeleteBLogic(DeleteBLogic deleteBLogic) {
        this.deleteBLogic = deleteBLogic;
    }

    /**
     * rWlXWbNsAʂԋpB
     *
     * @param bean 폜Ώۂ̃[UID̒lێbean
     * @return o^ʂێBLogicResult
     * @throws Exception O
     */
    @Override
    public BLogicResult doExecuteBLogic(UserBean bean) throws Exception {

        if (log.isDebugEnabled()) {
            log.debug("doExecuteBLogic Start.");
        }

        //rWlXWbN̎sAʂ̎擾
        int i = deleteBLogic.delete(bean);

        //BLogicResult̐Aʂ̐ݒ
        BLogicResult result = new BLogicResult();
        result.setResultString("success");

        //ʌ0ȉ̏ꍇ͓o^łȂƂāA
        //G[bZ[Wݒ肷B
        if (i <= 0) {
            BLogicMessages errors = result.getErrors();
            if (errors == null) {
                errors = new BLogicMessages();
            }
            errors.add(Globals.ERROR_KEY, new BLogicMessage("error.no.delete"));
            result.setErrors(errors);
        }

        return result;
    }

}