/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.beans.jxpath;

import java.util.Locale;

import org.apache.commons.jxpath.JXPathBasicBeanInfo;
import org.apache.commons.jxpath.JXPathBeanInfo;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.PropertyPointer;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.beans.jxpath.BeanPointerEx} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Bean|C^̊gNXB<br>
 * OF
 * <p>
 * 
 * @see jp.terasoluna.fw.beans.jxpath.BeanPointerEx
 */
public class BeanPointerExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(BeanPointerExTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public BeanPointerExTest(String name) {
        super(name);
    }

    /**
     * testBeanPointerExQname01()
     * <br><br>
     * 
     * (n) 
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() name:not null<br>
     *         () bean:new Object()<br>
     *         () beanInfo:not null<br>
     *         () locale:Locale("ja")<br>
     *         () this.beanInfo:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.beanInfo:Őݒ肳ꂽlB<br>
     *         
     * <br>
     * RXgN^ĂяoeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBeanPointerExQname01() throws Exception {
        // O
    	QName qName = new QName("name");
    	Object bean = new Object();
    	JXPathBeanInfo beanInfo = new JXPathBasicBeanInfo(bean.getClass());
    	Locale locale = new Locale("ja");

        // eXg{
    	BeanPointerEx result = new BeanPointerEx(qName, bean, beanInfo, locale);

        // 
    	assertEquals(beanInfo, UTUtil.getPrivateField(result, "beanInfo"));
    }

    /**
     * testBeanPointerExNodePointer01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() parent:not null<br>
     *         () name:not null<br>
     *         () bean:new Object()<br>
     *         () beanInfo:not null<br>
     *         () this.beanInfo:null<br>
     *         
     * <br>
     * ҒlF(ԕω) this.beanInfo:Őݒ肳ꂽlB<br>
     *         
     * <br>
     * RXgN^ĂяoeXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testBeanPointerExNodePointer01() throws Exception {
        // O
    	QName qName = new QName("name");
    	Object bean = new Object();
    	JXPathBeanInfo beanInfo = new JXPathBasicBeanInfo(bean.getClass());
    	Locale locale = new Locale("ja");
    	NodePointer nodePointer = NodePointer.newNodePointer(qName, bean, locale);

        // eXg{
    	BeanPointerEx result = new BeanPointerEx(nodePointer, qName, bean, beanInfo);

        // 
    	assertEquals(beanInfo, UTUtil.getPrivateField(result, "beanInfo"));
    }

    /**
     * testGetPropertyPointer01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() this.beanInfo:not null<br>
     *         
     * <br>
     * ҒlF(߂l) PropertyPointer:new BeanPropertyPointerEx{<br>
     *                      parent=this<br>
     *                      beanInfo=ObeanInfo<br>
     *                  }<br>
     *         
     * <br>
     * vpeB|C^擾郁\bh̃eXgB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetPropertyPointer01() throws Exception {
        // O
    	QName qName = new QName("name");
    	Object bean = new Object();
    	JXPathBeanInfo beanInfo = new JXPathBasicBeanInfo(bean.getClass());
    	Locale locale = new Locale("ja");
    	BeanPointerEx beanPointer = new BeanPointerEx(qName, bean, beanInfo, locale);

        // eXg{
    	PropertyPointer result = beanPointer.getPropertyPointer();

        // 
    	assertSame(BeanPropertyPointerEx.class, result.getClass());
    	assertSame(beanPointer, result.getParent());
    	assertSame(beanInfo, UTUtil.getPrivateField(result, "beanInfo"));
    }

}
