/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.io.IOException;

import org.apache.struts.action.ActionForward;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.impl.ModuleConfigImpl;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.MockHttpServletResponse;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.actions.ForwardAction}
 * NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * JSPȂǂփtH[hANV
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.actions.ForwardAction
 */
public class ForwardActionTest extends TestCase {

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public ForwardActionTest(String name) {
        super(name);
    }

    /**
     * testDoExecute01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         
     * <br>
     * ҒlF(߂l) actionForward:null<br>
     *         (ԕω) res.sendError():ĂяomF<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")null̏ꍇAHttpServletResponse.sendError()ĂяoAnullԂƂmF
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute01() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ModuleConfigݒ
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        ForwardAction_HttpServletResponseStub01 res =
            new ForwardAction_HttpServletResponseStub01();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertNull(forward);
        assertTrue(res.isSendError);
    }

    /**
     * testDoExecute02()
     * <br><br>
     * 
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         () res.sendError():IOException<br>
     *         
     * <br>
     * ҒlF(ԕω) O:SystemExceptionF<br>
     *                    bZ[WL[F"error.forward.errorpage"<br>
     *                    bvOFIOException<br>
     *         (ԕω) O:O<br>
     *                    G[OF"Error page(404) forwarding failed."<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")nullŁAHttpServletResponse.sendError()ďoŗOꍇASystemException邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute02() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ModuleConfigݒ
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        
        // sendErrořĂяomFp
        ForwardAction_HttpServletResponseStub02 res =
            new ForwardAction_HttpServletResponseStub02();
        
        @SuppressWarnings("unused") ActionForward forward = null;

        // eXg{
        try {
            forward = action.doExecute(mapping, form, req, res);
            fail("O܂ł");
        } catch (SystemException e) {
            // 
            // IOExceptionbv
            assertEquals(e.getCause().getClass().getName(),
                    IOException.class.getName());
            // G[OmF
            assertTrue(LogUTUtil.checkError(
                    "Error page(404) forwarding failed."));
            assertEquals("error.forward.errorpage", e.getErrorCode());
        }
    }

    /**
     * testDoExecute03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         
     * <br>
     * mappingp[^̎擾ʂnot null̏ꍇAActionForwardpathw肵pathƈv邩mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute03() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = "abc";
        mapping.setParameter(path);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertEquals("abc", forward.getPath());
    }

    /**
     * testDoExecute04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")not null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:"abc"<br>
     *         
     * <br>
     * ҒlF(߂l) actionForward:ActionForward.getPath()F"abc"<br>
     *         
     * <br>
     * mappingp[^̎擾ʋymapping.findForward("success")not null̏ꍇAp[^̎擾ʂJڐƂĕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute04() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = "abc";
        mapping.setParameter(path);
        
        // ANVtH[h̐ݒ
        ActionForward af = new ActionForward();
        af.setName("success");
        af.setPath("def");
        
        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(af);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertEquals("abc", forward.getPath());
    }

    /**
     * testDoExecute05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() mapping:not null<br>
     *                [mapping.findForward("success")not null]<br>
     *         () form:not null<br>
     *         () req:not null<br>
     *         () res:not null<br>
     *         () path:null<br>
     *         
     * <br>
     * ҒlF(߂l) actionForward:mapping.findForward("success")<br>
     *         
     * <br>
     * mappingp[^̎擾ʂnullmapping.findForward("success")not null̏ꍇAmapping.findForward("success")ԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testDoExecute05() throws Exception {
        // O
        ForwardAction action = new ForwardAction();
        
        // p[^̐ݒ
        ActionMappingEx mapping = new ActionMappingEx();
        String path = null;
        mapping.setParameter(path);
        
        // ANVtH[h̐ݒ
        ActionForward af = new ActionForward();
        af.setName("success");
        af.setPath("def");

        // ModuleConfig쐬
        ModuleConfig mConfig = new ModuleConfigImpl("");
        // ԋpActionForwardw
        mConfig.addForwardConfig(af);
        // W[RtBOforwardw
        mapping.setModuleConfig(mConfig);
        
        ForwardAction_ActionFormStub01 form =
            new ForwardAction_ActionFormStub01();
        
        MockHttpServletRequest req = new MockHttpServletRequest();
        MockHttpServletResponse res = new MockHttpServletResponse();
        
        ActionForward forward = null;

        // eXg{
        forward = action.doExecute(mapping, form, req, res);

        // 
        assertEquals(af, forward);
    }

}
