/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.plugins;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import javax.servlet.ServletException;

import jp.terasoluna.fw.service.thin.AbstractBLogicMapper;
import jp.terasoluna.fw.service.thin.BLogicMapper;
import jp.terasoluna.fw.service.thin.BLogicResources;
import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.fw.util.ClassUtil;

import org.apache.commons.digester.Digester;
import org.apache.commons.digester.xmlrules.DigesterLoader;
import org.apache.commons.digester.xmlrules.XmlLoadException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.xml.sax.SAXException;

/**
 * rWlXWbNo͂̐ݒ[hvOCB
 *
 * <p>StrutsPlugIn@\gpAT[ubg
 * rWlXWbNo͂̐ݒǂݍ݁AT[ubgReLXg
 * ɕۑB<br>
 * ̋@\gpɂstruts-config.xmlɈȉ̂悤ɐݒ肷B
 * i digesterRulesAmapperClass͏ȗBj
 * ȂAresources̓J}Ńt@CAłB
 * </p>
 * <code><pre>
 * &lt;plug-in
 *   className="jp.terasoluna.fw.web.struts.plugins.BLogicIOPlugIn"&gt;
 *    &lt;set-property
 *        property="resources"
 *        value="/WEB-INF/blogic-io.xml"/&gt;
 *    &lt;set-property
 *        property="digesterRules"
 *        value="/WEB-INF/blogic-io-rules.xml"/&gt;
 *    &lt;set-property
 *        property="mapperClass"
 *        value="jp.terasoluna.fw.service.thin.BLogicMapper"/&gt;
 * &lt;/plug-in&gt;
 * </pre></code>
 * <p>rWlXWbNo͏񔽉fNXgNXɕύXꍇ́A
 * mapperClassvalueAbstractBLogicMapper̃TuNXA
 * ܂BLogicMapperpBLogicMappergNXݒ肷B</p>
 *
 * blogic-io.xmlɂ̓ANVƂɃrWlXWbN
 * ̓o͏ݒ肷B<br>
 * Lblogic-io.xml̐ݒłB
 * <code><pre>
 * &lt;blogic-io&gt;
 *   &lt;action path="/logon/logonAction"&gt;
 *     &lt;blogic-param bean-name="jp.terasoluna.sample.blogic.LogonBean"&gt;
 *       &lt;set-property property="userName"
 *                        blogic-property="userName"
 *                        source="form" /&gt;
 *       &lt;set-property property="sessionId"
 *                        blogic-property="id"
 *                        source="session" /&gt;
 *     &lt;/blogic-param&gt;
 *     &lt;blogic-result&gt;
 *       &lt;set-property property="resultStr"
 *                        blogic-property="result"
 *                        dest="form" /&gt;
 *       &lt;set-property property="USER_VALUE_OBJECT"
 *                        blogic-property="uvo"
 *                        dest="session" /&gt;
 *     &lt;/blogic-result&gt;
 *   &lt;/action&gt;
 *   EEE
 * &lt;/blogic-io&gt;
 * </pre></code>
 * <p>
 * rWlXWbN̓͒l&lt;blogic-param&gt;
 * vfŐݒ肷Bbean-nameɂ͓͒li[
 * JavaBeañNXw肷BJavaBeańAq
 * blogic-propertyɎw肳vpeBĂȂ΂ȂȂB<br>
 * AA͒l݂ȂrWlXWbN̏ꍇ́Abean-nameȗ
 * 邱ƂŁAnull̃rWlXWbNs\łB<br>
 * ͒ľƂȂf[^̓ANVtH[ZbVȂǂWebw
 * ݒ肳ĂłAǂf[^擾邩
 * &lt;set-property&gt;vfsourceɎw肳ꂽŎʂB
 * ftHgł́Aform,session̂ǂ炩sourceɋLq邱Ƃ
 * 񌳂ANVtH[ZbVʂB<br>
 * ͌̃f[^̃vpeBpropertyŎw肷B
 * Ȃ킿A<br>
 * property="field1" source="form"Ɛݒ肵ꍇ́A
 * actionForm.get("field1")sA
 * property="field2" source="session"Ɛݒ肵ꍇ́A
 * session.getAttribute("field2")sB<br>
 * Ľʎ擾ꂽĺAOqbean-nameŎw肳ꂽ
 * JavaBeanCX^X̃vpeBlƂărWlXWbN擾łB
 * JavaBeanl擾ꍇ́Ablogic-propertyŎw肵l
 * vpeBƂȂBblogic-propertyw肳ȂꍇA
 * propertyƓlJavaBeañvpeBƂB
 * </p>
 * <p>
 * <code><pre>
 *  &lt;set-property property="field1" blogic-property="blogicField1"
 *                   source="form" /&gt;
 * </pre></code>
 * Ɛݒ肵ArWlXWbNANVtH[field1
 * ̒l擾ꍇA
 * bean.getBlogicField1()
 * s邱ƂŃANVtH[̒l擾łB<br>
 * ͌̃f[^ZbV̒lłlłA
 * <code><pre>
 *  &lt;set-property property="field2" blogic-property="blogicField2"
 *                   source="session" /&gt;
 * </pre></code>
 * Ɛݒ肵ArWlXWbNfield2ƂL[ŃZbVɊi[
 * Ăl擾ꍇA
 * bean.getBlogicField2()
 * sΗǂB
 * ܂ArWlXWbN̓f[^̓͌ANVtH[
 * ł̂AZbVł̂ӎKv͂ȂB<br>
 * ̐ݒBLogicResources̃CX^X
 * ǂݍ܂AT[ubgReLXgɕۑB</p>
 * <br>
 * <p>
 * JʎqADTDURLύXꍇ́A<br>
 * getPublicIdentifier()getDtdUrl()I[o[Ch邱ƁB
 * </p>
 *
 * @see jp.terasoluna.fw.web.struts.actions.BLogicAction
 * @see jp.terasoluna.fw.service.thin.BLogic
 * @see jp.terasoluna.fw.service.thin.BLogicResources
 * @see jp.terasoluna.fw.service.thin.BLogicResult
 * @see jp.terasoluna.fw.service.thin.AbstractBLogicMapper
 * @see jp.terasoluna.fw.service.thin.BLogicMapper
 *
 */
public class BLogicIOPlugIn implements PlugIn {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(BLogicIOPlugIn.class);

    /**
     * T[ubgReLXgɓo^BLogicMapper
     * vtBbNXL[B
     */
    public static final String BLOGIC_MAPPER_KEY = "BLOGIC_MAPPER";

    /**
     * ftHgblogic-io-rules.xml ̃pXB
     */
    private static final String DIGESTER_RULES_PATH =
        "/WEB-INF/blogic-io-rules.xml";

    /**
     * DTĎJʎqB
     */
    private String publicIdentifier =
        "-//NTTDATA//DTD TERASOLUNA for Spring blogic-io 1.0//JA";

    /**
     * DTDpXB
     */
    private String dtdUrl =
        "/jp/terasoluna/fw/web/struts/plugins/dtd/blogic-io.dtd";

    /**
     * ̃vOC𐶐T[ubgB
     */
    private ActionServlet servlet = null;

    /**
     * rWlXWbNo͏񃋁[`t@C
     * iblogic-io-rules.xmljB
     */
    private String digesterRules = null;

    /**
     * rWlXWbNo͏`t@Ciblogic-io.xmljB
     */
    private String resources = null;

    /**
     * BLogicMapperw肵NXt@CB
     * wȂ̏ꍇAftHg̃NXgpB
     */
    private String mapperStr = null;

    /**
     * rWlXWbNo͏ێCX^XB
     */
    private BLogicResources blogicResources = null;

    /**
     * rWlXWbNo͏}bp[B
     */
    private AbstractBLogicMapper blogicMapper = null;

    /**
     * DigesterCX^XB
     */
    private static Digester digester = null;

    /**
     * IB
     */
    public void destroy() {
        // Ȃ

    }

    /**
     * PlugIn̏B
     *
     * <p>BLogicResourcesAy BLogicMapper
     * T[ubgReLXgɓo^B</p>
     *
     * <p>
     *  ̃vOCNT[ubgAW[RtBO
     *  nullłƂA NullPointerException
     *  
     * </p>
     *
     * @param servlet ̃vOCNT[ubg
     * @param config W[RtBO
     * @exception ServletException O
     */
    public void init(ActionServlet servlet, ModuleConfig config)
        throws ServletException {

        this.servlet = servlet;
        String moduleName = config.getPrefix();

        // BLogicResourcesT[ubgReLXgɓo^
        initResources();
        servlet.getServletContext().setAttribute(
            BLogicResources.BLOGIC_RESOURCES_KEY + moduleName, blogicResources);

        // BLogicMapperT[ubgReLXgɓo^
        initMapper();
        servlet.getServletContext().setAttribute(BLOGIC_MAPPER_KEY + moduleName,
            this.blogicMapper);
    }

    /**
     * rWlXWbNo͏񏉊B
     *
     * <p>blogic-io.xmlAblogic-io-rules.xml
     * 𗘗pāAݒBeanɓǂݍށB</p>
     *
     * <p>XMLݒt@Č`sAIOOA
     * ServletExceptionɃbvX[B</p>
     *
     * @exception ServletException rWlXWbNo͏񏉊
     * O
     */
    private void initResources() throws ServletException {
        if (resources == null || "".equals(resources)) {
            if (log.isDebugEnabled()) {
                log.debug("resources file location is not specified");
            }
            return;
        }
        StringTokenizer st = new StringTokenizer(resources, ",");
        List<String> pathList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            path = path.trim();
            if (log.isDebugEnabled()) {
                log.debug("blogic io file=" + path);
            }
            pathList.add(path);
        }
        try {
            if (digester == null) {
                if (digesterRules == null) {
                    // [t@Cݒ̎AftHg̃[t@C
                    // gpB
                    digesterRules = DIGESTER_RULES_PATH;
                }
                digester = DigesterLoader.createDigester(
                    servlet.getServletContext().getResource(digesterRules));
                digester.setValidating(true);
            }
            blogicResources = new BLogicResources();
            for (int i = 0; i < pathList.size(); i++) {
                digester.push(blogicResources);
                URL url = this.getClass().getResource(getDtdUrl());
                if (url != null) {
                    digester.register(getPublicIdentifier(), url.toString());
                }
                digester.parse(
                    servlet.getServletContext().getResourceAsStream(
                    pathList.get(i)));
            }
        } catch (MalformedURLException e) {
            log.error("", e);
            throw new ServletException(e);
        } catch (IOException e) {
            log.error("", e);
            throw new ServletException(e);
        } catch (SAXException e) {
            log.error("", e);
            throw new ServletException(e);
        } catch (XmlLoadException e) {
            log.error("", e);
            throw new ServletException(e);
        }

    }

    /**
     * JʎqԋpB
     * JʎqύXꍇ́Ã\bhI[o[ChB
     * @return Jʎq
     */
    public String getPublicIdentifier() {
        return publicIdentifier;
    }

    /**
     * DTDURLԋpB
     * DTDURLύXꍇ́Ã\bhI[o[ChB
     * @return DTDURL
     */
    public String getDtdUrl(){
        return dtdUrl;
    }

    /**
     * }bp[o^B
     *
     * <p>BLogicMapper[hAݒ
     * CX^XtB[hɓo^B</p>
     *
     * <p>CX^XɕێĂ BLogicMapper
     * ̃NX[hɎsA ServletException
     * X[B</p>
     *
     * @throws ServletException T[ubgO
     */
    private void initMapper() throws ServletException {
        Object[] args = {resources};
        if (this.mapperStr != null) {
            try {
                this.blogicMapper =
                    (AbstractBLogicMapper) ClassUtil.create(
                            this.mapperStr, args);
            } catch (ClassLoadException e) {
                log.error("", e);
                throw new ServletException(e);
            } catch (ClassCastException e) {
                log.error("", e);
                throw new ServletException(e);
            }
        } else {
            this.blogicMapper = new BLogicMapper(resources);
        }
    }

    /**
     * blogic-io-rules.xmlݒ肷B
     *
     * @param digesterRules blogic-io-rules.xml
     */
    public void setDigesterRules(String digesterRules) {
        this.digesterRules = digesterRules;
    }

    /**
     * blogic-io.xmlݒ肷B
     *
     * @param resources blogic-io.xml
     */
    public void setResources(String resources) {
        this.resources = resources;
    }

    /**
     * rWlXWbNo͏񔽉fNXݒ肷B
     *
     * @param mapperStr rWlXWbNo͏񔽉fNX
     */
    public void setMapperClass(String mapperStr) {
        this.mapperStr = mapperStr;
    }

    /**
     * Jʎqݒ肷B
     * @param publicIdentifier Jʎq
     */
    public void setPublicIdentifier(String publicIdentifier) {
        this.publicIdentifier = publicIdentifier;
    }

    /**
     * DTDURLݒ肷B
     * @param dtdUrl DTDURL
     */
    public void setDtdUrl(String dtdUrl) {
        this.dtdUrl = dtdUrl;
    }

}
