/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.thin.functionsample.dispatch.action;

import java.util.HashMap;
import java.util.Map;

import jp.terasoluna.thin.functionsample.dispatch.bean.UserVO;
import jp.terasoluna.thin.functionsample.dispatch.service.ListUserService;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.actions.AbstractBLogicAction;

/**
 * [UXg擾ANV
 *
 */
public class ListUserAction extends AbstractBLogicAction {
    
    /**
     * [UXg擾T[rX
     */
    protected ListUserService listUserService = null;
    
    /**
     * f[^x[X烆[UXg擾B
     *
     * @param param Object
     * @return BLogicResult
     * @throws Exception \ʗO
     */
    @Override
    public BLogicResult doExecuteBLogic(Object param) throws Exception {
        
        //ʂi[邽߂̃IuWFNg
    	BLogicResult result = new BLogicResult();
        Map<String, Object> map = new HashMap<String, Object>();
        
        //[UXg擾
        UserVO[] userList = listUserService.getListUser();
        
        //ʂ̐ݒ
        map.put("userList", userList);

        result.setResultObject(map);
        result.setResultString("success");
        
        return result;
    }

    /**
     * [UXg擾T[rX擾B
     * @return [UXg擾T[rX
     */
    public ListUserService getListUserService() {
        return listUserService;
    }

    /**
     * [UXg擾T[rXݒ肷B
     * @param listUserService [UXg擾T[rX
     */
    public void setListUserService(ListUserService listUserService) {
        this.listUserService = listUserService;
    }   
}