/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.taglib;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;

import org.apache.struts.Globals;

/**
 * <p>
 *  <code>ifErrors</code>^O̎NXB
 * </p>
 * <p>
 *  ̓`FbNG[ꍇA邢͏o̓p[^ɃG[
 *  ݒ肳ĂꍇɁA^Õ{fBo͂B
 * </p>
 * <p>
 *  <code>Struts</code> ̕WIȏ@ł́AG[ꍇɂ
 *  NGXgɃG[񃊃Xgݒ肳B {@link IfErrorsTag}
 *  ł́ANGXg`FbNG[񃊃Xgݒ肳ĂꍇɁA
 *  {fBo͂B
 *  NGXgɃG[񃊃Xgݒ肳ĂȂꍇɂ́APɖB
 * </p>
 * <p>
 *  {@link IfErrorsTag} Ƃ͋tɁAG[ȂꍇɃ{fB
 *  o͂ꍇɂ́A{@link IfNotErrorsTag} p邱ƁB
 * </p>
 *
 * <br>
 *
 * <h5>^OT|[g鑮</h5>
 * <p>̃^OɂĐݒ肳鑮͂܂B</p>
 *
 * <br>
 *
 * <h5>JX^^ÕXNveBOϐ</h5>
 * <p>̃^OɂĐݒ肳XNveBOϐ͂܂B</p>
 *
 * <br>
 *
 * <h5>gp@</h5>
 * <p><code><pre>
 * &lt;ts:ifErrors &gt;
 *   ... // G[ꍇ̕\ړ
 * &lt;/ts:ifErrors&gt;
 * </pre></code></p>
 *
 */
public class IfErrorsTag extends TagSupport {

    /**
     * VAo[WID
     */
    private static final long serialVersionUID = -936805750667584148L;

    /**
     * ^O]JnɌĂ΂郁\bhBNGXgɃG[񃊃Xg
     * ݒ肳ĂƂɂ̓{fBo͂Aݒ肳ĂȂƂɂ
     * {fBXLbvB
     *
     * @return w
     * @throws JspException JSPO
     */
    @Override
    public int doStartTag() throws JspException {

        HttpServletRequest req
            = (HttpServletRequest) pageContext.getRequest();
        HttpSession session = req.getSession(true);

        if (req.getAttribute(Globals.ERROR_KEY) != null) {
            // NGXgɃG[񂪊܂܂Ƃ̓{fB]
            return EVAL_BODY_INCLUDE;
        } else if (session.getAttribute(Globals.ERROR_KEY) != null) {
            // ZbVɃG[񂪊܂܂Ƃ̓{fB]
            return EVAL_BODY_INCLUDE;
        } else {
            // G[񂪊܂܂ȂƂ̓{fB]XLbv
            return SKIP_BODY;
        }
    }

    /**
     * ^O]IɌĂ΂郁\bhB
     *
     * @return w
     * @throws JspException JSPO
     */
    @Override
    public int doEndTag() throws JspException {
        return EVAL_PAGE;
    }

}
