/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.web.thin;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import jp.terasoluna.fw.web.RequestUtil;
import jp.terasoluna.fw.web.thin.AbstractControlFilter;
import jp.terasoluna.fw.web.thin.ServerBlockageController;
import jp.terasoluna.fw.web.thin.ServerBlockageException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerBlockageControlFilter
extends AbstractControlFilter<ServerBlockageController> {
    public static final String SERVER_BLOCKAGE_THRU_KEY = "SERVER_BLOCKAGE_THRU_KEY";
    public static final String DEFAULT_SERVER_BLOCKAGE_BEAN_ID = "serverBlockageController";
    private static final String SERVER_BLOCKAGE_CONTROLLER_ERROR = "errors.server.blockage.controller";
    private static final Class SERVER_BLOCKAGE_CONTROLLER_CLASS = ServerBlockageController.class;
    private static Log log = LogFactory.getLog(ServerBlockageControlFilter.class);
    protected static ServerBlockageController controller = null;

    public static ServerBlockageController getServerBlockageController() {
        return controller;
    }

    @Override
    public void init(FilterConfig config) throws ServletException {
        super.init(config);
        if (controller == null) {
            controller = (ServerBlockageController)this.getController();
        }
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(SERVER_BLOCKAGE_THRU_KEY) == null) {
            req.setAttribute(SERVER_BLOCKAGE_THRU_KEY, (Object)"true");
            if (controller.isBlockaded(RequestUtil.getPathInfo(req))) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"isBlockaded() failed.");
                }
                throw new ServerBlockageException();
            }
        }
        chain.doFilter(req, res);
    }

    @Override
    protected Class getControllerClass() {
        return SERVER_BLOCKAGE_CONTROLLER_CLASS;
    }

    @Override
    protected String getErrorCode() {
        return SERVER_BLOCKAGE_CONTROLLER_ERROR;
    }

    @Override
    public String getDefaultControllerBeanId() {
        return DEFAULT_SERVER_BLOCKAGE_BEAN_ID;
    }
}

