/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.mail.MailException;

public class MailSendException
extends MailException {
    private Map failedMessages = new HashMap();

    public MailSendException(String msg) {
        super(msg);
    }

    public MailSendException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public MailSendException(Map failedMessages) {
        super((String)null);
        this.failedMessages.putAll(failedMessages);
    }

    public final Map getFailedMessages() {
        return this.failedMessages;
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        String superMsg = super.getMessage();
        sb.append(superMsg != null ? superMsg : "Failed messages: ");
        Iterator subExs = this.getFailedMessages().values().iterator();
        while (subExs.hasNext()) {
            Throwable subEx = (Throwable)subExs.next();
            sb.append(subEx.toString());
            if (!subExs.hasNext()) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append("; nested exceptions (");
        sb.append(this.getFailedMessages().size()).append(") are:");
        int i = 0;
        Iterator subExs = this.getFailedMessages().values().iterator();
        while (subExs.hasNext()) {
            Throwable subEx = (Throwable)subExs.next();
            sb.append('\n').append("Failed message ").append(++i).append(": ");
            sb.append(subEx);
        }
        return sb.toString();
    }

    public void printStackTrace(PrintStream ps) {
        if (this.getFailedMessages().isEmpty()) {
            super.printStackTrace(ps);
        } else {
            ps.println(this.getClass().getName() + "; nested exception details (" + this.getFailedMessages().size() + ") are:");
            int i = 0;
            Iterator subExs = this.getFailedMessages().values().iterator();
            while (subExs.hasNext()) {
                Throwable subEx = (Throwable)subExs.next();
                ps.println("Failed message " + ++i + ":");
                subEx.printStackTrace(ps);
            }
        }
    }

    public void printStackTrace(PrintWriter pw) {
        if (this.getFailedMessages().isEmpty()) {
            super.printStackTrace(pw);
        } else {
            pw.println(this.getClass().getName() + "; nested exception details (" + this.getFailedMessages().size() + ") are:");
            int i = 0;
            Iterator subExs = this.getFailedMessages().values().iterator();
            while (subExs.hasNext()) {
                Throwable subEx = (Throwable)subExs.next();
                pw.println("Failed message " + ++i + ":");
                subEx.printStackTrace(pw);
            }
        }
    }
}

