/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.form;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import jp.terasoluna.fw.util.ClassLoadException;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.MockHttpServletRequest;
import jp.terasoluna.utlib.PropertyTestCase;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.Validator;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorResources;
import org.apache.commons.validator.Var;
import org.apache.struts.Globals;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

/**
 * {@link jp.terasoluna.fw.web.struts.form.FieldChecksEx}
 * NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * Validatorǉ[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.web.struts.form.FieldChecksEx
 */
public class FieldChecksExTest08 extends PropertyTestCase {

    /**
     * validateMultiField̈ɎgpBeanB
     */
    FieldChecksEx_BeanStub01 javaBean = new FieldChecksEx_BeanStub01();

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksExTest08.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        LogUTUtil.flush();
        deleteProperty("validation.hankaku.kana.list");
        deleteProperty("validation.zenkaku.kana.list");
        FieldChecksEx_MultiFieldValidatorImpl01.value = null;
        FieldChecksEx_MultiFieldValidatorImpl01.fields = null;
        FieldChecksEx_MultiFieldValidatorImpl01.validateCalledCount = 0;
        FieldChecksEx_MultiFieldValidatorImpl01.result = false;
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksExTest08(String name) {
        super(name);
        this.javaBean.setField1("abc");
        this.javaBean.setField2("def");
        this.javaBean.setField3("ghi");
        this.javaBean.setField4("jkl");
    }

    /**
     * testValidateByteRange01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:maxByte=null<br>
     *                var:minByte=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxF<br>
     *                    G[<br>
     *                    bZ[WF<br>
     *                    bean is null.<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beannull̂ƂAG[Oo͂trueԋp邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("maxByte");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[OmF
        assertTrue(LogUTUtil.checkError("bean is null."));
    }

    /**
     * testValidateByteRange02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:maxByte="1"<br>
     *                var:minByte="4"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * bean󕶎̂ƂAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange02() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("maxByte");
        var.setValue("1");
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue("4");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateByteRange03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:minByte="1"<br>
     *                var:maxByte="5"<br>
     *                encoding="UTF-8"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beañoCgfieldminByteAmaxByte͈̔͂ɂƂA
     * trueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("maxByte");
        var.setValue("5");
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue("1");
        field.addVar(var);
        var = new Var();
        var.setName("encoding");
        var.setValue("UTF-8");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateByteRange04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:minByte="4"<br>
     *                var:maxByte="8"<br>
     *                encoding="Windows-31J"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * beañoCgfieldminByteAmaxByte͈̔͊ÔƂA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("maxByte");
        var.setValue("8");
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue("4");
        field.addVar(var);
        var = new Var();
        var.setName("encoding");
        var.setValue("Windows-31J");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[2ł邱ƁB
        assertEquals(2, errors.size());

        // bZ[WIuWFNǧ
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage message = (ActionMessage) it.next();
            list.add(message.getKey());
        }
        assertTrue(list.contains("testMessage"));
        assertTrue(list.contains("message"));
    }

    /**
     * testValidateByteRange05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:minByte="4"<br>
     *                var:maxByte="8"<br>
     *                encoding="UTF-8"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * beañoCgfieldminByteAmaxByte͈̔͊ÔƂA
     * G[bZ[WǉAfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange05() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("maxByte");
        var.setValue("8");
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue("4");
        field.addVar(var);
        var = new Var();
        var.setName("encoding");
        var.setValue("UTF-8");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[2ł邱ƁB
        assertEquals(2, errors.size());

        // bZ[WIuWFNǧ
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage message = (ActionMessage) it.next();
            list.add(message.getKey());
        }
        assertTrue(list.contains("testMessage"));
        assertTrue(list.contains("message"));
    }

    /**
     * testValidateByteRange06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:minByte=null<br>
     *                var:maxByte=null<br>
     *                encoding=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF""<br>
     *                    OFNumberFormatException<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldminByteAmaxBytenull̂ƂAꂼA0AInteger.MAX_VALUE
     * ƂČvZs邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange06() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("maxByte");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue(null);
        field.addVar(var);
        var = new Var();
        var.setName("encoding");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("", new NumberFormatException()));
    }

    /**
     * testValidateByteRange07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:"aaaaaa"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:minByte=""<br>
     *                var:maxByte=""<br>
     *                encoding=""<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF""<br>
     *                    OFNumberFormatException<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldminByteAmaxByte󕶎̂ƂAꂼA0AInteger.MAX_VALUE
     * ƂČvZs邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange07() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "aaaaaa";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("maxByte");
        var.setValue("");
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue("");
        field.addVar(var);
        var = new Var();
        var.setName("encoding");
        var.setValue("");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("", new NumberFormatException()));
    }

    /**
     * testValidateByteRange08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:minByte="abc"<br>
     *                var:maxByte="def"<br>
     *                encoding="test-encoding"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF""<br>
     *                    OFNumberFormatException<br>
     *                    OxFx<br>
     *                    bZ[WF<br>
     *                    "test-encoding is not supported."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldminByteAmaxBytelɕϊłȂƂAꂼA0A
     * Integer.MAX_VALUEƂČvZs邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange08() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("maxByte");
        var.setValue("abc");
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue("def");
        field.addVar(var);
        var = new Var();
        var.setName("encoding");
        var.setValue("test-encoding");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[O`FbN
        assertTrue(LogUTUtil.checkError("", new NumberFormatException()));

        // xO`FbN
        assertTrue(LogUTUtil.checkWarn("test-encoding is not supported."));
    }

    /**
     * testValidateByteRange09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:minByte="8"<br>
     *                var:maxByte="4"<br>
     *                encoding="UTF-8"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * fieldminByte̒lAmaxByte̒lƂAfalseԋp邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange09() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("maxByte");
        var.setValue("4");
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue("8");
        field.addVar(var);
        var = new Var();
        var.setName("encoding");
        var.setValue("UTF-8");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // G[IuWFNg̃`FbN
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateByteRange10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:String:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:minByte="4"<br>
     *                var:maxByte="4"<br>
     *                encoding="Windows-31J"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldminBytemaxByte̒lvAbeaň̒lƈv
     * ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange10() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("maxByte");
        var.setValue("4");
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue("4");
        field.addVar(var);
        var = new Var();
        var.setName("encoding");
        var.setValue("Windows-31J");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateByteRange11()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"=""]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:minByte="1"<br>
     *                var:maxByte="10"<br>
     *                var:encoding="UTF-8"<br>
     *                Msg("message","message")<br>
     *                property="field1"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeB
     * ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange11() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "");
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        Var var = new Var();
        var.setName("maxByte");
        var.setValue("10");
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue("1");
        field.addVar(var);
        var = new Var();
        var.setName("encoding");
        var.setValue("UTF-8");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateByteRange12()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="1234"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:minByte="1"<br>
     *                var:maxByte="3"<br>
     *                var:encoding="Windows-31J"<br>
     *                Msg("message","message")<br>
     *                property="field1"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:ActionMessage("message")<br>
     *
     * <br>
     * beanString^ł͂ȂꍇAfield擾ÕvpeB
     * ΂ă`FbNsƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange12() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "1234");
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field1");
        Var var = new Var();
        var.setName("maxByte");
        var.setValue("3");
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue("1");
        field.addVar(var);
        var = new Var();
        var.setName("encoding");
        var.setValue("Windows-31J");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // falseԋpĂ邱ƁB
        assertFalse(result);
        // G[1ł邱ƁB
        assertEquals(1, errors.size());

        // G[IuWFNg̃`FbN
        Iterator it = errors.get();
        ActionMessage message = (ActionMessage) it.next();
        assertEquals("message", message.getKey());
    }

    /**
     * testValidateByteRange13()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Map:["field1"="123"]<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:minByte="1"<br>
     *                var:maxByte="10"<br>
     *                var:encoding="UTF-8"<br>
     *                Msg("message","message")<br>
     *                property="field2"<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beanString^ł͂ȂAfield擾ÕvpeB
     * ݂ȂꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateByteRange13() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        Map<String, String> bean = new HashMap<String, String>();
        bean.put("field1", "123");
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        field.setProperty("field2");
        Var var = new Var();
        var.setName("maxByte");
        var.setValue("10");
        field.addVar(var);
        var = new Var();
        var.setName("minByte");
        var.setValue("1");
        field.addVar(var);
        var = new Var();
        var.setName("encoding");
        var.setValue("UTF-8");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateByteRange(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());
    }

    /**
     * testValidateMultiField01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) MultiFieldValidator:ĂяoȂ<br>
     *         (ԕω) O:OxF<br>
     *                    G[<br>
     *                    bZ[WF<br>
     *                    bean is null.<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * beannull̂ƂAG[Oo͂trueԋp邱Ƃ
     * mFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField01() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = null;
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        boolean result =
            FieldChecksEx.validateMultiField(
                bean,
                va,
                field,
                errors,
                validator,
                request);
        // eXgʊmF
        // trueԋpĂ邱ƁB
        assertTrue(result);
        // G[񂪋ł邱ƁB
        assertTrue(errors.isEmpty());

        // G[OmF
        assertTrue(LogUTUtil.checkError("bean is null."));
    }

//    /**
//     * testValidateMultiField02()
//     * <br><br>
//     *
//     * (n)
//     * <br>
//     * ϓ_FC,F
//     * <br><br>
//     * ͒lF() bean:""<br>
//     *         () va:not null<br>
//     *         () field:not null<br>
//     *                Msg("message","message")<br>
//     *         () errors:not null<br>
//     *                (̗vf)<br>
//     *         () validator:not null<br>
//     *         () request:not null<br>
//     *
//     * <br>
//     * ҒlF(߂l) boolean:true<br>
//     *         (ԕω) MultiFieldValidator:ĂяoȂ<br>
//     *         (ԕω) errors:not null<br>
//     *                    (̗vf)<br>
//     *
//     * <br>
//     * bean󕶎̂ƂAtrueԋp邱ƂmFB
//     * <br>
//     *
//     * @throws Exception ̃\bhŔO
//     */
//    public void testValidateMultiField02() throws Exception {
//        // eXgP[X폜
//    }

    /**
     * testValidateMultiField03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FC,F
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:multiFieldValidator=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(ԕω) MultiFieldValidator:ĂяoȂ<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF<br>
     *                    "var value[multiFieldValidator] is required."<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "var value[multiFieldValidator] is required."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * bean󕶎̂ƂA`FbNs邱ƁB<br>
     * fieldmultiFieldValidatornull̂ƂAIllegalArgumentException
     * 邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField03() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("multiFieldValidator");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        try {
            FieldChecksEx.validateMultiField(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
            fail();
        } catch (IllegalArgumentException e) {
            assertTrue(errors.isEmpty());
            assertEquals("var value[multiFieldValidator] is required.",
                    e.getMessage());
            assertTrue(LogUTUtil.checkError(
                    "var value[multiFieldValidator] is required."));
        }
    }

    /**
     * testValidateMultiField04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"abc"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:multiFieldValidator=""<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(ԕω) MultiFieldValidator:ĂяoȂ<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF<br>
     *                    "var value[multiFieldValidator] is required."<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "var value[multiFieldValidator] is required."<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldmultiFieldValidator󕶎̂ƂA
     * IllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField04() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("multiFieldValidator");
        var.setValue("");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        try {
            FieldChecksEx.validateMultiField(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
            fail();
        } catch (IllegalArgumentException e) {
            assertTrue(errors.isEmpty());
            assertEquals("var value[multiFieldValidator] is required.",
                    e.getMessage());
            assertTrue(LogUTUtil.checkError(
                    "var value[multiFieldValidator] is required."));
        }
    }

    /**
     * testValidateMultiField05()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"abc"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:multiFieldValidator="abc"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(ԕω) MultiFieldValidator:ĂяoȂ<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF<br>
     *                    "var value[multiFieldValidator] is invalid."<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "var value[multiFieldValidator] is invalid."<br>
     *                    OF<br>
     *                    ClassLoadException(ClassNotFoundException)
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldmultiFieldValidatorNXpXɑ݂ȂNX̂ƂA
     * IllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField05() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("multiFieldValidator");
        var.setValue("abc");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        try {
            FieldChecksEx.validateMultiField(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
            fail();
        } catch (IllegalArgumentException e) {
            assertTrue(errors.isEmpty());
            assertEquals("var value[multiFieldValidator] is invalid.",
                    e.getMessage());
            assertTrue(LogUTUtil.checkError(
                    "var value[multiFieldValidator] is invalid.",
                    new ClassLoadException(new ClassNotFoundException())));
        }
    }

    /**
     * testValidateMultiField06()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FF,G
     * <br><br>
     * ͒lF() bean:"abc"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:multiFieldValidator="java.lang.String"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *
     * <br>
     * ҒlF(ԕω) MultiFieldValidator:ĂяoȂ<br>
     *         (ԕω) O:IllegalArgumentException<br>
     *                    bZ[WF<br>
     *                    "var value[multiFieldValidator] is invalid."<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF<br>
     *                    "var value[multiFieldValidator] is invalid."<br>
     *                    OF<br>
     *                    ClassCastException<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldmultiFieldValidatorMultiFieldValidatorĂȂNX
     * ƂAIllegalArgumentException邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField06() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("multiFieldValidator");
        var.setValue("java.lang.String");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // eXgs
        try {
            FieldChecksEx.validateMultiField(
                    bean,
                    va,
                    field,
                    errors,
                    validator,
                    request);
            fail();
        } catch (IllegalArgumentException e) {
            assertTrue(errors.isEmpty());
            assertEquals("var value[multiFieldValidator] is invalid.",
                    e.getMessage());
            assertTrue(LogUTUtil.checkError(
                    "var value[multiFieldValidator] is invalid.",
                    new ClassCastException()));
        }
    }

    /**
     * testValidateMultiField07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"abc"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:multiFieldValidator=<br>
     *                "jp.terasoluna.fw.web.struts.form.FieldChecksEx_MultiFieldValidatorImpl01"<br>
     *                var:fields=null<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () MultiFieldValidator.validate():true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) MultiFieldValidator:"abc",vf0̔zŌĂяo邱ƁB<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldfieldsnull̏ꍇAMultiFieldValidatoȓɋ̔z
     * n邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField07() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("multiFieldValidator");
        var.setValue("jp.terasoluna.fw.web.struts.form." +
                "FieldChecksEx_MultiFieldValidatorImpl01");
        field.addVar(var);
        var = new Var();
        var.setName("fields");
        var.setValue(null);
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // MultiFieldValidator̖߂lݒ
        FieldChecksEx_MultiFieldValidatorImpl01.result = true;

        // eXgs
        boolean result = FieldChecksEx.validateMultiField(
                bean,
                va,
                field,
                errors,
                validator,
                request);

        // ʊmF
        assertTrue(result);
        assertTrue(errors.isEmpty());

        // MultiFieldValidatořĂяoAmF
        assertEquals(1,
                FieldChecksEx_MultiFieldValidatorImpl01.validateCalledCount);
        assertEquals("abc", FieldChecksEx_MultiFieldValidatorImpl01.value);
        assertEquals(0, FieldChecksEx_MultiFieldValidatorImpl01.fields.length);

    }

    /**
     * testValidateMultiField08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:"abc"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:multiFieldValidator=<br>
     *                "jp.terasoluna.fw.web.struts.form.FieldChecksEx_MultiFieldValidatorImpl01"<br>
     *                var:fields=""<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () MultiFieldValidator.validate():true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) MultiFieldValidator:"abc",vf0̔zŌĂяo邱ƁB<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldfieldsnull̏ꍇAMultiFieldValidatoȓɋ̔z
     * n邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField08() throws Exception {
        //eXgf[^ݒ
        // ++++ beanIuWFNg ++++
        String bean = "abc";
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("multiFieldValidator");
        var.setValue("jp.terasoluna.fw.web.struts.form." +
                "FieldChecksEx_MultiFieldValidatorImpl01");
        field.addVar(var);
        var = new Var();
        var.setName("fields");
        var.setValue("");
        field.addVar(var);
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // MultiFieldValidator̖߂lݒ
        FieldChecksEx_MultiFieldValidatorImpl01.result = true;

        // eXgs
        boolean result = FieldChecksEx.validateMultiField(
                bean,
                va,
                field,
                errors,
                validator,
                request);

        // ʊmF
        assertTrue(result);
        assertTrue(errors.isEmpty());

        // MultiFieldValidatořĂяoAmF
        assertEquals(1,
                FieldChecksEx_MultiFieldValidatorImpl01.validateCalledCount);
        assertEquals("abc", FieldChecksEx_MultiFieldValidatorImpl01.value);
        assertEquals(0, FieldChecksEx_MultiFieldValidatorImpl01.fields.length);

    }

    /**
     * testValidateMultiField09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Bean<br>
     *                field1="abc"<br>
     *                field2="def"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:multiFieldValidator=<br>
     *                "jp.terasoluna.fw.web.struts.form.FieldCheckEx_MultiFieldValidatorImpl01"<br>
     *                var:fields="field2"<br>
     *                var:property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                (̗vf)<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () MultiFieldValidator.validate():true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) MultiFieldValidator:"abc",<br>
     *                    z{"def"}<br>
     *                    ŌĂяo邱ƁB<br>
     *         (ԕω) errors:not null<br>
     *                    (̗vf)<br>
     *
     * <br>
     * fieldsɃJ}؂薳̕񂪎w肳ĂꍇA
     * ̖ÕvpeBlbean擾A
     * 1̔zƂMultiFieldValidatoȓɓn邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField09() throws Exception {
        //eXgf[^ݒ
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("multiFieldValidator");
        var.setValue("jp.terasoluna.fw.web.struts.form." +
                "FieldChecksEx_MultiFieldValidatorImpl01");
        field.addVar(var);
        var = new Var();
        var.setName("fields");
        var.setValue("field2");
        field.addVar(var);
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // MultiFieldValidator̖߂lݒ
        FieldChecksEx_MultiFieldValidatorImpl01.result = true;

        // eXgs
        boolean result = FieldChecksEx.validateMultiField(
                javaBean,
                va,
                field,
                errors,
                validator,
                request);

        // ʊmF
        assertTrue(result);
        assertTrue(errors.isEmpty());

        // MultiFieldValidatořĂяoAmF
        assertEquals(1,
                FieldChecksEx_MultiFieldValidatorImpl01.validateCalledCount);
        assertEquals("abc", FieldChecksEx_MultiFieldValidatorImpl01.value);
        assertEquals(1, FieldChecksEx_MultiFieldValidatorImpl01.fields.length);
        assertEquals("def", FieldChecksEx_MultiFieldValidatorImpl01.fields[0]);

    }

    /**
     * testValidateMultiField10()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() bean:Bean<br>
     *                field1="abc"<br>
     *                field2="def"<br>
     *                field3="ghi"<br>
     *                field4="jkl"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *                var:multiFieldValidator=<br>
     *                "jp.terasoluna.fw.web.struts.form.FieldCheckEx_MultiFieldValidatorImpl01"<br>
     *                var:fields="field2 ,,test,field3,field4"<br>
     *                var:property="field1"<br>
     *                Msg("message","message")<br>
     *         () errors:not null<br>
     *                ActionMessage("testMessage")<br>
     *         () validator:not null<br>
     *         () request:not null<br>
     *         () MultiFieldValidator.validate():false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) MultiFieldValidator:"abc",<br>
     *                    z{"def",null,"ghi","jkl"}<br>
     *                    ŌĂяo邱ƁB<br>
     *         (ԕω) errors:ActionMessage("testMessage")<br>
     *                    ActionMessage("message")<br>
     *
     * <br>
     * fieldsɃJ}؂̕񂪎w肳ĂꍇA
     * J}ŋ؂ꂽSĂ̖ÕvpeBlbean擾A
     * zƂMultiFieldValidatoȓɓn邱ƂmFB<br>
     * MultiFieldValidatorvalidate\bhfalseԋpꍇA
     * G[bZ[Wǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateMultiField10() throws Exception {
        //eXgf[^ݒ
        // ++++ ؐݒIuWFNg
        ValidatorAction va = new ValidatorAction();
        va.setName("message");
        // ++++ ؃tB[h
        Field field = new Field();
        Var var = new Var();
        var.setName("multiFieldValidator");
        var.setValue("jp.terasoluna.fw.web.struts.form." +
                "FieldChecksEx_MultiFieldValidatorImpl01");
        field.addVar(var);
        var = new Var();
        var.setName("fields");
        var.setValue("field2 ,,test,field3,field4");
        field.addVar(var);
        field.setProperty("field1");
        // bZ[Wݒ
        Msg msg = new Msg();
        msg.setKey("message");
        msg.setName("message");
        msg.setResource(false);
        field.addMsg(msg);
        // G[
        ActionMessages errors = new ActionMessages();
        ActionMessage error = new ActionMessage("testMessage");
        errors.add(Globals.ERROR_KEY, error);
        // [HTTPNGXg
        MockHttpServletRequest request = new MockHttpServletRequest();
        // ValidatorResourcesCX^X
        ValidatorResources validatorResources = new ValidatorResources();
        // ValidatorCX^X
        Validator validator = new Validator(validatorResources);

        // MultiFieldValidator̖߂lݒ
        FieldChecksEx_MultiFieldValidatorImpl01.result = false;

        // eXgs
        boolean result = FieldChecksEx.validateMultiField(
                javaBean,
                va,
                field,
                errors,
                validator,
                request);

        // ʊmF
        assertFalse(result);
        assertEquals(2, errors.size());

        // bZ[WIuWFNg̃`FbN
        Iterator it = errors.get();
        List<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            ActionMessage message = (ActionMessage) it.next();
            list.add(message.getKey());
        }
        assertTrue(list.contains("testMessage"));
        assertTrue(list.contains("message"));

        // MultiFieldValidatořĂяoAmF
        assertEquals(1,
                FieldChecksEx_MultiFieldValidatorImpl01.validateCalledCount);
        assertEquals("abc", FieldChecksEx_MultiFieldValidatorImpl01.value);
        assertEquals(4, FieldChecksEx_MultiFieldValidatorImpl01.fields.length);
        assertEquals("def", FieldChecksEx_MultiFieldValidatorImpl01.fields[0]);
        assertNull(FieldChecksEx_MultiFieldValidatorImpl01.fields[1]);
        assertEquals("ghi", FieldChecksEx_MultiFieldValidatorImpl01.fields[2]);
        assertEquals("jkl", FieldChecksEx_MultiFieldValidatorImpl01.fields[3]);

    }

}
