/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.action.PropertyMessageResourcesEx} NX̃ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * VXeƋƖʂ̃bZ[W\[X\\ɂ
 * vpeBt@CbZ[W\[XB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.action.PropertyMessageResourcesEx
 */
public class PropertyMessageResourcesExTest extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(PropertyMessageResourcesExTest.class);
    }


    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public PropertyMessageResourcesExTest(String name) {
        super(name);
    }

    /**
     * testGetMessage01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() locale:Locale.JAPAN<br>
     *         () key:"test.message"<br>
     *         () factory:PropertyMessageResourcesExFactoryCX^X<br>
     *         () config:"PropertyMessageResourcesEx_MessageResources01"<br>
     *                yt@Cez<br>
     *                test.message=eXgbZ[WOP<br>
     *         () returnNull:false<br>
     *         () system-messages̒:<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eXgbZ[WOP"<br>
     *         
     * <br>
     * bZ[W\[X`t@C̃bZ[Wԋp邱Ƃ
     * mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage01() throws Exception {
        // O
        PropertyMessageResourcesExFactory factory
            = new PropertyMessageResourcesExFactory();
        PropertyMessageResourcesEx resources 
            = new PropertyMessageResourcesEx(factory,
                PropertyMessageResourcesEx.class.getPackage().getName().replace('.', '/')
                + "/PropertyMessageResourcesEx_MessageResources01",
                false);
        Object fwMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "fwMessages");
        Object globalMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "globalMessages");
        
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "fwMessages", new HashMap());
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "globalMessages", new HashMap());
        
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "test.message");

        // 
        assertEquals(actual, "eXgbZ[WOP");
        
        // ɖ߂
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "fwMessages", fwMessages);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "globalMessages", globalMessages);
    }

    /**
     * testGetMessage02()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() locale:Locale.JAPAN<br>
     *         () key:"test.message"<br>
     *         () factory:PropertyMessageResourcesExFactoryCX^X<br>
     *         () config:"PropertyMessageResourcesEx_MessageResources02"<br>
     *                ĩt@Cj<br>
     *         () returnNull:false<br>
     *         () system-messages̒:test.message=eveXgbZ[WOP<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eveXgbZ[WOP"<br>
     *         
     * <br>
     * bZ[W\[X`t@Cɗ^ꂽL[o^ĂȂA
     * GlobalMessageResourcesɓo^ĂVXẽbZ[WL[
     * v̂܂܂ꍇAVXẽbZ[Wԋp邱Ƃ
     * mFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage02() throws Exception {
        // O
        PropertyMessageResourcesExFactory factory
            = new PropertyMessageResourcesExFactory();
        PropertyMessageResourcesEx resources 
            = new PropertyMessageResourcesEx(factory,
                PropertyMessageResourcesEx.class.getPackage().getName().replace('.', '/')
                + "/PropertyMessageResourcesEx_MessageResources02",
                false);
        Object fwMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "fwMessages");
        Object globalMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "globalMessages");
        Map<String, String> newFwMessages = new HashMap<String, String>(1);
        newFwMessages.put("test.message", "eveXgbZ[WOP");
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "fwMessages", newFwMessages);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "globalMessages", new HashMap());
        
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "test.message");

        // 
        assertEquals(actual, "eveXgbZ[WOP");
        
        // ɖ߂
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "fwMessages", fwMessages);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "globalMessages", globalMessages);
    }

    /**
     * testGetMessage03()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() locale:Locale.JAPAN<br>
     *         () key:"test.message"<br>
     *         () factory:PropertyMessageResourcesExFactoryCX^X<br>
     *         () config:"PropertyMessageResourcesEx_MessageResources01"<br>
     *                yt@Cez<br>
     *                test.message=eXgbZ[WOP<br>
     *         () returnNull:false<br>
     *         () system-messages̒:test.message=eveXgbZ[WOP<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eXgbZ[WOP"<br>
     *         
     * <br>
     * bZ[W\[X`t@CɂGlobalMessageResourcesɂ^ꂽ
     * L[ŃbZ[W\[Xo^Ăꍇɂ́AbZ[W\[X
     * `t@Cɒ`ꂽbZ[Wԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage03() throws Exception {
        // O
        PropertyMessageResourcesExFactory factory
            = new PropertyMessageResourcesExFactory();
        PropertyMessageResourcesEx resources 
            = new PropertyMessageResourcesEx(factory,
                PropertyMessageResourcesEx.class.getPackage().getName().replace('.', '/')
                + "/PropertyMessageResourcesEx_MessageResources01",
                false);
        Object fwMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "fwMessages");
        Object globalMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "globalMessages");
        Map<String, String> newFwMessages = new HashMap<String, String>(1);
        newFwMessages.put("test.message", "eveXgbZ[WOP");
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "fwMessages", newFwMessages);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "globalMessages", new HashMap());
        
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "test.message");

        // 
        assertEquals(actual, "eXgbZ[WOP");
        
        // ɖ߂
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "fwMessages", fwMessages);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "globalMessages", globalMessages);
    }

    /**
     * testGetMessage04()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() locale:Locale.JAPAN<br>
     *         () key:"aaaaa"<br>
     *         () factory:PropertyMessageResourcesExFactoryCX^X<br>
     *         () config:"PropertyMessageResourcesEx_MessageResources02"<br>
     *                ĩt@Cj<br>
     *         () returnNull:false<br>
     *         () system-messages̒:<br>
     *         
     * <br>
     * ҒlF(߂l) String:"???ja_JP.aaaaa???"<br>
     *         
     * <br>
     * vpeBAVXeõbZ[W炸AreturnNulltB[h
     * falsełƂA???ja_JP.aaaaa???̌`ŕԋpB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage04() throws Exception {
        // O
        PropertyMessageResourcesExFactory factory
            = new PropertyMessageResourcesExFactory();
        PropertyMessageResourcesEx resources 
            = new PropertyMessageResourcesEx(factory,
                PropertyMessageResourcesEx.class.getPackage().getName().replace('.', '/')
                + "/PropertyMessageResourcesEx_MessageResources02",
                false);
        Object fwMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "fwMessages");
        Object globalMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "globalMessages");
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "fwMessages", new HashMap());
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "globalMessages", new HashMap());
        
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "aaaaa");

        // 
        assertEquals(actual, "???ja_JP.aaaaa???");
        
        // ɖ߂
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "fwMessages", fwMessages);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "globalMessages", globalMessages);
    }

    /**
     * testGetMessage05()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() locale:Locale.JAPAN<br>
     *         () key:"aaaaa"<br>
     *         () factory:PropertyMessageResourcesExFactoryCX^X<br>
     *         () config:"PropertyMessageResourcesEx_MessageResources02"<br>
     *                ĩt@Cj<br>
     *         () returnNull:true<br>
     *         () system-messages̒:<br>
     *         
     * <br>
     * ҒlF(߂l) String:null<br>
     *         
     * <br>
     * vpeBAVXeõbZ[W炸AreturnNulltB[h
     * truełƂAnullԋpB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage05() throws Exception {
        // O
        PropertyMessageResourcesExFactory factory
            = new PropertyMessageResourcesExFactory();
        PropertyMessageResourcesEx resources 
            = new PropertyMessageResourcesEx(factory,
                PropertyMessageResourcesEx.class.getPackage().getName().replace('.', '/')
                + "/PropertyMessageResourcesEx_MessageResources02",
                true);
        Object fwMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "fwMessages");
        Object globalMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "globalMessages");
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "fwMessages", new HashMap());
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "globalMessages", new HashMap());
        
        
        // eXg{
        String actual = resources.getMessage(Locale.JAPAN, "aaaaa");

        // 
        assertNull(actual);
        
        // ɖ߂
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "fwMessages", fwMessages);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "globalMessages", globalMessages);
    }

    /**
     * testGetMessage06()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() locale:Locale.ENGLISH<br>
     *         () key:"test.message"<br>
     *         () factory:PropertyMessageResourcesExFactoryCX^X<br>
     *         () config:"PropertyMessageResourcesEx_MessageResources03"<br>
     *                y"PropertyMessageResourcesEx_MessageResources03_en"̓ez<br>
     *                test.message=Test Message 01<br>
     *                y"PropertyMessageResourcesEx_MessageResources03"̓ez<br>
     *                test.message=eXgbZ[WOP<br>
     *         () returnNull:false<br>
     *         () system-messages̒:<br>
     *         
     * <br>
     * ҒlF(߂l) String:"Test Message"<br>
     *         
     * <br>
     * bZ[W\[X`t@CɃP[lt@CꍇA
     * D悵ĕԋp邱ƂmFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetMessage06() throws Exception {
        // O
        PropertyMessageResourcesExFactory factory
            = new PropertyMessageResourcesExFactory();
        PropertyMessageResourcesEx resources 
            = new PropertyMessageResourcesEx(factory,
                PropertyMessageResourcesEx.class.getPackage().getName().replace('.', '/')
                + "/PropertyMessageResourcesEx_MessageResources03",
                false);
        Object fwMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "fwMessages");
        Object globalMessages 
            = UTUtil.getPrivateField(GlobalMessageResources.getInstance(),
                                     "globalMessages");
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "fwMessages", new HashMap());
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                                 "globalMessages", new HashMap());
        
        
        // eXg{
        String actual = resources.getMessage(Locale.ENGLISH, "test.message");

        // 
        assertEquals(actual, "Test Message 01");
        
        // ɖ߂
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "fwMessages", fwMessages);
        UTUtil.setPrivateField(GlobalMessageResources.getInstance(),
                "globalMessages", globalMessages);
    }

}
