/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.action;

import jp.terasoluna.utlib.UTUtil;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.web.struts.action.DBMessageBean} NX
 * ubN{bNXeXgB
 * 
 * <p>
 * <h4>yNX̊Tvz</h4>
 * DB擾sibZ[W\[XjꎞIɃIuWFNǧ`
 * ۊǂ邽߂ɂNXB
 * <p>
 * 
 * @see jp.terasoluna.fw.web.struts.action.DBMessageBean
 */
public class DBMessageBeanTest extends TestCase {

    /**
     * eXgpCX^XB
     */
    DBMessageBean dbmBean = null;
    
    
    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     * 
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(DBMessageBeanTest.class);
    }

    /**
     * sB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        dbmBean = new DBMessageBean();
    }

    /**
     * IsB
     * 
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        dbmBean = null;
    }

    /**
     * RXgN^B
     * 
     * @param name ̃eXgP[X̖OB
     */
    public DBMessageBeanTest(String name) {
        super(name);
    }

    /**
     * testGetKey01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"test01"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"test01"<br>
     *         
     * <br>
     * getteřĂяomFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetKey01() throws Exception {
        //  O
        UTUtil.setPrivateField(dbmBean, "key", "test01");
        
        //  eXg{
        String actual = dbmBean.getKey();

        //  
        assertEquals("test01", actual);
    }

    /**
     * testSetKey01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() key:"test01"<br>
     *         () key:null<br>
     *         
     * <br>
     * ҒlF(ԕω) key:"test01"<br>
     *         
     * <br>
     * setteřĂяomFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetKey01() throws Exception {
        //  O
        UTUtil.setPrivateField(dbmBean, "key", null);

        //  eXg{
        dbmBean.setKey("test01");

        //  
        assertEquals("test01", UTUtil.getPrivateField(dbmBean, "key"));
    }

    /**
     * testGetValue01()
     * <br><br>
     * 
     *  (n) 
     *  <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"eXgbZ[WOP"<br>
     *         
     * <br>
     * ҒlF(߂l) String:"eXgbZ[WOP"<br>
     *         
     * <br>
     * getteřĂяomFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testGetValue01() throws Exception {
        //  O
        UTUtil.setPrivateField(dbmBean, "value", "eXgbZ[WOP");
        
        //  eXg{
        String actual = dbmBean.getValue();

        //  
        assertEquals("eXgbZ[WOP", actual);
    }

    /**
     * testSetValue01()
     * <br><br>
     * 
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() value:"eXgbZ[WOP"<br>
     *         () value:null<br>
     *         
     * <br>
     * ҒlF(ԕω) value:"eXgbZ[WOP"<br>
     *         
     * <br>
     * setteřĂяomFB
     * <br>
     * 
     * @throws Exception ̃\bhŔO
     */
    public void testSetValue01() throws Exception {
        //  O
        UTUtil.setPrivateField(dbmBean, "value", null);

        //  eXg{
        dbmBean.setValue("eXgbZ[WOP");

        //  
        assertEquals("eXgbZ[WOP", 
                     UTUtil.getPrivateField(dbmBean, "value"));
    }

}
