/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.struts.actions;

import java.util.Iterator;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import jp.terasoluna.fw.exception.SystemException;
import jp.terasoluna.fw.service.thin.AbstractBLogicMapper;
import jp.terasoluna.fw.service.thin.BLogicIO;
import jp.terasoluna.fw.service.thin.BLogicMessage;
import jp.terasoluna.fw.service.thin.BLogicMessages;
import jp.terasoluna.fw.service.thin.BLogicResources;
import jp.terasoluna.fw.service.thin.BLogicResult;
import jp.terasoluna.fw.web.struts.ModuleUtil;
import jp.terasoluna.fw.web.struts.action.ActionMappingEx;
import jp.terasoluna.fw.web.struts.plugins.BLogicIOPlugIn;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;


/**
 * rWlXWbNNۃNXB
 *
 * <p>
 *  rWlXWbN̋NsANVNXɋʂ@\
 *  W񂵂ۃNXłBSẴrWlXWbNNANVNX
 *  ̃NXpĎB
 *  BLogicActioñNXpĂB
 *  񋟂@\ꗗ͉L̂ƂłB
 * <ol>
 *  <li>struts-config.xml̃ANVݒ肩
 *   rWlXWbNNX擾B</li>
 *  <li>rWlXWbN̓͏ƂȂ JavaBean 𐶐B</li>
 *  <li>pNX̃Gg|CgƂȂdoExecuteBLogic()sB</li>
 *  <li>rWlXWbNIꍇABLogicResulťʂB</li>
 * </ol>
 *
 * <p>
 *  rWlXWbNNANVNX́A
 *  Bean`t@CɂċNrWlXWbNݒ肵ŁA
 *  sB
 *  Ĺ̗ArWlXWbNłSampleBLogicSampleAction
 *  N邽߂̐ݒłB
 *  킹struts-config.xml̐ݒȉɎB
 * </p>
 * <p>
 * <strong>Bean`t@C̐ݒ</strong>
 * <code><pre>
 * &lt;bean name="/SampleAction" singleton="false"
 *   <b>class="jp.terasoluna.sample1.actions.SampleAction"</b>&gt
 *   <b>&lt;property name="sampleBLogic"&gt;
 *     &lt;ref bean="SampleBLogic"&gt;&lt;/ref&gt;
 *   &lt;/property&gt;</b>
 * &lt;/bean&gt
 * &lt;bean id="SampleBLogic"
 *   <b>class="jp.terasoluna.sample1.blogic.SampleBLogic"</b>&gt
 * &lt;/bean&gt
 * </pre></code>
 * </p>
 * <p>
 * <strong>struts-config.xml̐ݒ</strong>
 * <code><pre>
 *    &lt;action path="/SampleAction"
 *       name="_sampleForm"
 *       validate="true"
 *       scope="session"
 *       input="/sample.jsp"&gt;
 *    &lt;forward name="success" path="/sampleSCR.do"/&gt;
 *    &lt;forward name="failure" path="/errorSCR.do"/&gt;
 *  &lt;/action&gt;
 * </pre></code>
 * </p>
 * BLogicResult̗pAݒɂẮA
 * BLogicIOPlugInABLogicResultAAbstractBLogicMapperQƂ̂ƁB
 * </p>
 *
 * <p>
 *  ܂ArWlXWbN̎sɎsꍇȂǂŁA
 *  bZ[Wݒ肵ۂ́Â悤BLogicResultɃbZ[Wi[B
 * </p>
 * <p>
 * <code><pre>
 * public BLogicResult doExecuteBLogic(ParamsBean params) {
 *
 *     // BLogicResult𐶐B
 *     BLogicResult result = new BLogicResult();
 *     EEE
 *     //rWlXWbN
 *     EEE
 *     //G[
 *     if (// G[菈 ) {
 *         // Webwɂɔfׂݒ肷B
 *         EEE
 *         return result;
 *     } else {
 *         // rWlXWbÑG[
 *         // BLogicMessages𐶐
 *         BLogicMessages messages = new BLogicMessages();
 *         // GROUP_ERRORO[ṽbZ[WƂāABLogicMessagei[
 *         messages.add("GROUP_ERROR", new BLogicMessage("message.error.sample", "sample"));
 *         // G[pBLogicMessagesBLogicResultɐݒ
 *         result.setErrors(messages);
 *         // sʂ"failure"w
 *         result.setResultString("failure");
 *         return result;
 *     }
 * }
 * </pre></code>
 * </p>
 *
 *
 * @see jp.terasoluna.fw.web.struts.actions.BLogicAction
 * @see jp.terasoluna.fw.web.struts.plugins.BLogicIOPlugIn
 * @see jp.terasoluna.fw.service.thin.BLogicResult
 * @see jp.terasoluna.fw.service.thin.AbstractBLogicMapper
 * @see jp.terasoluna.fw.service.thin.BLogicMapper
 * @see jp.terasoluna.fw.service.thin.BLogicMessage
 * @see jp.terasoluna.fw.service.thin.BLogicMessages
 *
 * @param <P> rWlXWbNւ̓͒lƂȂJavaBeanw肷
 *
 */
public abstract class AbstractBLogicAction<P> extends ActionEx {

    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(AbstractBLogicAction.class);

    /**
     * gANVtH[ݒG[̃G[R[hB
     */
    protected static final String BLOGIC_FORM_ILLEGAL_ERROR =
                                                         "errors.blogic.form";

    /**
     * gANV}bsOݒG[̃G[R[hB
     */
    protected static final String BLOGIC_MAPPING_ILLEGAL_ERROR =
        "errors.blogic.mapping";

    /**
     * gANV\[XݒG[̃G[R[hB
     */
    protected static final String BLOGIC_RESOURCES_ILLEGAL_ERROR =
        "errors.blogic.resources";

    /**
     * BLogicResultnullŕԋpꂽ̃G[R[hB
     */
    protected static final String BLOGIC_RESULT_NULL_ERROR =
        "errors.blogic.result.null";

    /**
     * AbstractBLogicMappernullꍇ̃G[R[hB
     */
    protected static final String NULL_MAPPER_KEY =
        "errors.blogic.mapper.null";

    /**
     * bZ[WۑXR[vB
     *
     * rWlXWbNŐBLogicMessages̕ۑ
     * request܂session̂ꂩŎw肷B
     */
    private String saveMessageScope = null;

    /**
     * bZ[WۑXR[vݒ肷B
     *
     * @param saveMessageScope bZ[WۑXR[v
     */
    public void setSaveMessageScope(String saveMessageScope) {
        this.saveMessageScope = saveMessageScope;
    }

    /**
     * rWlXWbNsB
     * <p>
     *  rWlXWbN̎sɕKvȉL̋ʏsB<br>
     *  <ul>
     *   <li>rWlXWbN̓͏łJavaBean̐</li>
     *   <li>rWlXWbN̏o͏łBLogicResult̉</li>
     *   <li>tH[ȟ</li>
     *  </ul>
     * </p>
     *
     * @param mapping ANV}bsO
     * @param form    tH[
     * @param request NGXg
     * @param response X|X
     *
     * @return JڐANVtH[h
     * @throws Exception TuNXX[ꂽA\ȂO
     */
    @Override
    public ActionForward doExecute(ActionMapping mapping,
                                         ActionForm form,
                                         HttpServletRequest request,
                                         HttpServletResponse response)
            throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("*** doExecute() called. action path=["
                + mapping.getPath() + "] ***");
        }

        ActionMappingEx mappingEx = null;
        try {
            mappingEx = (ActionMappingEx) mapping;
        } catch (ClassCastException e) {
            log.error("Illegal ActionMapping.");
            throw new SystemException(e, BLOGIC_MAPPING_ILLEGAL_ERROR);
        }

        P params = getBLogicParams(mappingEx, request, response);

        if (log.isDebugEnabled()) {
            log.debug("*** BLogicParams is prepared. ***");
            if (params != null) {
                // params̐ݒ_vB
                log.debug("BLogicParams:" + params.toString());
            } else {
                // paramsnull̏ꍇ
                log.debug("BLogicParams:null");
            }
        }

        if (log.isDebugEnabled()) {
            log.debug("*** starting blogic action["
                 + this.getClass().getName() + "] ***");
        }

        BLogicResult result = null;

        // O
        preDoExecuteBLogic(request, response, params);

        // rWlXWbNN
        result = doExecuteBLogic(params);

        // ㏈
        postDoExecuteBLogic(request, response, params, result);

        if (log.isDebugEnabled()) {
            log.debug("*** finished blogic action["
                 + this.getClass().getName() + "] ***");
        }

        if (result != null) {
            // BLogicResultnullŕԋpȂꍇ̂
            // ]sB
            evaluateBLogicResult(
                result, request, response, mappingEx);
            // ActionForward擾
            return mapping.findForward(result.getResultString());
        }
        log.error("BLogicResult is null.");
        // nullŕԋpꂽꍇSystemExceptionX[B
        throw new SystemException(new NullPointerException(),
            BLOGIC_RESULT_NULL_ERROR);
    }

    /**
     * rWlXWbN̎sOB
     *
     * @param request NGXg
     * @param response X|X
     * @param params p[^iJavaBeanj
     * @throws Exception \ȂO
     */
    protected void preDoExecuteBLogic(HttpServletRequest request,
            HttpServletResponse response, P params) throws Exception {

    }

    /**
     * rWlXWbN̎s㏈B
     *
     * <p>rWlXWbNŗOȂꍇ̂݁AsB</p>
     *
     * @param request NGXg
     * @param response X|X
     * @param params p[^iJavaBeanj
     * @param result rWlXWbNs
     * @throws Exception \ȂO
     */
    protected void postDoExecuteBLogic(HttpServletRequest request,
            HttpServletResponse response, P params, BLogicResult result)
            throws Exception {

    }

    /**
     * BLogicResult̕]AWebw̃IuWFNgւ̌ʔfsB
     *
     * @param result BLogicResultCX^X
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @param mappingEx gANV}bsO
     */
    protected void evaluateBLogicResult(
            BLogicResult result,
            HttpServletRequest request,
            HttpServletResponse response,
            ActionMappingEx mappingEx) {

        // BLogicResultnull`FbN
        if (result == null) {
            log.error("BLogicResult is null.");
            throw new SystemException(new NullPointerException(),
                    BLOGIC_RESULT_NULL_ERROR);
        }

        // BLogicResult̐ݒ_vB
        if (log.isDebugEnabled()) {
            log.debug("*** BLogicResult is prepared. ***");
            log.debug("BLogicResult:" + result.toString());
        }

        ActionMessages errors = convertMessages(result.getErrors());
        ActionMessages messages = convertMessages(result.getMessages());

        // ANV}bsOɎw肳ꂽG[EbZ[W
        // ۑ擾B
        if ("session".equalsIgnoreCase(saveMessageScope)) {
            // ۑ悪ZbVŎw肳ĂꍇA
            // ZbVɑ΂ăG[EbZ[WǉB

            // ZbV̎擾
            HttpSession session = request.getSession(true);

            addErrors(session, errors);
            addMessages(session, messages);
        } else {
            // ȊȌꍇANGXgɒǉB
            addErrors(request, errors);
            addMessages(request, messages);
        }

        if (isErrorsEmpty(result)) {
            // G[񂪋łƂAWebwɌʂ𔽉f
            if (log.isDebugEnabled()) {
                log.debug(
                    "*** setting result into web layer. ***");
            }
            getBLogicMapper(request).mapBLogicResult(
                request, response, getBLogicIO(mappingEx, request), result);
        }
    }

    /**
     * BLogicMessages̓eActionMessagesɊi[ȂB
     *
     * @param blogicMessages BLogicMessagesCX^X
     * @return ActionMessages
     */
    protected ActionMessages convertMessages(BLogicMessages blogicMessages) {

        if (blogicMessages == null) {
            // blogicMessagesnull̏ꍇAnullԋp
            return null;
        }

        ActionMessages messages = new ActionMessages();
        // BLogicMessages擾pCe[^
        Iterator itr = blogicMessages.get();
        // bZ[WO[v擾pCe[^
        Iterator groupItr = blogicMessages.getGroup();
        while (itr.hasNext()) {

            // BLogicMessage擾
            BLogicMessage blogicMessage = (BLogicMessage) itr.next();

            // ActionMessage쐬
            ActionMessage actionMessage = null;
            if (blogicMessage.isResource()) {
                actionMessage = new ActionMessage(blogicMessage.getKey(),
                        blogicMessage.getValues());
            } else {
                actionMessage = new ActionMessage(blogicMessage.getKey(),
                        blogicMessage.isResource());
            }

            // bZ[WO[v擾
            String group = (String) groupItr.next();

            // bZ[Wi[
            messages.add(group, actionMessage);
        }
        return messages;
    }

    /**
     * rWlXWbNsۃ\bhB
     * TuNXŎB
     *
     * @param param rWlXWbN͏
     * @return rWlXWbNo͏
     * @throws Exception \ȂO
     */
    public abstract BLogicResult doExecuteBLogic(P param) throws Exception;

    /**
     * BLogicResultɊi[ĂG[
     * nullł邩łƂAtrueԋpB
     *
     * @param result rWlXWbNs
     * @return G[pBLogicMessagesnull܂́AłƂtrue
     */
    protected boolean isErrorsEmpty(BLogicResult result) {
        // BLogicResult null`FbN
        if (result == null) {
            log.error("BLogicResult is null.");
            throw new SystemException(new NullPointerException(),
                    BLOGIC_RESULT_NULL_ERROR);
        }

        BLogicMessages errors = result.getErrors();
        if (errors == null) {
            return true;
        }
        return errors.isEmpty();
    }

    /**
     * BLogicMapperCX^X擾B
     *
     * @param req HTTPNGXg
     * @return BLogicMapperCX^X
     */
    protected AbstractBLogicMapper getBLogicMapper(HttpServletRequest req) {
        String moduleName = ModuleUtil.getPrefix(req);

        AbstractBLogicMapper mapper = null;
        try {
            mapper = (AbstractBLogicMapper) this.servlet.getServletContext()
            .getAttribute(BLogicIOPlugIn.BLOGIC_MAPPER_KEY + moduleName);
        } catch (ClassCastException e) {
            // AbstractBLogicMapperCX^XłȂꍇAONB
            log.error("Cannot cast BLogicMapper : " + e.getMessage());
            throw new SystemException(e, BLOGIC_MAPPING_ILLEGAL_ERROR);
        }

        // BLogicMappernull̏ꍇAO
        if (mapper == null) {
            log.error("BLogicMapper is null.");
            throw new SystemException(new NullPointerException(),
                    NULL_MAPPER_KEY);
        }

        return mapper;
    }

    /**
     * params𐶐AԋpB
     *
     * @param mapping ANV}bsO
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @return rWlXWbN͏
     * @throws Exception \ȂO
     */
    @SuppressWarnings("unchecked")
    protected P getBLogicParams(ActionMappingEx mapping,
                                          HttpServletRequest request,
                                          HttpServletResponse response)
            throws Exception {

        BLogicIO io = getBLogicIO(mapping, request);

        // tH[AZbV̐ݒl擾
        P bean = (P) getBLogicMapper(request).mapBLogicParams(
                request, response, io);

        return bean;
    }

    /**
     * BLogicIO擾B
     *
     * @param mapping ANV}bsO
     * @param request HTTPNGXg
     * @return rWlXWbNo͏
     */
    protected BLogicIO getBLogicIO(ActionMapping mapping,
            HttpServletRequest request) {

        String moduleName = ModuleUtil.getPrefix(request);

        BLogicResources resource = null;
        try {
            resource =
                (BLogicResources) this.servlet.getServletContext().getAttribute(
                BLogicResources.BLOGIC_RESOURCES_KEY + moduleName);
        } catch (ClassCastException e) {
            // BLogicResourcesCX^XłȂꍇAONB
            log.error("Cannot cast BLogicResources : " + e.getMessage());
            throw new SystemException(e, BLOGIC_RESOURCES_ILLEGAL_ERROR);
        }

        if (resource != null) {
            return resource.getBLogicIO(mapping.getPath());
        }
        return null;
    }
}
