/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.oxm.mapper.castor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.terasoluna.fw.oxm.mapper.OXMapper;
import jp.terasoluna.fw.oxm.mapper.castor.exception.CastorCreateMarshallerIOException;
import jp.terasoluna.fw.oxm.mapper.castor.exception.CastorMappingException;
import jp.terasoluna.fw.oxm.mapper.castor.exception.CastorMarshalException;
import jp.terasoluna.fw.oxm.mapper.castor.exception.CastorUnsupportedEncodingException;
import jp.terasoluna.fw.oxm.mapper.castor.exception.CastorValidationException;
import jp.terasoluna.fw.oxm.serialize.XMLSerializerEx;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.serialize.OutputFormat;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.ClassDescriptorResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class CastorOXMapperImpl
implements OXMapper {
    private static Log log = LogFactory.getLog(CastorOXMapperImpl.class);
    protected static final String DEFAULT_CHARSET = "UTF-8";
    private String charset = "UTF-8";
    private boolean cache = true;
    private boolean suppressXSIType = true;
    private boolean preserveWhitespaceAtMarshal = true;
    private boolean preserveWhitespaceAtUnmarshal = false;
    private boolean indenting = true;
    public static final String NESTED_PACKAGE_SEPARATOR = ".";
    public static final String NESTED_FOLDER_SEPARATOR = "/";
    public static final String CASTOR_MAPPINGFILE_SUFFIX = ".xml";
    private Map<Class, Mapping> mappingFileCache = new HashMap<Class, Mapping>();
    private XMLClassDescriptorResolver sharedResolverForMarshaller = null;
    private Set<Class> hasSetMappingSetForMarshaller = new HashSet<Class>();

    public void unmarshal(Document doc, Object out) {
        if (doc == null) {
            log.error((Object)"DOM tree is null.");
            throw new IllegalArgumentException("DOM tree is null.");
        }
        Unmarshaller unmarshaller = this.createUnmarshaller(out);
        try {
            unmarshaller.unmarshal((Node)doc);
        }
        catch (MarshalException e) {
            log.error((Object)"Castor unmarshal failure.", (Throwable)e);
            throw new CastorMarshalException(e);
        }
        catch (ValidationException e) {
            log.error((Object)"Castor validation error.", (Throwable)e);
            throw new CastorValidationException(e);
        }
    }

    public void unmarshal(Reader reader, Object out) {
        if (reader == null) {
            log.error((Object)"Reader is null.");
            throw new IllegalArgumentException("Reader is null.");
        }
        Unmarshaller unmarshaller = this.createUnmarshaller(out);
        try {
            unmarshaller.unmarshal(reader);
        }
        catch (MarshalException e) {
            log.error((Object)"Castor unmarshal failure.", (Throwable)e);
            throw new CastorMarshalException(e);
        }
        catch (ValidationException e) {
            log.error((Object)"Castor validation error.", (Throwable)e);
            throw new CastorValidationException(e);
        }
    }

    public void unmarshal(InputStream is, String argCharset, Object out) {
        if (is == null) {
            log.error((Object)"InputStream is null.");
            throw new IllegalArgumentException("InputStream is null.");
        }
        String charset = argCharset;
        if (charset == null || charset.length() < 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Character encoding is not found. UTF-8 is used.");
            }
            charset = this.getCharset();
        }
        InputStreamReader isr = null;
        try {
            isr = new InputStreamReader(is, charset);
            this.unmarshal(isr, out);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Character encoding error.", (Throwable)e);
            throw new CastorUnsupportedEncodingException(e);
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException e) {
                log.error((Object)"Failed to close input stream.", (Throwable)e);
            }
        }
    }

    protected Unmarshaller createUnmarshaller(Object out) {
        if (out == null) {
            log.error((Object)"Unmarshal object is null.");
            throw new IllegalArgumentException("Unmarshal object is null.");
        }
        Unmarshaller unmarshaller = new Unmarshaller(out);
        Class<?> mappingClass = out.getClass();
        Mapping mapping = this.getCastorMapping(mappingClass);
        if (mapping != null) {
            try {
                unmarshaller.setMapping(mapping);
            }
            catch (MappingException e) {
                log.error((Object)("Castor mapping file is invalid. - [root-classpath]/" + this.getMappingFilePath(mappingClass)), (Throwable)e);
                throw new CastorMappingException(e);
            }
            if (this.cache && !this.mappingFileCache.containsKey(mappingClass)) {
                this.mappingFileCache.put(mappingClass, mapping);
            }
        }
        unmarshaller.setValidation(false);
        unmarshaller.setWhitespacePreserve(this.preserveWhitespaceAtUnmarshal);
        return unmarshaller;
    }

    public void marshal(Object in, Writer writer) {
        Marshaller marshaller = this.createMarshaller(in, writer);
        try {
            marshaller.marshal(in);
        }
        catch (MarshalException e) {
            log.error((Object)"Castor marshal failure.", (Throwable)e);
            throw new CastorMarshalException(e);
        }
        catch (ValidationException e) {
            log.error((Object)"Castor validation error.", (Throwable)e);
            throw new CastorValidationException(e);
        }
    }

    protected Marshaller createMarshaller(Object in, Writer writer) {
        Mapping mapping;
        if (in == null) {
            log.error((Object)"Marshall object is null.");
            throw new IllegalArgumentException("Marshall object is null.");
        }
        if (writer == null) {
            log.error((Object)"Writer is null.");
            throw new IllegalArgumentException("Writer is null.");
        }
        Marshaller marshaller = null;
        try {
            XMLSerializerEx serializer = new XMLSerializerEx(writer, new OutputFormat("xml", this.charset, this.indenting));
            serializer.setPreserveWhitespace(this.preserveWhitespaceAtMarshal);
            marshaller = new Marshaller((ContentHandler)((Object)serializer));
            if (this.sharedResolverForMarshaller == null) {
                ClassDescriptorResolver resolver = marshaller.getResolver();
                if (resolver instanceof XMLClassDescriptorResolver) {
                    this.sharedResolverForMarshaller = (XMLClassDescriptorResolver)resolver;
                }
            } else {
                marshaller.setResolver(this.sharedResolverForMarshaller);
            }
        }
        catch (IOException e) {
            log.error((Object)"Marshaling io error.", (Throwable)e);
            throw new CastorCreateMarshallerIOException(e);
        }
        Class<?> mappingClass = in.getClass();
        if (!this.hasSetMappingSetForMarshaller.contains(mappingClass) && (mapping = this.getCastorMapping(mappingClass)) != null) {
            try {
                marshaller.setMapping(mapping);
                this.hasSetMappingSetForMarshaller.add(mappingClass);
            }
            catch (MappingException e) {
                log.error((Object)("Castor mapping file is invalid. - [root-classpath]/" + this.getMappingFilePath(mappingClass)), (Throwable)e);
                throw new CastorMappingException(e);
            }
            if (this.cache && !this.mappingFileCache.containsKey(mappingClass)) {
                this.mappingFileCache.put(mappingClass, mapping);
            }
        }
        marshaller.setValidation(false);
        marshaller.setSuppressXSIType(this.suppressXSIType);
        return marshaller;
    }

    protected Mapping getCastorMapping(Class mappingClass) {
        Mapping mapping = null;
        if (this.cache && (mapping = this.mappingFileCache.get(mappingClass)) != null) {
            return mapping;
        }
        mapping = new Mapping();
        URL mappingURL = this.getUrl(mappingClass);
        if (mappingURL == null) {
            return null;
        }
        mapping.loadMapping(new InputSource(mappingURL.toExternalForm()));
        return mapping;
    }

    protected URL getUrl(Class mappingClass) {
        return Thread.currentThread().getContextClassLoader().getResource(this.getMappingFilePath(mappingClass));
    }

    protected String getMappingFilePath(Class mappingClass) {
        StringBuilder buf = new StringBuilder();
        buf.append(mappingClass.getName().replace(NESTED_PACKAGE_SEPARATOR, NESTED_FOLDER_SEPARATOR));
        buf.append(CASTOR_MAPPINGFILE_SUFFIX);
        return buf.toString();
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setSuppressXSIType(boolean suppressXSIType) {
        this.suppressXSIType = suppressXSIType;
    }

    public void setPreserveWhitespaceAtUnmarshal(boolean preserveWhitespaceAtUnmarshal) {
        this.preserveWhitespaceAtUnmarshal = preserveWhitespaceAtUnmarshal;
    }

    public void setPreserveWhitespaceAtMarshal(boolean preserveWhitespaceAtMarshal) {
        this.preserveWhitespaceAtMarshal = preserveWhitespaceAtMarshal;
    }

    public void setIndenting(boolean indenting) {
        this.indenting = indenting;
    }
}

