/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import java.util.ArrayList;

import org.apache.commons.validator.Field;
import org.apache.commons.validator.ValidatorAction;
import org.apache.commons.validator.ValidatorException;
import org.apache.commons.validator.Var;
import jp.terasoluna.utlib.LogUTUtil;
import jp.terasoluna.utlib.UTUtil;
import jp.terasoluna.fw.validation.FieldChecks;
import junit.framework.TestCase;

/**
 * {@link jp.terasoluna.fw.validation.FieldChecks} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * TERASOLUNA̓̓`FbN@\ŋʂɎgp錟؃[NXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.FieldChecks
 */
public class FieldChecksTest07 extends TestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(FieldChecksTest07.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogUTUtil.flush();
    }

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see junit.framework.TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public FieldChecksTest07(String name) {
        super(name);
    }

    /**
     * testValidateHankakuKanaString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString01() throws Exception {
        // O
        // bean : null
        Object bean = null;
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateHankakuKanaString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateHankakuKanaString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString02() throws Exception {
        // O
        // bean : ""
        Object bean = "";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateHankakuKanaString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateHankakuKanaString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"ݶ"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beanpJî݂ō\ĂꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString03() throws Exception {
        // O
        // bean : "ݶ"
        Object bean = "ݶ";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateHankakuKanaString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateHankakuKanaString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"nJN"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * beanɔpJiȊO̕܂܂ĂꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuKanaString04() throws Exception {
        // O
        // bean : "nJN"
        Object bean = "nJN";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateHankakuKanaString(bean, va, field, errors);

        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateHankakuString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString01() throws Exception {
        // O
        // bean : null
        Object bean = null;
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateHankakuString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateHankakuString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString02() throws Exception {
        // O
        // bean : ""
        Object bean = "";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateHankakuString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateHankakuString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"1a"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beanp݂̂ō\ĂꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString03() throws Exception {
        // O
        // bean : "1a"
        Object bean = "1a";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateHankakuString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateHankakuString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"SpA"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * beanɔpȊO̕܂܂ĂꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateHankakuString04() throws Exception {
        // O
        // bean : "SpA"
        Object bean = "SpA";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateHankakuString(bean, va, field, errors);

        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateZenkakuString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString01() throws Exception {
        // O
        // bean : null
        Object bean = null;
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateZenkakuString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateZenkakuString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString02() throws Exception {
        // O
        // bean : ""
        Object bean = "";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateZenkakuString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateZenkakuString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"SpA"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beanSp݂̂ō\ĂꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString03() throws Exception {
        // O
        // bean : "SpA"
        Object bean = "SpA";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateZenkakuString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateZenkakuString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"1a"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * beanɑSpȊO̕܂܂ĂꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuString04() throws Exception {
        // O
        // bean : "1a"
        Object bean = "1a";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateZenkakuString(bean, va, field, errors);

        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateZenkakuKanaString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuKanaString01() throws Exception {
        // O
        // bean : null
        Object bean = null;
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateZenkakuKanaString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateZenkakuKanaString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuKanaString02() throws Exception {
        // O
        // bean : ""
        Object bean = "";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateZenkakuKanaString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateZenkakuKanaString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"[JN"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beanSpJî݂ō\ĂꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuKanaString03() throws Exception {
        // O
        // bean : "[JN"
        Object bean = "[JN";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateZenkakuKanaString(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateZenkakuKanaString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"1a"<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * beanɑSpJiȊO̕܂܂ĂꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateZenkakuKanaString04() throws Exception {
        // O
        // bean : "1a"
        Object bean = "1a";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateZenkakuKanaString(bean, va, field, errors);

        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateProhibited01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:null<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beannull̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateProhibited01() throws Exception {
        // O
        // bean : null
        Object bean = null;
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateProhibited(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateProhibited02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:""<br>
     *         () va:not null<br>
     *         () field:not null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * bean󕶎̏ꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateProhibited02() throws Exception {
        // O
        // bean : ""
        Object bean = "";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateProhibited(bean, va, field, errors);

        // 
        assertTrue(b);
        assertEquals(0, errors.addErrorCount);
    }

    /**
     * testValidateProhibited03()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                chars=null<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"var[chars] must be specified."<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"var[chars] must be specified."<br>
     *
     * <br>
     * varcharsnull̏ꍇAValidatorExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateProhibited03() throws Exception {
        // O
        // bean : "test"
        Object bean = "test";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        Var var = new Var();
        var.setName("chars");
        var.setValue(null);
        field.addVar(var);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        
        try {
            // eXg{
            @SuppressWarnings("unused") boolean b =
                new FieldChecks().validateProhibited(bean, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            // 
            String message = "var[chars] must be specified.";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
        }
    }

    /**
     * testValidateProhibited04()
     * <br><br>
     *
     * (ُn)
     * <br>
     * ϓ_FG
     * <br><br>
     * ͒lF() bean:"test"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                chars=""<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(ԕω) O:ValidatorException<br>
     *                    bZ[WF"var[chars] must be specified."<br>
     *         (ԕω) O:OxFG[<br>
     *                    bZ[WF"var[chars] must be specified."<br>
     *
     * <br>
     * varcharsnull̏ꍇAValidatorExceptionX[邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateProhibited04() throws Exception {
        // O
        // bean : "test"
        Object bean = "test";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        // field : not null
        Field field = new Field();
        Var var = new Var();
        var.setName("chars");
        var.setValue("");
        field.addVar(var);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        
        try {
            // eXg{
            @SuppressWarnings("unused") boolean b =
                new FieldChecks().validateProhibited(bean, va, field, errors);
            fail();
        } catch (ValidatorException e) {
            // 
            String message = "var[chars] must be specified.";
            assertEquals(message, e.getMessage());
            assertTrue(LogUTUtil.checkError(message));
        }
    }

    /**
     * testValidateProhibited05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"BA@"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                chars="@t"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *         (ԕω) errors:bean,field,vaƂaddErrorsĂяoB<br>
     *
     * <br>
     * beanvarcharsŎw肳ꂽ܂܂ꍇAG[ǉfalseԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateProhibited05() throws Exception {
        // O
        // bean : "BA@"
        Object bean = "BA@";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        
        // field : not null
        Field field = new Field();
        Var var = new Var();
        var.setName("chars");
        var.setValue("@t");
        field.addVar(var);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateProhibited(bean, va, field, errors);

        // 
        assertFalse(b);
        // ďomF
        assertEquals(1, errors.addErrorCount);
        // mF
        ArrayList beanList = (ArrayList) UTUtil.getPrivateField(errors, "beanList");
        assertSame(bean, beanList.get(0));
        ArrayList vaList = (ArrayList) UTUtil.getPrivateField(errors, "vaList");
        assertSame(va, vaList.get(0));
        ArrayList fieldList = (ArrayList) UTUtil.getPrivateField(errors, "fieldList");
        assertSame(field, fieldList.get(0));
    }

    /**
     * testValidateProhibited06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FA
     * <br><br>
     * ͒lF() bean:"BA@"<br>
     *         () va:not null<br>
     *         () field:var:<br>
     *                chars="CDE"<br>
     *         () errors:not null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *         (ԕω) errors:ĂяoȂ<br>
     *
     * <br>
     * beanvarcharsŎw肳ꂽ܂܂ȂꍇAtrueԋp邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testValidateProhibited06() throws Exception {
        // O
        // bean : "BA@"
        Object bean = "BA@";
        // va : not null
        ValidatorAction va = new ValidatorAction();
        
        // field : not null
        Field field = new Field();
        Var var = new Var();
        var.setName("chars");
        var.setValue("CDE");
        field.addVar(var);
        
        // errors : not null
        FieldChecks_ValidationErrorsImpl01 errors =
            new FieldChecks_ValidationErrorsImpl01();
        
        // eXg{
        boolean b =
            new FieldChecks().validateProhibited(bean, va, field, errors);

        // 
        assertTrue(b);
        // ďomF
        assertEquals(0, errors.addErrorCount);
    }
}