/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.web.rich.springmvc.servlet.view.filedownload;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.servlet.view.AbstractView;

/**
 * oCit@C_E[hۂɗpViewۃNXB
 * 
 * <p>
 * oif[^X|XɏށB
 * KvɉāA
 * X|X{fBɏރXg[̎擾ƁA
 * TuNXɂāAX|Xwb_̏ݒ菈邱ƁB
 * </p>
 * 
 * <p>
 * {NX̎NX𗘗pꍇA܂AResourceBundleViewResolverBean`邱ƁB
 * </p>
 * 
 * <p>
 *  yBean`t@C̐ݒz<br>
 * <code><pre>
 *   &lt;bean id="fileDownloadViewResolver"
 *       class="org.springframework.web.servlet.view.ResourceBundleViewResolver"&gt;
 *     &lt;property name="basename" value="views"/&gt;
 *   &lt;/bean&gt;
 * </pre></code>
 * </p>
 * 
 * <p>
 * ɁAoCif[^X|XƂRg[Bean`ŁA
 * propertyuviewNamev`邱ƁB
 * </p>
 * 
 * <p>
 *  yBean`t@C̐ݒz<br>
 * <code><pre>
 *   &lt;id name="fileDownloadSampleController"
 *           class="jp.terasoluna.sample2.web.controller.FileDownloadSampleController"
 *           parent="queryRequestController" singleton="false"&gt;
 *   &lt;property name="viewName"&gt;&lt;value&gt;FileDownloadSample&lt;/value&gt;&lt;/property&gt;
 *  </bean>
 * </pre></code>
 * </p>
 * 
 * <p>
 * ɁAfileDownloadViewResolveȓbasenamẽvpeBt@CiL̐ݒ̏ꍇAview.propertiesjɁA
 * u<I><Rg[Bean`̑viewNamevpeBl>.class</I>ṽL[
 * sViewNXw肷邱ƁB
 * </p>
 * 
 * <p>
 *  yview.properties̐ݒz<br>
 * <code><pre>
 *   FileDownloadSample.class=jp.terasoluna.sample2.web.view.SampleFileDownloadView
 * </pre></code>
 * </p>
 * 
 */
public abstract class AbstractFileDownloadView extends AbstractView {
    /**
     * ONXB
     */
    private static Log log = LogFactory.getLog(AbstractFileDownloadView.class);
    
    /**
     * `NTCYB
     */
    protected int chunkSize = 256;
    
    /**
     * X|X_OB
     * 
     * @param model fIuWFNg
     * @param request HTTPNGXg
     * @param response HTTPX|X
     * @throws IOException IOO
     * 
     */   
    @Override
    protected void renderMergedOutputModel(Map model,
            HttpServletRequest request, HttpServletResponse response)
            throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("FileDownload start.");
        }      
       
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            // _E[ht@Cf[^擾B
            try {
                inputStream = getInputStream(model, request);
            } catch (IOException e) {
                // _E[hɎsꍇ
                log.error("FileDownload Failed.", e);
                throw e;
            }
            if (inputStream == null) {
                log.error("FileDownload Failed. InputStream is null.");
                throw new IOException(
                    "FileDownload Failed. InputStream is null.");          
            }

            // HTTPX|X̏o̓Xg[ɏ
            try {
                outputStream
                    = new BufferedOutputStream(response.getOutputStream());
            } catch (IOException e) {
                // _E[hɎsꍇ
                log.error("FileDownload Failed.", e);
                throw e;
            }
            
            // wb_ҏW
            addResponseHeader(model, request, response);
            
            try {
                writeResponseStream(inputStream, outputStream);
            } catch (IOException e) {
                // _E[hɎsꍇ
                log.error("FileDownload Failed.", e);
                throw e;
            }
            try {
                outputStream.flush();
            } catch (IOException e) {
                // _E[hɎsꍇ
                log.error("FileDownload Failed.", e);
                throw e;
            }
        } finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException ioe) {
                    log.warn("Cannot close InputStream.", ioe);
                }
            }
 
            if (outputStream != null) {
                try {
                    outputStream.close();
                } catch (IOException ioe) {
                    log.warn("Cannot close OutputStream.", ioe);
                }
            }
        }
    }
    
    /**
     * X|X{fBɏރXg[擾B
     * 
     * @param model fIuWFNg
     * @param request HTTPNGXg
     * @return NGXgɏނ߂̃Xg[
     * @throws IOException o͗O
     */
    protected abstract InputStream getInputStream(
            Map model,
            HttpServletRequest request) throws IOException; 
    
    /**
     * _E[ht@CHTTPX|X̃Xg[ɏށB
     * 
     * @param inputStream _E[ht@Cf[^̓̓Xg[
     * @param outputStream X|X̏o̓Xg[
     * @throws IOException o͗O(O͌Ăьōs)
     */
    protected void writeResponseStream(
            InputStream inputStream, 
            OutputStream outputStream) throws IOException {
        if (inputStream == null || outputStream == null) {
            return;
        }

        byte[] buffer = new byte[chunkSize]; 
        int length = 0;
        while ((length = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, length);
        }   
    }
    
    /**
     * X|Xwb_ǉB
     * 
     * @param model fIuWFNg
     * @param request HTTPNGXg
     * @param response HTTPX|X
     */
    protected abstract void addResponseHeader(Map model,
            HttpServletRequest request,
            HttpServletResponse response);
}
