/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.restart;

import jp.terasoluna.fw.batch.core.JobException;
import jp.terasoluna.fw.batch.core.JobManager;
import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.WorkUnit;
import jp.terasoluna.fw.batch.core.Workable;
import jp.terasoluna.fw.batch.openapi.JobContext;
import jp.terasoluna.fw.batch.springsupport.init.JobStarter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <p>WuReNXg̕sNXB</p>
 * 
 * <p>X^[gsWuł́AWu}l[WĂ΂ӏ
 * ̃NXݍނ悤ɐݒ肷BۂɏsWu}l[ẂA
 * ̃NX <code>jobManager</code> vpeBɐݒ肷B
 * ̃NXł <code>work()</code> \bhł́A
 * X^[gsŁAۂ̏ <code>jobManager</code> 
 * vpeBɐݒ肳ꂽWu}l[WɏϏB</p>
 * 
 * <p>WuǗe[ũWuReNXǵ̕A<code>
 * jobRestartTableHandler</code> vpeBɐݒ肳ꂽWuX^[g
 * e[unhɂčsB</p>
 * 
 */
public class JobContextRestorer implements Workable<WorkUnit> {

    /**
     * OCX^XB
     */
    private static Log log = LogFactory.getLog(JobStarter.class);

    /**
     * Wu}l[W
     */
    private JobManager jobManager = null;
    
    /**
     * WuX^[ge[unh
     */
    private JobRestartTableHandler jobRestartTableHandler = null;
    
    /**
     * Wu}l[Wݒ肷B
     *
     * @param jobManager Wu}l[W
     */
    public void setJobManager(JobManager jobManager) {
        this.jobManager = jobManager;
    }

    /**
     * WuX^[ge[unhݒ肷B
     *
     * @param jobRestartTableHandler WuX^[ge[unh
     */
    public void setJobRestartTableHandler(
            JobRestartTableHandler jobRestartTableHandler) {
        this.jobRestartTableHandler = jobRestartTableHandler;
    }

    /**
     * WuReLXgpB
     * X^[g̏ꍇ̓WuX^[gǗe[uWuReLXg
     * 擾AOWuI_̃WuReLXgԂ𕜌B
     * 
     * @param element ƒP
     * @param jobStatus WuXe[^X
     */
    public void work(WorkUnit element, JobStatus jobStatus) {
        //WuReLXgɃX^[gLݒ
        JobContext jobContext = element.getJobContext();
        JobStatus childJobStatus = jobStatus.getChild(element.getJobContext());
        JobContext newJobContext = null;
        try {
            newJobContext = jobRestartTableHandler.getRestartJobContext(
                    jobContext, childJobStatus);
        } catch (JobException e) {
            log.error(e.getMessage(), e);
            childJobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
            return;
        }

        //Iς݃Wu͎sȂB
        if (!childJobStatus.isContinue()) {
            return;
        }
        
        newJobContext.setRestartable(true);
        childJobStatus.setRestartable(true);

        element.setJobContext(newJobContext);
        
        RestartJobStatus restartJobStatus = 
            new RestartJobStatus(childJobStatus);
        jobManager.work(element, restartJobStatus);
    }
}
